/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDateTime;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.columns.AbstractColumnType;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.columns.datetimes.DateTimeStringParser;
import tech.tablesaw.columns.datetimes.PackedDateTime;
import tech.tablesaw.io.csv.CsvReadOptions;

public class DateTimeColumnType
extends AbstractColumnType<LocalDateTime> {
    public static final DateTimeStringParser DEFAULT_PARSER = new DateTimeStringParser(ColumnType.LOCAL_DATE_TIME);
    public static final DateTimeColumnType INSTANCE = new DateTimeColumnType(Long.valueOf(Long.MIN_VALUE), 8, "LOCAL_DATE_TIME", "DateTime");

    private DateTimeColumnType(Comparable<?> missingValue, int byteSize, String name, String printerFriendlyName) {
        super(missingValue, byteSize, name, printerFriendlyName);
    }

    public DateTimeColumn create(String name) {
        return DateTimeColumn.create(name);
    }

    @Override
    public StringParser<LocalDateTime> defaultParser() {
        return new DateTimeStringParser(this);
    }

    @Override
    public DateTimeStringParser customParser(CsvReadOptions options) {
        return new DateTimeStringParser(this, options);
    }

    @Override
    public void copy(IntArrayList rows, Column<LocalDateTime> oldColumn, Column<LocalDateTime> newColumn) {
        DateTimeColumn oldDateTime = (DateTimeColumn)oldColumn;
        DateTimeColumn newDateTime = (DateTimeColumn)newColumn;
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newDateTime.appendInternal(oldDateTime.getLongInternal(index));
        }
    }

    @Override
    public void copyFromRows(IntArrayList rows, Column<LocalDateTime> newColumn, Row row) {
        DateTimeColumn dateTimes = (DateTimeColumn)newColumn;
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            row.at(index);
            PackedDateTime dateTime = row.getPackedDateTime(newColumn.name());
            dateTimes.appendInternal(dateTime.getPackedValue());
        }
    }

    @Override
    public boolean compare(int rowNumber, Column temp, Column original) {
        DateTimeColumn tempDateTime = (DateTimeColumn)temp;
        DateTimeColumn originalDateTime = (DateTimeColumn)original;
        return originalDateTime.getLongInternal(rowNumber) == tempDateTime.getLongInternal(tempDateTime.size() - 1);
    }
}

