/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.columns.dates.DateColumnFormatter;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.dates.DateFillers;
import tech.tablesaw.columns.dates.DateFilters;
import tech.tablesaw.columns.dates.DateMapFunctions;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.comparators.DescendingIntComparator;

public class DateColumn
extends AbstractColumn<LocalDate>
implements DateFilters,
DateFillers<DateColumn>,
DateMapFunctions,
CategoricalColumn<LocalDate> {
    public static final int MISSING_VALUE = (Integer)ColumnType.LOCAL_DATE.getMissingValue();
    private final IntComparator reverseIntComparator = DescendingIntComparator.instance();
    private IntArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        int f1 = this.getIntInternal(r1);
        int f2 = this.getIntInternal(r2);
        return Integer.compare(f1, f2);
    };
    private DateColumnFormatter printFormatter = new DateColumnFormatter();

    public static DateColumn create(String name) {
        return DateColumn.create(name, 128);
    }

    public static DateColumn create(String name, int initialSize) {
        return new DateColumn(name, new IntArrayList(initialSize));
    }

    public static DateColumn create(String name, List<LocalDate> data) {
        DateColumn column = new DateColumn(name, new IntArrayList(data.size()));
        for (LocalDate date : data) {
            column.append(date);
        }
        return column;
    }

    public static DateColumn create(String name, LocalDate[] data) {
        DateColumn column = new DateColumn(name, new IntArrayList(data.length));
        for (LocalDate date : data) {
            column.append(date);
        }
        return column;
    }

    private DateColumn(String name, IntArrayList data) {
        super(ColumnType.LOCAL_DATE, name);
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public DateColumn appendInternal(int f) {
        this.data.add(f);
        return this;
    }

    @Override
    public IntArrayList data() {
        return this.data;
    }

    public DateColumn set(int index, int value) {
        this.data.set(index, value);
        return this;
    }

    public DateColumn set(int index, LocalDate value) {
        this.data.set(index, PackedLocalDate.pack(value));
        return this;
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter, String missingValueString) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        Preconditions.checkNotNull((Object)missingValueString);
        this.printFormatter = new DateColumnFormatter(dateTimeFormatter, missingValueString);
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        this.printFormatter = new DateColumnFormatter(dateTimeFormatter);
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.getPackedDate(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return PackedLocalDate.toDateString(this.getPackedDate(row));
    }

    public DateColumn emptyCopy() {
        return this.emptyCopy(128);
    }

    public DateColumn emptyCopy(int rowSize) {
        DateColumn copy = DateColumn.create(this.name(), rowSize);
        copy.printFormatter = this.printFormatter;
        return copy;
    }

    public DateColumn copy() {
        DateColumn copy = this.emptyCopy(this.data.size());
        copy.data = this.data.clone();
        return copy;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public DateColumn lead(int n) {
        DateColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public DateColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        int[] dest = new int[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = MISSING_VALUE;
        }
        System.arraycopy(this.data.toIntArray(), srcPos, dest, destPos, length);
        DateColumn copy = this.emptyCopy(this.size());
        copy.data = new IntArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)this.reverseIntComparator);
    }

    @Override
    public int countUnique() {
        IntOpenHashSet ints = new IntOpenHashSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            ints.add(this.data.getInt(i));
        }
        return ints.size();
    }

    public DateColumn unique() {
        IntOpenHashSet ints = new IntOpenHashSet(this.data.size());
        for (int i = 0; i < this.size(); ++i) {
            ints.add(this.data.getInt(i));
        }
        DateColumn copy = this.emptyCopy(ints.size());
        copy.setName(this.name() + " Unique values");
        copy.data = IntArrayList.wrap((int[])ints.toIntArray());
        return copy;
    }

    public LocalDate firstElement() {
        if (this.isEmpty()) {
            return null;
        }
        return PackedLocalDate.asLocalDate(this.getPackedDate(0));
    }

    @Override
    public LocalDate max() {
        if (this.isEmpty()) {
            return null;
        }
        Integer max = null;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (MISSING_VALUE == aData) continue;
            if (max == null) {
                max = aData;
                continue;
            }
            max = max > aData ? max : aData;
        }
        if (max == null) {
            return null;
        }
        return PackedLocalDate.asLocalDate(max);
    }

    @Override
    public LocalDate min() {
        if (this.isEmpty()) {
            return null;
        }
        Integer min = null;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (MISSING_VALUE == aData) continue;
            if (min == null) {
                min = aData;
                continue;
            }
            min = min < aData ? min : aData;
        }
        if (min == null) {
            return null;
        }
        return PackedLocalDate.asLocalDate(min);
    }

    public DateColumn set(Selection rowSelection, LocalDate newValue) {
        int packed = PackedLocalDate.pack(newValue);
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, packed);
        }
        return this;
    }

    public DateColumn appendMissing() {
        this.appendInternal(MISSING_VALUE);
        return this;
    }

    @Override
    public LocalDate get(int index) {
        return PackedLocalDate.asLocalDate(this.getPackedDate(index));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public DateColumn append(LocalDate value) {
        return this.appendInternal(PackedLocalDate.pack(value));
    }

    public DateColumn appendCell(String string) {
        this.appendInternal(PackedLocalDate.pack(DateColumnType.DEFAULT_PARSER.parse(string)));
        return this;
    }

    public DateColumn appendCell(String string, StringParser parser) {
        this.appendInternal(PackedLocalDate.pack((LocalDate)parser.parse(string)));
        return this;
    }

    @Override
    public int getIntInternal(int index) {
        return this.data.getInt(index);
    }

    int getPackedDate(int index) {
        return this.getIntInternal(index);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(new Column[]{measure});
        table.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    public static boolean valueIsMissing(int i) {
        return i == MISSING_VALUE;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getPackedDate(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    public DateColumn append(Column<LocalDate> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DateColumn dateColumn = (DateColumn)column;
        for (int i = 0; i < dateColumn.size(); ++i) {
            this.appendInternal(dateColumn.getPackedDate(i));
        }
        return this;
    }

    public List<LocalDate> top(int n) {
        ArrayList<LocalDate> top = new ArrayList<LocalDate>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)DescendingIntComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalDate.asLocalDate(values[i]));
        }
        return top;
    }

    public List<LocalDate> bottom(int n) {
        ArrayList<LocalDate> bottom = new ArrayList<LocalDate>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedLocalDate.asLocalDate(values[i]));
        }
        return bottom;
    }

    public IntIterator intIterator() {
        return this.data.iterator();
    }

    public DateColumn removeMissing() {
        DateColumn noMissing = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (DateColumn.valueIsMissing(i)) continue;
            noMissing.appendInternal(i);
        }
        return noMissing;
    }

    public List<LocalDate> asList() {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(this.size());
        for (LocalDate localDate : this) {
            dates.add(localDate);
        }
        return dates;
    }

    @Override
    public DateColumn where(Selection selection) {
        return (DateColumn)this.subset(selection);
    }

    public Set<LocalDate> asSet() {
        HashSet<LocalDate> dates = new HashSet<LocalDate>();
        DateColumn unique = this.unique();
        for (LocalDate d : unique) {
            dates.add(d);
        }
        return dates;
    }

    public boolean contains(LocalDate localDate) {
        int date = PackedLocalDate.pack(localDate);
        return this.data().contains(date);
    }

    @Override
    public double[] asDoubleArray() {
        double[] doubles = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.data.getInt(i);
        }
        return doubles;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return DateColumn.valueIsMissing(this.getIntInternal(rowNumber));
    }

    @Override
    public double getDouble(int i) {
        return this.getIntInternal(i);
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putInt(this.getPackedDate(rowNumber)).array();
    }

    @Override
    public Iterator<LocalDate> iterator() {
        return new Iterator<LocalDate>(){
            final IntIterator intIterator;
            {
                this.intIterator = DateColumn.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.intIterator.hasNext();
            }

            @Override
            public LocalDate next() {
                return PackedLocalDate.asLocalDate(this.intIterator.nextInt());
            }
        };
    }

    private DateColumn fillWith(int count, Iterator<LocalDate> iterator, Consumer<LocalDate> acceptor) {
        for (int r = 0; r < count && iterator.hasNext(); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public DateColumn fillWith(Iterator<LocalDate> iterator) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterator, (LocalDate date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDate)date);
        });
        return this;
    }

    private DateColumn fillWith(int count, Iterable<LocalDate> iterable, Consumer<LocalDate> acceptor) {
        Iterator<LocalDate> iterator = null;
        for (int r = 0; r < count && (iterator != null && iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public DateColumn fillWith(Iterable<LocalDate> iterable) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterable, (LocalDate date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDate)date);
        });
        return this;
    }

    private DateColumn fillWith(int count, Supplier<LocalDate> supplier, Consumer<LocalDate> acceptor) {
        for (int r = 0; r < count; ++r) {
            try {
                acceptor.accept(supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public DateColumn fillWith(Supplier<LocalDate> supplier) {
        int[] r = new int[1];
        this.fillWith(this.size(), supplier, (LocalDate date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalDate)date);
        });
        return this;
    }

    @Override
    public int[] asIntArray() {
        return this.data.toArray(new int[this.size()]);
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new LocalDate[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public int compare(LocalDate o1, LocalDate o2) {
        return o1.compareTo(o2);
    }
}

