/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.api.Row;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.SkipColumnType;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.io.csv.CsvReadOptions;

public interface ColumnType<T> {
    public static final Map<String, ColumnType> values = new HashMap<String, ColumnType>();
    public static final ColumnType<Boolean> BOOLEAN = BooleanColumnType.INSTANCE;
    public static final ColumnType<String> STRING = StringColumnType.INSTANCE;
    public static final ColumnType<Double> DOUBLE = DoubleColumnType.INSTANCE;
    public static final ColumnType<LocalDate> LOCAL_DATE = DateColumnType.INSTANCE;
    public static final ColumnType<LocalDateTime> LOCAL_DATE_TIME = DateTimeColumnType.INSTANCE;
    public static final ColumnType<LocalTime> LOCAL_TIME = TimeColumnType.INSTANCE;
    public static final ColumnType SKIP = SkipColumnType.INSTANCE;

    public static void register(ColumnType type) {
        values.put(type.name(), type);
    }

    public static ColumnType[] values() {
        return values.values().toArray(new ColumnType[0]);
    }

    public static ColumnType valueOf(String name) {
        Preconditions.checkNotNull((Object)name);
        ColumnType result = values.get(name);
        if (result == null) {
            throw new IllegalArgumentException(name + " is not a registered column type.");
        }
        return result;
    }

    public Column<T> create(String var1);

    public String name();

    public Comparable<?> getMissingValue();

    public int byteSize();

    public String getPrinterFriendlyName();

    public StringParser defaultParser();

    public StringParser customParser(CsvReadOptions var1);

    public void copy(IntArrayList var1, Column<T> var2, Column<T> var3);

    public void copyFromRows(IntArrayList var1, Column<T> var2, Row var3);

    public boolean compare(int var1, Column<T> var2, Column<T> var3);

    public void appendColumns(Column<T> var1, Column<T> var2);
}

