/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.collect.Streams;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.index.IntIndex;
import tech.tablesaw.index.LongIndex;
import tech.tablesaw.index.StringIndex;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class DataFrameJoiner {
    private static final String TABLE_ALIAS = "T";
    private final Table table;
    private final Column column;
    private AtomicInteger joinTableId = new AtomicInteger(2);

    public DataFrameJoiner(Table table, String column) {
        this.table = table;
        this.column = table.column(column);
    }

    public Table inner(Table ... tables) {
        return this.inner(false, tables);
    }

    public Table inner(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.inner(table2, this.column.name(), allowDuplicateColumnNames);
        }
        return joined;
    }

    public Table inner(Table table2, String col2Name) {
        return this.inner(table2, col2Name, false);
    }

    public Table inner(Table table2, String col2Name, boolean allowDuplicateColumnNames) {
        return this.joinInternal(table2, col2Name, false, allowDuplicateColumnNames);
    }

    private Table joinInternal(Table table2, String col2Name, boolean outer, boolean allowDuplicates) {
        if (allowDuplicates) {
            this.renameColumnsWithDuplicateNames(table2, col2Name);
        }
        Table result = this.emptyTableFromColumns(this.table, table2, col2Name);
        if (this.column instanceof DateColumn) {
            IntIndex index = new IntIndex(table2.dateColumn(col2Name));
            DateColumn col1 = (DateColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                int value = col1.getIntInternal(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissingLeftJoin(result, table1Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof DateTimeColumn) {
            LongIndex index = new LongIndex(table2.dateTimeColumn(col2Name));
            DateTimeColumn col1 = (DateTimeColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                long value = col1.getLongInternal(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissingLeftJoin(result, table1Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof TimeColumn) {
            IntIndex index = new IntIndex(table2.timeColumn(col2Name));
            TimeColumn col1 = (TimeColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                int value = col1.getIntInternal(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissingLeftJoin(result, table1Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof StringColumn) {
            StringIndex index = new StringIndex(table2.stringColumn(col2Name));
            StringColumn col1 = (StringColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                String value = col1.get(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissingLeftJoin(result, table1Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else if (this.column instanceof NumberColumn) {
            LongIndex index = new LongIndex(table2.numberColumn(col2Name));
            NumberColumn col1 = (NumberColumn)this.column;
            for (int i = 0; i < col1.size(); ++i) {
                long value = col1.getLong(i);
                Table table1Rows = this.table.where(Selection.with(i));
                Table table2Rows = table2.where(index.get(value));
                table2Rows.removeColumns(col2Name);
                if (outer && table2Rows.isEmpty()) {
                    this.withMissingLeftJoin(result, table1Rows);
                    continue;
                }
                this.crossProduct(result, table1Rows, table2Rows);
            }
        } else {
            throw new IllegalArgumentException("Joining is supported on numeric, string, and date-like columns. Column " + this.column.name() + " is of type " + this.column.type());
        }
        return result;
    }

    private void renameColumnsWithDuplicateNames(Table table2, String col2Name) {
        String table2Alias = TABLE_ALIAS + this.joinTableId.getAndIncrement();
        for (Column table2Column : table2.columns()) {
            String columnName = table2Column.name();
            if (!this.table.columnNames().contains(columnName) || columnName.equalsIgnoreCase(col2Name)) continue;
            table2Column.setName(this.newName(table2Alias, columnName));
        }
    }

    private String newName(String table2Alias, String columnName) {
        return table2Alias + "." + columnName;
    }

    public Table fullOuter(Table ... tables) {
        return this.fullOuter(false, tables);
    }

    public Table fullOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.fullOuter(table2, this.column.name(), allowDuplicateColumnNames);
        }
        return joined;
    }

    public Table fullOuter(Table table2, String col2Name) {
        return this.fullOuter(table2, col2Name, false);
    }

    public Table fullOuter(Table table2, String col2Name, boolean allowDuplicateColumnNames) {
        Column col2;
        Object index;
        Table result = this.joinInternal(table2, col2Name, true, allowDuplicateColumnNames);
        BitmapBackedSelection selection = new BitmapBackedSelection();
        if (this.column instanceof DateColumn) {
            index = new IntIndex(result.dateColumn(col2Name));
            col2 = (DateColumn)table2.column(col2Name);
            for (int i = 0; i < ((DateColumn)col2).size(); ++i) {
                int value = ((DateColumn)col2).getIntInternal(i);
                if (!((IntIndex)index).get(value).isEmpty()) continue;
                selection.add(i);
            }
        } else if (this.column instanceof DateTimeColumn) {
            index = new LongIndex(result.dateTimeColumn(col2Name));
            col2 = (DateTimeColumn)table2.column(col2Name);
            for (int i = 0; i < ((DateTimeColumn)col2).size(); ++i) {
                long value = ((DateTimeColumn)col2).getLongInternal(i);
                if (!((LongIndex)index).get(value).isEmpty()) continue;
                selection.add(i);
            }
        } else if (this.column instanceof TimeColumn) {
            index = new IntIndex(result.timeColumn(col2Name));
            col2 = (TimeColumn)table2.column(col2Name);
            for (int i = 0; i < ((TimeColumn)col2).size(); ++i) {
                int value = ((TimeColumn)col2).getIntInternal(i);
                if (!((IntIndex)index).get(value).isEmpty()) continue;
                selection.add(i);
            }
        } else if (this.column instanceof StringColumn) {
            index = new StringIndex(result.stringColumn(col2Name));
            col2 = (StringColumn)table2.column(col2Name);
            for (int i = 0; i < ((StringColumn)col2).size(); ++i) {
                String value = ((StringColumn)col2).get(i);
                if (!((StringIndex)index).get(value).isEmpty()) continue;
                selection.add(i);
            }
        } else if (this.column instanceof NumberColumn) {
            index = new LongIndex(result.numberColumn(col2Name));
            col2 = (NumberColumn)table2.column(col2Name);
            for (int i = 0; i < col2.size(); ++i) {
                long value = col2.getLong(i);
                if (!((LongIndex)index).get(value).isEmpty()) continue;
                selection.add(i);
            }
        } else {
            throw new IllegalArgumentException("Joining is supported on numeric, string, and date-like columns. Column " + this.column.name() + " is of type " + this.column.type());
        }
        Table table2OnlyRows = table2.where(selection);
        Column joinColumn = table2OnlyRows.column(col2Name);
        table2OnlyRows.removeColumns(joinColumn);
        this.withMissingRightJoin(result, joinColumn, table2OnlyRows);
        return result;
    }

    public Table leftOuter(Table ... tables) {
        return this.leftOuter(false, tables);
    }

    public Table leftOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.leftOuter(table2, this.column.name(), allowDuplicateColumnNames);
        }
        return joined;
    }

    public Table leftOuter(Table table2, String col2Name) {
        return this.leftOuter(table2, col2Name, false);
    }

    public Table leftOuter(Table table2, String col2Name, boolean allowDuplicateColumnNames) {
        return this.joinInternal(table2, col2Name, true, allowDuplicateColumnNames);
    }

    public Table rightOuter(Table ... tables) {
        return this.rightOuter(false, tables);
    }

    public Table rightOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.rightOuter(table2, this.column.name(), allowDuplicateColumnNames);
        }
        return joined;
    }

    public Table rightOuter(Table table2, String col2Name) {
        return this.rightOuter(table2, col2Name, false);
    }

    public Table rightOuter(Table table2, String col2Name, boolean allowDuplicateColumnNames) {
        Table leftOuter = table2.join(col2Name).leftOuter(this.table, this.column.name(), allowDuplicateColumnNames);
        Table result = Table.create(leftOuter.name());
        for (String name : this.table.columnNames()) {
            result.addColumns(leftOuter.column(name));
        }
        for (String name : table2.columnNames()) {
            if (result.columnNames().contains(name)) continue;
            result.addColumns(leftOuter.column(name));
        }
        return result;
    }

    private Table emptyTableFromColumns(Table table1, Table table2, String col2Name) {
        Column[] cols = (Column[])Streams.concat((Stream[])new Stream[]{table1.columns().stream(), table2.columns().stream().filter(c -> !c.name().equalsIgnoreCase(col2Name))}).map(col -> col.emptyCopy(col.size())).toArray(Column[]::new);
        return Table.create(table1.name(), cols);
    }

    private void crossProduct(Table destination, Table table1, Table table2) {
        for (int c = 0; c < table1.columnCount() + table2.columnCount(); ++c) {
            for (int r1 = 0; r1 < table1.rowCount(); ++r1) {
                for (int r2 = 0; r2 < table2.rowCount(); ++r2) {
                    if (c < table1.columnCount()) {
                        destination.column(c).appendCell(table1.getUnformatted(r1, c));
                        continue;
                    }
                    destination.column(c).appendCell(table2.getUnformatted(r2, c - table1.columnCount()));
                }
            }
        }
    }

    private void withMissingLeftJoin(Table destination, Table table1) {
        for (int c = 0; c < destination.columnCount(); ++c) {
            for (int r1 = 0; r1 < table1.rowCount(); ++r1) {
                if (c < table1.columnCount()) {
                    destination.column(c).appendCell(table1.getUnformatted(r1, c));
                    continue;
                }
                destination.column(c).appendMissing();
            }
        }
    }

    private void withMissingRightJoin(Table destination, Column joinColumn, Table table2) {
        int t2StartCol = destination.columnCount() - table2.columnCount();
        for (int c = 0; c < destination.columnCount(); ++c) {
            if (destination.column(c).name().equalsIgnoreCase(joinColumn.name())) {
                for (int r = 0; r < joinColumn.size(); ++r) {
                    destination.column(c).appendCell(joinColumn.getUnformattedString(r));
                }
                continue;
            }
            for (int r2 = 0; r2 < table2.rowCount(); ++r2) {
                if (c < t2StartCol) {
                    destination.column(c).appendMissing();
                    continue;
                }
                destination.column(c).appendCell(table2.getUnformatted(r2, c - t2StartCol));
            }
        }
    }
}

