/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.columns.AbstractColumnType;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleStringParser;
import tech.tablesaw.io.csv.CsvReadOptions;

public class DoubleColumnType
extends AbstractColumnType {
    public static final DoubleStringParser DEFAULT_PARSER = new DoubleStringParser(ColumnType.DOUBLE);
    public static final DoubleColumnType INSTANCE = new DoubleColumnType(Double.valueOf(Double.NaN), 8, "DOUBLE", "Double");

    private DoubleColumnType(Comparable<?> missingValue, int byteSize, String name, String printerFriendlyName) {
        super(missingValue, byteSize, name, printerFriendlyName);
    }

    @Override
    public DoubleColumn create(String name) {
        return DoubleColumn.create(name);
    }

    @Override
    public DoubleStringParser defaultParser() {
        return DEFAULT_PARSER;
    }

    @Override
    public DoubleStringParser customParser(CsvReadOptions options) {
        return new DoubleStringParser(this, options);
    }

    @Override
    public void copy(IntArrayList rows, Column oldColumn, Column newColumn) {
        DoubleColumn oldDouble = (DoubleColumn)oldColumn;
        DoubleColumn newDouble = (DoubleColumn)newColumn;
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newDouble.append(oldDouble.get(index));
        }
    }

    @Override
    public void copyFromRows(IntArrayList rows, Column newColumn, Row row) {
        DoubleColumn newDate = (DoubleColumn)newColumn;
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            row.at(index);
            double value = row.getDouble(newColumn.name());
            newDate.append(value);
        }
    }

    @Override
    public boolean compare(int rowNumber, Column temp, Column original) {
        DoubleColumn tempDouble = (DoubleColumn)temp;
        DoubleColumn originalDouble = (DoubleColumn)original;
        return originalDouble.get(rowNumber) == tempDouble.get(tempDouble.size() - 1);
    }
}

