/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.booleans;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Row;
import tech.tablesaw.columns.AbstractColumnType;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.booleans.BooleanStringParser;
import tech.tablesaw.io.csv.CsvReadOptions;

public class BooleanColumnType
extends AbstractColumnType {
    public static final BooleanStringParser DEFAULT_PARSER = new BooleanStringParser(ColumnType.BOOLEAN);
    public static final BooleanColumnType INSTANCE = new BooleanColumnType(Byte.valueOf((byte)-128), 1, "BOOLEAN", "Boolean");

    private BooleanColumnType(Comparable<?> missingValue, int byteSize, String name, String printerFriendlyName) {
        super(missingValue, byteSize, name, printerFriendlyName);
    }

    @Override
    public Column create(String name) {
        return BooleanColumn.create(name);
    }

    @Override
    public BooleanStringParser defaultParser() {
        return DEFAULT_PARSER;
    }

    @Override
    public BooleanStringParser customParser(CsvReadOptions readOptions) {
        return new BooleanStringParser(this, readOptions);
    }

    @Override
    public void copy(IntArrayList rows, Column oldColumn, Column newColumn) {
        BooleanColumn oldBoolean = (BooleanColumn)oldColumn;
        BooleanColumn newBoolean = (BooleanColumn)newColumn;
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newBoolean.append(oldBoolean.get(index));
        }
    }

    @Override
    public void copyFromRows(IntArrayList rows, Column newColumn, Row row) {
        BooleanColumn newBoolean = (BooleanColumn)newColumn;
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            row.at(index);
            newBoolean.append(row.getBoolean(newColumn.name()));
        }
    }

    @Override
    public boolean compare(int rowNumber, Column temp, Column original) {
        BooleanColumn tempBoolean = (BooleanColumn)temp;
        BooleanColumn originalBoolean = (BooleanColumn)original;
        return originalBoolean.get(rowNumber) == tempBoolean.get(tempBoolean.size() - 1);
    }
}

