/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DateAndTimePredicates;
import tech.tablesaw.columns.StringParser;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.columns.times.TimeColumnFormatter;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.columns.times.TimeFillers;
import tech.tablesaw.columns.times.TimeFilters;
import tech.tablesaw.columns.times.TimeMapFunctions;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.comparators.DescendingIntComparator;

public class TimeColumn
extends AbstractColumn<LocalTime, TimeColumn>
implements CategoricalColumn,
Iterable<LocalTime>,
TimeFilters,
TimeFillers<TimeColumn>,
TimeMapFunctions {
    public static final int MISSING_VALUE = (Integer)ColumnType.LOCAL_TIME.getMissingValue();
    private final IntComparator descendingIntComparator = DescendingIntComparator.instance();
    private TimeColumnFormatter printFormatter = new TimeColumnFormatter();
    private IntArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        int f1 = this.getIntInternal(r1);
        int f2 = this.getIntInternal(r2);
        return Integer.compare(f1, f2);
    };

    private TimeColumn(String name, IntArrayList times) {
        super(ColumnType.LOCAL_TIME, name);
        this.data = times;
    }

    public static boolean valueIsMissing(int i) {
        return i == MISSING_VALUE;
    }

    public static TimeColumn create(String name) {
        return TimeColumn.create(name, 128);
    }

    public static TimeColumn create(String name, List<LocalTime> data) {
        TimeColumn column = new TimeColumn(name, new IntArrayList(data.size()));
        for (LocalTime time : data) {
            column.append(time);
        }
        return column;
    }

    public static TimeColumn create(String name, LocalTime[] data) {
        TimeColumn column = new TimeColumn(name, new IntArrayList(data.length));
        for (LocalTime time : data) {
            column.append(time);
        }
        return column;
    }

    public static TimeColumn create(String name, int initialSize) {
        return new TimeColumn(name, new IntArrayList(initialSize));
    }

    @Override
    public TimeColumn appendMissing() {
        this.appendInternal(MISSING_VALUE);
        return this;
    }

    @Override
    public TimeColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        int[] dest = new int[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = MISSING_VALUE;
        }
        System.arraycopy(this.data.toIntArray(), srcPos, dest, destPos, length);
        TimeColumn copy = this.emptyCopy(this.size());
        copy.data = new IntArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return TimeColumn.valueIsMissing(this.getIntInternal(rowNumber));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public TimeColumn appendInternal(int f) {
        this.data.add(f);
        return this;
    }

    public TimeColumn append(LocalTime time) {
        int value = time == null ? MISSING_VALUE : PackedLocalTime.pack(time);
        this.appendInternal(value);
        return this;
    }

    @Override
    public TimeColumn removeMissing() {
        TimeColumn noMissing = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (TimeColumn.valueIsMissing(i)) continue;
            noMissing.appendInternal(i);
        }
        return noMissing;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.getPackedTime(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return PackedLocalTime.toShortTimeString(this.getPackedTime(row));
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter, String missingValueString) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        Preconditions.checkNotNull((Object)missingValueString);
        this.printFormatter = new TimeColumnFormatter(dateTimeFormatter, missingValueString);
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        this.printFormatter = new TimeColumnFormatter(dateTimeFormatter);
    }

    @Override
    public TimeColumn emptyCopy() {
        return this.emptyCopy(128);
    }

    @Override
    public TimeColumn emptyCopy(int rowSize) {
        TimeColumn column = TimeColumn.create(this.name(), rowSize);
        column.printFormatter = this.printFormatter;
        return column;
    }

    @Override
    public TimeColumn copy() {
        TimeColumn column = this.emptyCopy(this.size());
        column.data = this.data.clone();
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public List<LocalTime> asList() {
        ArrayList<LocalTime> times = new ArrayList<LocalTime>();
        for (LocalTime time : this) {
            times.add(time);
        }
        return times;
    }

    @Override
    public void sortAscending() {
        int[] sorted = this.data.toIntArray();
        Arrays.parallelSort(sorted);
        this.data = new IntArrayList(sorted);
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)this.descendingIntComparator);
    }

    public LocalTime max() {
        if (this.isEmpty()) {
            return null;
        }
        int max = this.getIntInternal(0);
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            max = max > aData ? max : aData;
        }
        if (max == MISSING_VALUE) {
            return null;
        }
        return PackedLocalTime.asLocalTime(max);
    }

    @Override
    public LocalTime min() {
        if (this.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (aData == MISSING_VALUE) continue;
            min = min < aData ? min : aData;
        }
        if (min == Integer.MAX_VALUE) {
            return null;
        }
        return PackedLocalTime.asLocalTime(min);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(measure);
        table.addColumns(value);
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        IntOpenHashSet hashSet = new IntOpenHashSet((IntCollection)this.data);
        hashSet.remove(MISSING_VALUE);
        return hashSet.size();
    }

    @Override
    public TimeColumn unique() {
        IntOpenHashSet ints = new IntOpenHashSet((IntCollection)this.data);
        TimeColumn column = this.emptyCopy(ints.size());
        column.data = IntArrayList.wrap((int[])ints.toIntArray());
        column.setName(this.name() + " Unique values");
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public TimeColumn appendCell(String object) {
        this.appendInternal(PackedLocalTime.pack(TimeColumnType.DEFAULT_PARSER.parse(object)));
        return this;
    }

    @Override
    public TimeColumn appendCell(String object, StringParser parser) {
        this.appendInternal(PackedLocalTime.pack((LocalTime)parser.parse(object)));
        return this;
    }

    @Override
    public int getIntInternal(int index) {
        return this.data.getInt(index);
    }

    int getPackedTime(int index) {
        return this.getIntInternal(index);
    }

    @Override
    public LocalTime get(int index) {
        return PackedLocalTime.asLocalTime(this.getIntInternal(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public IntArrayList data() {
        return this.data;
    }

    @Override
    public double getDouble(int i) {
        return this.getIntInternal(i);
    }

    @Override
    public double[] asDoubleArray() {
        double[] doubles = new double[this.data.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.data.getInt(i);
        }
        return doubles;
    }

    @Override
    public String toString() {
        return "LocalTime column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        TimeColumn intColumn = (TimeColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.appendInternal(intColumn.getIntInternal(i));
        }
    }

    public List<LocalTime> top(int n) {
        ArrayList<LocalTime> top = new ArrayList<LocalTime>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)this.descendingIntComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalTime.asLocalTime(values[i]));
        }
        return top;
    }

    public List<LocalTime> bottom(int n) {
        ArrayList<LocalTime> bottom = new ArrayList<LocalTime>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        int validCount = 0;
        for (int rowCount = 0; validCount < n && rowCount < this.size(); ++rowCount) {
            int value = values[rowCount];
            if (value == MISSING_VALUE) continue;
            bottom.add(PackedLocalTime.asLocalTime(value));
            ++validCount;
        }
        return bottom;
    }

    @Override
    public TimeColumn set(int index, int value) {
        this.data.set(index, value);
        return this;
    }

    @Override
    public TimeColumn set(int index, LocalTime value) {
        this.set(index, PackedLocalTime.pack(value));
        return this;
    }

    public TimeColumn set(Selection rowSelection, LocalTime newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public IntIterator intIterator() {
        return this.data.iterator();
    }

    Set<LocalTime> asSet() {
        HashSet<LocalTime> times = new HashSet<LocalTime>();
        TimeColumn unique = this.unique();
        for (LocalTime t : unique) {
            times.add(t);
        }
        return times;
    }

    public boolean contains(LocalTime time) {
        int t = PackedLocalTime.pack(time);
        return this.data().contains(t);
    }

    @Override
    public Selection isMissing() {
        return this.eval(DateAndTimePredicates.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.eval(DateAndTimePredicates.isNotMissing);
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putInt(this.getIntInternal(rowNumber)).array();
    }

    @Override
    public Iterator<LocalTime> iterator() {
        return new Iterator<LocalTime>(){
            final IntIterator intIterator;
            {
                this.intIterator = TimeColumn.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.intIterator.hasNext();
            }

            @Override
            public LocalTime next() {
                return PackedLocalTime.asLocalTime(this.intIterator.nextInt());
            }
        };
    }

    @Override
    public TimeColumn where(Selection selection) {
        return (TimeColumn)this.subset(selection);
    }

    private TimeColumn fillWith(int count, Iterator<LocalTime> iterator, Consumer<LocalTime> acceptor) {
        for (int r = 0; r < count && iterator.hasNext(); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new LocalTime[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public TimeColumn fillWith(Iterator<LocalTime> iterator) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterator, (LocalTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalTime)date);
        });
        return this;
    }

    private TimeColumn fillWith(int count, Iterable<LocalTime> iterable, Consumer<LocalTime> acceptor) {
        Iterator<LocalTime> iterator = null;
        for (int r = 0; r < count && (iterator != null && iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public TimeColumn fillWith(Iterable<LocalTime> iterable) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterable, (LocalTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalTime)date);
        });
        return this;
    }

    private TimeColumn fillWith(int count, Supplier<LocalTime> supplier, Consumer<LocalTime> acceptor) {
        for (int r = 0; r < count; ++r) {
            try {
                acceptor.accept(supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public TimeColumn fillWith(Supplier<LocalTime> supplier) {
        int[] r = new int[1];
        this.fillWith(this.size(), supplier, (LocalTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalTime)date);
        });
        return this;
    }

    @Override
    public int[] asIntArray() {
        return this.data.toArray(new int[this.size()]);
    }

    @Override
    public LocalTime getObject(int index) {
        return this.get(index);
    }
}

