/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import tech.tablesaw.api.NumberColumn;

public class NumberColumnFormatter {
    private final NumberFormat format;
    private String missingString = "";

    public static NumberColumnFormatter percent(int fractionalDigits) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setGroupingUsed(false);
        format.setMinimumFractionDigits(fractionalDigits);
        format.setMaximumFractionDigits(fractionalDigits);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter ints() {
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(false);
        ((NumberFormat)format).setMinimumFractionDigits(0);
        ((NumberFormat)format).setMaximumFractionDigits(0);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter intsWithGrouping() {
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(true);
        ((NumberFormat)format).setMinimumFractionDigits(0);
        ((NumberFormat)format).setMaximumFractionDigits(0);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter fixedWithGrouping(int fractionalDigits) {
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(true);
        ((NumberFormat)format).setMinimumFractionDigits(fractionalDigits);
        ((NumberFormat)format).setMaximumFractionDigits(fractionalDigits);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter currency(String language, String country) {
        NumberFormat format = NumberFormat.getCurrencyInstance(new Locale(language, country));
        return new NumberColumnFormatter(format);
    }

    public NumberColumnFormatter() {
        this.format = null;
    }

    public NumberColumnFormatter(NumberFormat format) {
        this.format = format;
    }

    public NumberColumnFormatter(NumberFormat format, String missingString) {
        this.format = format;
        this.missingString = missingString;
    }

    public String format(double value) {
        if (NumberColumn.valueIsMissing(value)) {
            return this.missingString;
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    public String toString() {
        return "NumberColumnFormatter{format=" + this.format + ", missingString='" + this.missingString + '\'' + '}';
    }
}

