/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.Column;

public abstract class AbstractColumn
implements Column {
    public static final int DEFAULT_ARRAY_SIZE = 128;
    private String name;
    private final ColumnType type;

    public AbstractColumn(ColumnType type, String name) {
        this.type = type;
        this.setName(name);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Column setName(String name) {
        this.name = name.trim();
        return this;
    }

    @Override
    public abstract Column appendCell(String var1);

    @Override
    public int columnWidth() {
        int width = this.name().length();
        for (int rowNum = 0; rowNum < this.size(); ++rowNum) {
            width = Math.max(width, StringUtils.length((CharSequence)this.getString(rowNum)));
        }
        return width;
    }

    @Override
    public ColumnType type() {
        return this.type;
    }

    public String toString() {
        return this.type().getPrinterFriendlyName() + " column: " + this.name();
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        for (int i = 0; i < this.size(); ++i) {
            builder.append(this.getString(i));
            builder.append('\n');
        }
        return builder.toString();
    }
}

