/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.io.UnicodeBOMInputStream;
import tech.tablesaw.io.csv.AddCellToColumnException;
import tech.tablesaw.io.csv.CsvReadOptions;

@Immutable
public class CsvReader {
    private static final Predicate<String> isBoolean = s -> TypeUtils.TRUE_STRINGS_FOR_DETECTION.contains(s) || TypeUtils.FALSE_STRINGS_FOR_DETECTION.contains(s);
    private static final Predicate<String> isDouble = s -> {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static final BiPredicate<String, Locale> isLocalDate = (s, locale) -> {
        try {
            LocalDate.parse(s, TypeUtils.DATE_FORMATTER.withLocale((Locale)locale));
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };
    private static final BiPredicate<String, Locale> isLocalTime = (s, locale) -> {
        try {
            LocalTime.parse(s, TypeUtils.TIME_DETECTION_FORMATTER.withLocale((Locale)locale));
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };
    private static final BiPredicate<String, Locale> isLocalDateTime = (s, locale) -> {
        try {
            LocalDateTime.parse(s, TypeUtils.DATE_TIME_FORMATTER.withLocale((Locale)locale));
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };

    private static boolean isLocalDate(String s, DateTimeFormatter dateTimeFormatter) {
        try {
            if (dateTimeFormatter == null) {
                LocalDate.parse(s, TypeUtils.DATE_FORMATTER);
                return true;
            }
            LocalDate.parse(s, dateTimeFormatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static boolean isLocalTime(String s, DateTimeFormatter formatter) {
        try {
            if (formatter == null) {
                LocalTime.parse(s, TypeUtils.TIME_DETECTION_FORMATTER);
                return true;
            }
            LocalDate.parse(s, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static boolean isLocalDateTime(String s, DateTimeFormatter formatter) {
        try {
            if (formatter == null) {
                LocalDateTime.parse(s, TypeUtils.DATE_TIME_FORMATTER);
                return true;
            }
            LocalDate.parse(s, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private CsvReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Table read(CsvReadOptions options) throws IOException {
        ColumnType[] types;
        byte[] bytes;
        byte[] byArray = bytes = options.reader() != null ? CharStreams.toString((Readable)options.reader()).getBytes() : null;
        if (options.columnTypes() != null) {
            types = options.columnTypes();
        } else {
            InputStream inputStream = options.reader() != null ? new ByteArrayInputStream(bytes) : new FileInputStream(options.file());
            types = CsvReader.detectColumnTypes(inputStream, options);
        }
        InputStream inputStream = options.reader() != null ? new ByteArrayInputStream(bytes) : new FileInputStream(options.file());
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(inputStream);
        ubis.skipBOM();
        CSVParser csvParser = new CSVParserBuilder().withSeparator(options.separator()).build();
        try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(ubis)).withCSVParser((ICSVParser)csvParser).build();){
            long rowNumber;
            Object[] headerNames;
            Table table = Table.create(options.tableName());
            if (options.header()) {
                headerNames = reader.readNext();
                if (headerNames == null) {
                    Table table2 = table;
                    return table2;
                }
            } else {
                headerNames = CsvReader.makeColumnNames(types);
            }
            ArrayList headerRow = Lists.newArrayList((Object[])headerNames);
            String[] columnNames = CsvReader.selectColumnNames(headerRow, types);
            CsvReader.cleanNames(headerRow);
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                String columnName = (String)headerRow.get(x);
                if (Strings.isNullOrEmpty((String)columnName)) {
                    columnName = "Column " + table.columnCount();
                }
                Column newColumn = TypeUtils.newColumn(columnName, types[x]);
                CsvReader.addFormatter(newColumn, options);
                table.addColumns(newColumn);
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
            long l = rowNumber = options.header() ? 1L : 0L;
            while (true) {
                block26: {
                    int n;
                    int[] nArray;
                    int cellIndex;
                    String[] nextLine;
                    if ((nextLine = reader.readNext()) != null) {
                        if (nextLine.length < types.length) {
                            if (nextLine.length == 1 && Strings.isNullOrEmpty((String)nextLine[0])) {
                                System.err.println("Warning: Invalid CSV file. Row " + rowNumber + " is empty. Continuing.");
                                break block26;
                            } else {
                                IndexOutOfBoundsException e = new IndexOutOfBoundsException("Row number " + rowNumber + " is too short.");
                                throw new AddCellToColumnException(e, 0, rowNumber, columnNames, nextLine);
                            }
                        }
                        if (nextLine.length > types.length) {
                            throw new RuntimeException("Row number " + rowNumber + " is too long.");
                        }
                        cellIndex = 0;
                        nArray = columnIndexes;
                        n = nArray.length;
                    } else {
                        Table table3 = table;
                        return table3;
                    }
                    for (int i = 0; i < n; ++cellIndex, ++i) {
                        int columnIndex = nArray[i];
                        Column column = table.column(cellIndex);
                        try {
                            String value = nextLine[columnIndex];
                            if (value.equals(options.missingValueIndicator())) {
                                column.appendCell("");
                                continue;
                            }
                            column.appendCell(value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new AddCellToColumnException(e, columnIndex, rowNumber, columnNames, nextLine);
                        }
                    }
                }
                ++rowNumber;
            }
        }
    }

    private static void addFormatter(Column newColumn, CsvReadOptions options) {
        switch (newColumn.type()) {
            case LOCAL_DATE_TIME: {
                ((DateTimeColumn)newColumn).setFormatter(options.dateTimeFormatter());
                return;
            }
            case LOCAL_DATE: {
                ((DateColumn)newColumn).setFormatter(options.dateFormatter());
                return;
            }
            case LOCAL_TIME: {
                ((TimeColumn)newColumn).setFormatter(options.timeFormatter());
                return;
            }
        }
    }

    private static void cleanNames(List<String> headerRow) {
        for (int i = 0; i < headerRow.size(); ++i) {
            headerRow.set(i, headerRow.get(i).trim());
        }
    }

    public static Table headerOnly(ColumnType[] types, boolean header, char columnSeparator, File file) throws IOException {
        Table table;
        FileInputStream fis = new FileInputStream(file);
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(fis);
        ubis.skipBOM();
        InputStreamReader reader = new InputStreamReader(ubis);
        BufferedReader streamReader = new BufferedReader(reader);
        CSVParser csvParser = new CSVParserBuilder().withSeparator(columnSeparator).build();
        try (CSVReader csvReader = new CSVReaderBuilder((Reader)streamReader).withCSVParser((ICSVParser)csvParser).build();){
            Object[] headerNames = header ? csvReader.readNext() : CsvReader.makeColumnNames(types);
            ArrayList headerRow = Lists.newArrayList((Object[])headerNames);
            String[] columnNames = CsvReader.selectColumnNames(headerRow, types);
            table = Table.create(file.getName());
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                Column newColumn = TypeUtils.newColumn(((String)headerRow.get(x)).trim(), types[x]);
                table.addColumns(newColumn);
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
        }
        return table;
    }

    private static Table detectedColumnTypes(String csvFileName, boolean header, char delimiter, Locale locale) throws IOException {
        File file = new File(csvFileName);
        FileInputStream stream = new FileInputStream(file);
        CsvReadOptions options = CsvReadOptions.builder(stream, "").separator(delimiter).header(header).locale(locale).sample(false).build();
        ColumnType[] types = CsvReader.detectColumnTypes(stream, options);
        Table t = CsvReader.headerOnly(types, header, delimiter, file);
        return t.structure();
    }

    public static String printColumnTypes(String csvFileName, boolean header, char delimiter, Locale locale) throws IOException {
        Table structure = CsvReader.detectedColumnTypes(csvFileName, header, delimiter, locale);
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append('\n');
        Column typeCol = structure.column("Column Type");
        Column indxCol = structure.column("Index");
        Column nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = StringUtils.rightPad((String)(structure.get(r, typeColIndex) + ","), (int)typeColWidth);
            buf.append(cell);
            buf.append(" // ");
            cell = StringUtils.rightPad((String)structure.get(r, indxColIndex), (int)indxColWidth);
            buf.append(cell);
            buf.append(' ');
            cell = StringUtils.rightPad((String)structure.get(r, nameColIndex), (int)nameColWidth);
            buf.append(cell);
            buf.append(' ');
            buf.append('\n');
        }
        buf.append("}");
        buf.append('\n');
        return buf.toString();
    }

    private static String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            header.add(names.get(i).trim());
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    private static String[] makeColumnNames(ColumnType[] types) {
        String[] header = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            header[i] = "C" + i;
        }
        return header;
    }

    public static ColumnType[] detectColumnTypes(InputStream stream, CsvReadOptions options) throws IOException {
        boolean header = options.header();
        char delimiter = options.separator();
        boolean useSampling = options.sample();
        int linesToSkip = header ? 1 : 0;
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        ArrayList columnData = new ArrayList();
        int rowCount = 0;
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(stream);
        ubis.skipBOM();
        CSVParser csvParser = new CSVParserBuilder().withSeparator(delimiter).build();
        Throwable throwable = null;
        try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(ubis)).withCSVParser((ICSVParser)csvParser).withSkipLines(linesToSkip).build();){
            String[] nextLine;
            int nextRow = 0;
            while ((nextLine = reader.readNext()) != null) {
                if (rowCount == 0) {
                    for (String aNextLine : nextLine) {
                        columnData.add(new ArrayList());
                    }
                }
                int columnNumber = 0;
                if (rowCount == nextRow) {
                    for (String field : nextLine) {
                        ((List)columnData.get(columnNumber)).add(field);
                        ++columnNumber;
                    }
                }
                if (rowCount == nextRow) {
                    nextRow = useSampling ? CsvReader.nextRow(nextRow) : CsvReader.nextRowWithoutSampling(nextRow);
                }
                ++rowCount;
            }
        }
        catch (Throwable nextLine) {
            Throwable throwable2 = nextLine;
            throw nextLine;
        }
        for (List list : columnData) {
            ColumnType detectedType = CsvReader.detectType(list, options);
            columnTypes.add(detectedType);
        }
        return columnTypes.toArray(new ColumnType[columnTypes.size()]);
    }

    private static int nextRowWithoutSampling(int nextRow) {
        return nextRow + 1;
    }

    private static int nextRow(int nextRow) {
        if (nextRow < 100) {
            return nextRow + 1;
        }
        if (nextRow < 1000) {
            return nextRow + 10;
        }
        if (nextRow < 10000) {
            return nextRow + 100;
        }
        if (nextRow < 100000) {
            return nextRow + 1000;
        }
        if (nextRow < 1000000) {
            return nextRow + 10000;
        }
        if (nextRow < 10000000) {
            return nextRow + 100000;
        }
        if (nextRow < 100000000) {
            return nextRow + 1000000;
        }
        return nextRow + 10000000;
    }

    private static ColumnType detectType(List<String> valuesList, CsvReadOptions options) {
        Locale locale = options.locale();
        DateTimeFormatter dateFormatter = options.dateFormatter();
        DateTimeFormatter timeFormatter = options.timeFormatter();
        DateTimeFormatter dateTimeFormatter = options.dateTimeFormatter();
        ColumnType[] typeArray = new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.NUMBER};
        CopyOnWriteArrayList<ColumnType> typeCandidates = new CopyOnWriteArrayList<ColumnType>(typeArray);
        for (String s : valuesList) {
            if (CsvReader.isMissing(s, options)) continue;
            if (dateTimeFormatter != null) {
                if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE_TIME) && !CsvReader.isLocalDateTime(s, dateTimeFormatter)) {
                    typeCandidates.remove((Object)ColumnType.LOCAL_DATE_TIME);
                }
            } else if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE_TIME) && !isLocalDateTime.test(s, locale)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_DATE_TIME);
            }
            if (timeFormatter != null) {
                if (typeCandidates.contains((Object)ColumnType.LOCAL_TIME) && !CsvReader.isLocalTime(s, options.timeFormatter())) {
                    typeCandidates.remove((Object)ColumnType.LOCAL_TIME);
                }
            } else if (typeCandidates.contains((Object)ColumnType.LOCAL_TIME) && !isLocalTime.test(s, locale)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_TIME);
            }
            if (dateFormatter != null) {
                if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE) && !CsvReader.isLocalDate(s, options.dateFormatter())) {
                    typeCandidates.remove((Object)ColumnType.LOCAL_DATE);
                }
            } else if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE) && !isLocalDate.test(s, locale)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_DATE);
            }
            if (typeCandidates.contains((Object)ColumnType.BOOLEAN) && !isBoolean.test(s)) {
                typeCandidates.remove((Object)ColumnType.BOOLEAN);
            }
            if (!typeCandidates.contains((Object)ColumnType.NUMBER) || isDouble.test(s)) continue;
            typeCandidates.remove((Object)ColumnType.NUMBER);
        }
        return CsvReader.selectType(typeCandidates);
    }

    private static boolean isMissing(String s, CsvReadOptions options) {
        String missingValueIndicator = options.missingValueIndicator();
        if (options.missingValueIndicator() != null) {
            return missingValueIndicator.equals(s) || Strings.isNullOrEmpty((String)s);
        }
        return Strings.isNullOrEmpty((String)s) || TypeUtils.MISSING_INDICATORS.contains((Object)s);
    }

    private static ColumnType selectType(List<ColumnType> typeCandidates) {
        if (typeCandidates.isEmpty()) {
            return ColumnType.STRING;
        }
        return typeCandidates.get(0);
    }
}

