/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleRBTreeSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.numbers.Stats;
import tech.tablesaw.filtering.predicates.DoubleBiPredicate;
import tech.tablesaw.filtering.predicates.DoubleRangePredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class DoubleColumn
extends AbstractColumn
implements NumberColumn {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final DoubleComparator descendingComparator = (o2, o1) -> Double.compare(o1, o2);
    private DoubleArrayList data;
    private NumberColumnFormatter printFormatter = new NumberColumnFormatter();
    private Locale locale;
    private final IntComparator comparator = new IntComparator(){

        public int compare(int r1, int r2) {
            double f1 = DoubleColumn.this.data.getDouble(r1);
            double f2 = DoubleColumn.this.data.getDouble(r2);
            return Double.compare(f1, f2);
        }
    };

    public static DoubleColumn create(String name, int initialSize) {
        return new DoubleColumn(name, new DoubleArrayList(initialSize));
    }

    public static DoubleColumn create(String name, double[] arr) {
        return new DoubleColumn(name, new DoubleArrayList(arr));
    }

    public static DoubleColumn create(String name, float[] arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, int[] arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, long[] arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, List<Number> numberList) {
        double[] doubles = new double[numberList.size()];
        for (int i = 0; i < numberList.size(); ++i) {
            doubles[i] = numberList.get(i).doubleValue();
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, Number[] numbers) {
        double[] doubles = new double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            doubles[i] = numbers[i].doubleValue();
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static double convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Double.parseDouble(matcher.replaceAll(""));
    }

    @Override
    public DoubleColumn removeMissing() {
        DoubleColumn noMissing = (DoubleColumn)this.emptyCopy();
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            double v = iterator.nextDouble();
            if (NumberColumn.valueIsMissing(v)) continue;
            noMissing.append(v);
        }
        return noMissing;
    }

    public static DoubleColumn indexColumn(String columnName, int size, int startsWith) {
        DoubleColumn indexColumn = DoubleColumn.create(columnName, size);
        for (int i = 0; i < size; ++i) {
            indexColumn.append(i + startsWith);
        }
        indexColumn.setPrintFormatter(NumberColumnFormatter.ints());
        return indexColumn;
    }

    public static DoubleColumn create(String columnName) {
        return DoubleColumn.create(columnName, 128);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return NumberColumn.valueIsMissing(this.get(rowNumber));
    }

    @Override
    public void setPrintFormatter(NumberFormat format, String missingValueString) {
        this.printFormatter = new NumberColumnFormatter(format, missingValueString);
    }

    @Override
    public DoubleColumn appendMissing() {
        this.append(MISSING_VALUE);
        return this;
    }

    @Override
    public void setPrintFormatter(NumberColumnFormatter formatter) {
        this.printFormatter = formatter;
    }

    private DoubleColumn(String name, DoubleArrayList data) {
        super(ColumnType.NUMBER, name);
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Table summary() {
        return this.stats().asTable();
    }

    @Override
    public Stats stats() {
        return Stats.create(this);
    }

    @Override
    public DoubleArrayList top(int n) {
        DoubleArrayList top = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values, (DoubleComparator)this.descendingComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    @Override
    public DoubleArrayList bottom(int n) {
        DoubleArrayList bottom = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    @Override
    public Column unique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            doubles.add(this.data.getDouble(i));
        }
        DoubleColumn column = DoubleColumn.create(this.name() + " Unique values", doubles.size());
        doubles.forEach(column::append);
        return column;
    }

    @Override
    public double firstElement() {
        if (this.size() > 0) {
            return this.data.getDouble(0);
        }
        return MISSING_VALUE;
    }

    @Override
    public DoubleColumn append(float f) {
        this.data.add((double)f);
        return this;
    }

    @Override
    public DoubleColumn append(double d) {
        this.data.add(d);
        return this;
    }

    @Override
    public String getString(int row) {
        double value = this.data.getDouble(row);
        if (NumberColumn.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(this.printFormatter.format(value));
    }

    @Override
    public double getDouble(int row) {
        return this.get(row);
    }

    @Override
    public String getUnformattedString(int row) {
        return String.valueOf(this.get(row));
    }

    @Override
    public NumberColumn emptyCopy() {
        return this.emptyCopy(128);
    }

    @Override
    public DoubleColumn emptyCopy(int rowSize) {
        DoubleColumn column = DoubleColumn.create(this.name(), rowSize);
        column.setPrintFormatter(this.printFormatter);
        column.locale = this.locale;
        return column;
    }

    @Override
    public NumberColumn lead(int n) {
        NumberColumn numberColumn = this.lag(-n);
        numberColumn.setName(this.name() + " lead(" + n + ")");
        return numberColumn;
    }

    @Override
    public NumberColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        double[] dest = new double[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = MISSING_VALUE;
        }
        System.arraycopy(this.data.toDoubleArray(), srcPos, dest, destPos, length);
        DoubleColumn copy = this.emptyCopy(this.size());
        copy.data = new DoubleArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    @Override
    public NumberColumn copy() {
        DoubleColumn column = this.emptyCopy(this.size());
        column.data = this.data.clone();
        return column;
    }

    @Override
    public void clear() {
        this.data = new DoubleArrayList(128);
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        DoubleArrays.parallelQuickSort((double[])this.data.elements(), (DoubleComparator)this.descendingComparator);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public DoubleColumn appendCell(String object) {
        try {
            this.append(DoubleColumn.convert(object));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(this.name() + ": " + e.getMessage());
        }
        return this;
    }

    @Override
    public Integer roundInt(int i) {
        double value = this.get(i);
        if (NumberColumn.valueIsMissing(value)) {
            return null;
        }
        return (int)Math.round(this.get(i));
    }

    @Override
    public long getLong(int i) {
        double value = this.data.getDouble(i);
        return NumberColumn.valueIsMissing(value) ? DateTimeColumn.MISSING_VALUE : Math.round(value);
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public double get(int index) {
        return this.data.getDouble(index);
    }

    @Override
    public DoubleColumn set(int r, double value) {
        this.data.set(r, value);
        return this;
    }

    @Override
    public DoubleColumn set(Selection rowSelection, double newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public double[] asDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getDouble(i);
        }
        return output;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        NumberColumn numberColumn = (NumberColumn)column;
        for (int i = 0; i < numberColumn.size(); ++i) {
            this.append(numberColumn.get(i));
        }
    }

    @Override
    public DoubleIterator iterator() {
        return this.data.iterator();
    }

    @Override
    public NumberColumn where(Selection selection) {
        return (NumberColumn)this.subset(selection);
    }

    @Override
    public Selection eval(DoublePredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            double next = this.data.getDouble(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public Selection eval(DoubleBiPredicate predicate, NumberColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), otherColumn.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    @Override
    public Selection eval(DoubleBiPredicate predicate, Number number) {
        double value = number.doubleValue();
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            double next = this.data.getDouble(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public Selection eval(BiPredicate<Number, Number> predicate, Number number) {
        double value = number.doubleValue();
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            double next = this.data.getDouble(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public Selection eval(DoubleRangePredicate predicate, Number rangeStart, Number rangeEnd) {
        double start = rangeStart.doubleValue();
        double end = rangeEnd.doubleValue();
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            double next = this.data.getDouble(idx);
            if (!predicate.test(next, start, end)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public Selection isIn(Number ... numbers) {
        return this.isIn(Arrays.stream(numbers).mapToDouble(Number::doubleValue).toArray());
    }

    @Override
    public Selection isIn(double ... doubles) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        DoubleRBTreeSet doubleSet = new DoubleRBTreeSet(doubles);
        for (int i = 0; i < this.size(); ++i) {
            if (!doubleSet.contains(this.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isNotIn(Number ... numbers) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(numbers));
        return results;
    }

    @Override
    public Selection isNotIn(double ... doubles) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(doubles));
        return results;
    }

    @Override
    public DoubleSet asSet() {
        return new DoubleOpenHashSet((DoubleCollection)this.data);
    }

    @Override
    public boolean contains(double value) {
        return this.data.contains(value);
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putDouble(this.get(rowNumber)).array();
    }

    @Override
    public int[] asIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.roundInt(i);
        }
        return result;
    }

    public IntSet asIntegerSet() {
        IntOpenHashSet ints = new IntOpenHashSet();
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double d = (Double)doubleIterator.next();
            if (NumberColumn.valueIsMissing(d)) continue;
            ints.add((int)Math.round(d));
        }
        return ints;
    }

    @Override
    public DoubleList dataInternal() {
        return this.data.clone();
    }

    @Override
    public DateTimeColumn asDateTimes(ZoneOffset offset) {
        DateTimeColumn column = DateTimeColumn.create(this.name() + ": date time");
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            double d = (Double)doubleIterator.next();
            LocalDateTime dateTime = Instant.ofEpochMilli((long)d).atZone(offset).toLocalDateTime();
            column.append(dateTime);
        }
        return column;
    }

    @Override
    public DoubleColumn fillWith(DoubleIterator iterator) {
        for (int r = 0; r < this.size() && iterator.hasNext(); ++r) {
            this.set(r, iterator.nextDouble());
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(DoubleIterable iterable) {
        DoubleIterator iterator = null;
        for (int r = 0; r < this.size() && (iterator != null && iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            this.set(r, iterator.nextDouble());
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(DoubleSupplier supplier) {
        for (int r = 0; r < this.size(); ++r) {
            try {
                this.set(r, supplier.getAsDouble());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public Object[] asObjectArray() {
        Object[] output = new Double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getDouble(i);
        }
        return output;
    }
}

