/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.BooleanAggregateFunction;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.Column;

public class AggregateFunctions {
    public static BooleanAggregateFunction countTrue = new BooleanAggregateFunction("Number True"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).countTrue();
        }
    };
    public static BooleanAggregateFunction countFalse = new BooleanAggregateFunction("Number False"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).countFalse();
        }
    };
    public static BooleanAggregateFunction proportionTrue = new BooleanAggregateFunction("Proportion True"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).proportionTrue();
        }
    };
    public static BooleanAggregateFunction proportionFalse = new BooleanAggregateFunction("Proportion False"){

        @Override
        public double summarize(Column column) {
            return ((BooleanColumn)column).proportionFalse();
        }
    };
    public static NumericAggregateFunction first = new NumericAggregateFunction("First"){

        @Override
        public double summarize(Column column) {
            return column.isEmpty() ? Double.NaN : column.getDouble(0);
        }
    };
    public static NumericAggregateFunction last = new NumericAggregateFunction("Last"){

        @Override
        public double summarize(Column column) {
            return column.isEmpty() ? Double.NaN : column.getDouble(column.size() - 1);
        }
    };
    public static AggregateFunction countNonMissing;
    public static AggregateFunction count;
    public static AggregateFunction countMissing;
    public static AggregateFunction countUnique;
    public static final NumericAggregateFunction mean;
    public static final NumericAggregateFunction sum;
    public static final NumericAggregateFunction median;
    public static final AggregateFunction countWithMissing;
    public static final NumericAggregateFunction quartile1;
    public static final NumericAggregateFunction quartile3;
    public static final NumericAggregateFunction percentile90;
    public static final NumericAggregateFunction percentile95;
    public static final NumericAggregateFunction percentile99;
    public static final NumericAggregateFunction range;
    public static final NumericAggregateFunction min;
    public static final NumericAggregateFunction max;
    public static final NumericAggregateFunction product;
    public static final NumericAggregateFunction geometricMean;
    public static final NumericAggregateFunction populationVariance;
    public static final NumericAggregateFunction quadraticMean;
    public static final NumericAggregateFunction kurtosis;
    public static final NumericAggregateFunction skewness;
    public static final NumericAggregateFunction sumOfSquares;
    public static final NumericAggregateFunction sumOfLogs;
    public static final NumericAggregateFunction variance;
    public static final NumericAggregateFunction stdDev;
    public static final NumericAggregateFunction standardDeviation;

    public static double percentile(NumberColumn data, double percentile) {
        return StatUtils.percentile((double[])AggregateFunctions.removeMissing(data), (double)percentile);
    }

    private static double[] removeMissing(NumberColumn column) {
        return column.removeMissing().asDoubleArray();
    }

    private static Column removeMissing(Column column) {
        return column.removeMissing();
    }

    public static double meanDifference(NumberColumn column1, NumberColumn column2) {
        return StatUtils.meanDifference((double[])column1.asDoubleArray(), (double[])column2.asDoubleArray());
    }

    public static double sumDifference(NumberColumn column1, NumberColumn column2) {
        return StatUtils.sumDifference((double[])column1.asDoubleArray(), (double[])column2.asDoubleArray());
    }

    static {
        count = countNonMissing = new AggregateFunction("Count"){

            @Override
            public double summarize(Column column) {
                return column.size() - column.countMissing();
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return true;
            }
        };
        countMissing = new AggregateFunction("Missing Values"){

            @Override
            public double summarize(Column column) {
                return column.countMissing();
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return true;
            }
        };
        countUnique = new AggregateFunction("Count Unique"){

            @Override
            public double summarize(Column doubles) {
                return AggregateFunctions.removeMissing(doubles).unique().size();
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return true;
            }
        };
        mean = new NumericAggregateFunction("Mean"){

            @Override
            public double summarize(Column column) {
                return StatUtils.mean((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        sum = new NumericAggregateFunction("Sum"){

            @Override
            public double summarize(Column column) {
                return StatUtils.sum((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        median = new NumericAggregateFunction("Median"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumberColumn)column, 50.0);
            }
        };
        countWithMissing = new AggregateFunction("Count (incl. missing)"){

            @Override
            public double summarize(Column column) {
                return column.size();
            }

            @Override
            public boolean isCompatibleWith(ColumnType type) {
                return false;
            }
        };
        quartile1 = new NumericAggregateFunction("First Quartile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumberColumn)column, 25.0);
            }
        };
        quartile3 = new NumericAggregateFunction("Third Quartile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumberColumn)column, 75.0);
            }
        };
        percentile90 = new NumericAggregateFunction("90th Percentile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumberColumn)column, 90.0);
            }
        };
        percentile95 = new NumericAggregateFunction("95th Percentile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumberColumn)column, 95.0);
            }
        };
        percentile99 = new NumericAggregateFunction("99th Percentile"){

            @Override
            public double summarize(Column column) {
                return AggregateFunctions.percentile((NumberColumn)column, 99.0);
            }
        };
        range = new NumericAggregateFunction("Range"){

            @Override
            public double summarize(Column column) {
                double[] data = AggregateFunctions.removeMissing((NumberColumn)column);
                return StatUtils.max((double[])data) - StatUtils.min((double[])data);
            }
        };
        min = new NumericAggregateFunction("Min"){

            @Override
            public double summarize(Column column) {
                return StatUtils.min((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        max = new NumericAggregateFunction("Max"){

            @Override
            public double summarize(Column column) {
                return StatUtils.max((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        product = new NumericAggregateFunction("Product"){

            @Override
            public double summarize(Column column) {
                return StatUtils.product((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        geometricMean = new NumericAggregateFunction("Geometric Mean"){

            @Override
            public double summarize(Column column) {
                return StatUtils.geometricMean((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        populationVariance = new NumericAggregateFunction("Population Variance"){

            @Override
            public double summarize(Column column) {
                return StatUtils.populationVariance((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        quadraticMean = new NumericAggregateFunction("Quadratic Mean"){

            @Override
            public double summarize(Column column) {
                return new DescriptiveStatistics(AggregateFunctions.removeMissing((NumberColumn)column)).getQuadraticMean();
            }
        };
        kurtosis = new NumericAggregateFunction("Kurtosis"){

            @Override
            public double summarize(Column column) {
                double[] data = AggregateFunctions.removeMissing((NumberColumn)column);
                return new Kurtosis().evaluate(data, 0, data.length);
            }
        };
        skewness = new NumericAggregateFunction("Skewness"){

            @Override
            public double summarize(Column column) {
                double[] data = AggregateFunctions.removeMissing((NumberColumn)column);
                return new Skewness().evaluate(data, 0, data.length);
            }
        };
        sumOfSquares = new NumericAggregateFunction("Sum of Squares"){

            @Override
            public String functionName() {
                return "Sum of Squares";
            }

            @Override
            public double summarize(Column column) {
                return StatUtils.sumSq((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        sumOfLogs = new NumericAggregateFunction("Sum of Logs"){

            @Override
            public double summarize(Column column) {
                return StatUtils.sumLog((double[])AggregateFunctions.removeMissing((NumberColumn)column));
            }
        };
        variance = new NumericAggregateFunction("Variance"){

            @Override
            public double summarize(Column column) {
                double[] values = AggregateFunctions.removeMissing((NumberColumn)column);
                return StatUtils.variance((double[])values);
            }
        };
        standardDeviation = stdDev = new NumericAggregateFunction("Std. Deviation"){

            @Override
            public double summarize(Column column) {
                return Math.sqrt(StatUtils.variance((double[])AggregateFunctions.removeMissing((NumberColumn)column)));
            }
        };
    }
}

