/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.LongBiPredicate;
import tech.tablesaw.filtering.LongPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.LongMapUtils;
import tech.tablesaw.sorting.LongComparisonUtil;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseLongComparator;
import tech.tablesaw.util.Selection;
import tech.tablesaw.util.Stats;

public class LongColumn
extends AbstractColumn
implements LongMapUtils,
NumericColumn {
    public static final long MISSING_VALUE = (Long)ColumnType.LONG_INT.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 8;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private LongArrayList data;
    private final IntComparator comparator = new IntComparator(){

        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        public int compare(int i1, int i2) {
            long prim1 = LongColumn.this.get(i1);
            long prim2 = LongColumn.this.get(i2);
            return LongComparisonUtil.getInstance().compare(prim1, prim2);
        }
    };

    public LongColumn(String name) {
        this(name, new LongArrayList(128));
    }

    public LongColumn(String name, int initialSize) {
        this(name, new LongArrayList(initialSize));
    }

    public LongColumn(String name, long[] arr) {
        this(name, new LongArrayList(arr));
    }

    private LongColumn(String name, LongArrayList data) {
        super(name);
        this.data = data;
    }

    public LongColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new LongArrayList(metadata.getSize());
    }

    protected static boolean isMissing(long value) {
        return value == MISSING_VALUE;
    }

    public static long convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return (Long)ColumnType.LONG_INT.getMissingValue();
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Long.parseLong(matcher.replaceAll(""));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public LongArrayList data() {
        return this.data;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LONG_INT;
    }

    public void append(long i) {
        this.data.add(i);
    }

    public void set(int index, long value) {
        this.data.set(index, value);
    }

    public void set(long newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    public Selection isLessThan(long i) {
        return this.select(isLessThan, i);
    }

    public Selection isGreaterThan(long i) {
        return this.select(isGreaterThan, i);
    }

    public Selection isGreaterThanOrEqualTo(long i) {
        return this.select(isGreaterThanOrEqualTo, i);
    }

    public Selection isLessThanOrEqualTo(long f) {
        return this.select(isLessThanOrEqualTo, f);
    }

    public Selection isEqualTo(long i) {
        return this.select(isEqualTo, i);
    }

    public Selection isNotEqualTo(long i) {
        return this.select(isNotEqualTo, i);
    }

    public Selection isEqualTo(LongColumn f) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator longIterator = f.iterator();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next == longIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isGreaterThan(LongColumn f) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator longIterator = f.iterator();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next > longIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isLessThan(LongColumn f) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator longIterator = f.iterator();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next < longIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Table summary() {
        return this.stats().asTable();
    }

    public Stats stats() {
        FloatColumn values = new FloatColumn(this.name(), this.toFloatArray());
        return Stats.create(values);
    }

    @Override
    public int countUnique() {
        LongArraySet longSet = new LongArraySet();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            longSet.add(i);
        }
        return longSet.size();
    }

    @Override
    public LongColumn unique() {
        LongArraySet longSet = new LongArraySet();
        longSet.addAll((LongCollection)this.data);
        return new LongColumn(this.name() + " Unique values", new LongArrayList((LongCollection)longSet));
    }

    public LongColumn remainder(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) % column2.get(r));
        }
        return result;
    }

    public LongColumn append(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " + " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + column2.get(r));
        }
        return result;
    }

    public LongColumn subtract(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.subtract(this.get(r), column2.get(r)));
        }
        return result;
    }

    public LongColumn add(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " + " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.add(this.get(r), column2.get(r)));
        }
        return result;
    }

    public LongColumn subtract(long value) {
        LongColumn result = new LongColumn(this.name() + " - " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.subtract(this.get(r), value));
        }
        return result;
    }

    public LongColumn add(long value) {
        LongColumn result = new LongColumn(this.name() + " + " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.add(this.get(r), value));
        }
        return result;
    }

    public LongColumn multiply(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * column2.get(r));
        }
        return result;
    }

    public LongColumn multiply(long value) {
        LongColumn result = new LongColumn(this.name() + " * " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * value);
        }
        return result;
    }

    public FloatColumn multiply(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append((float)this.get(r) * column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append((float)this.get(r) / column2.get(r));
        }
        return result;
    }

    public LongColumn divide(long value) {
        LongColumn result = new LongColumn(this.name() + " / " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / value);
        }
        return result;
    }

    public LongColumn divide(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / column2.get(r));
        }
        return result;
    }

    @Override
    public String getString(int row) {
        long value = this.data.getLong(row);
        if (value == MISSING_VALUE) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public LongColumn emptyCopy() {
        LongColumn column = new LongColumn(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public LongColumn emptyCopy(int rowSize) {
        LongColumn column = new LongColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        LongArrays.parallelQuickSort((long[])this.data.elements(), (LongComparator)ReverseLongComparator.instance());
    }

    @Override
    public LongColumn copy() {
        LongColumn copy = this.emptyCopy(this.size());
        copy.data.addAll((LongList)this.data);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void appendCell(String object) {
        try {
            this.append(LongColumn.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    @Override
    public long get(int index) {
        return this.data.getLong(index);
    }

    @Override
    public long getLong(int index) {
        return this.data.getLong(index);
    }

    @Override
    public double getDouble(int index) {
        double value = this.data.getLong(index);
        return value == (double)MISSING_VALUE ? DoubleColumn.MISSING_VALUE : (double)((float)value);
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public long sum() {
        return Math.round(AggregateFunctions.sum.agg(this.toDoubleArray()));
    }

    @Override
    public double product() {
        return AggregateFunctions.product.agg(this);
    }

    @Override
    public double mean() {
        return AggregateFunctions.mean.agg(this);
    }

    @Override
    public double median() {
        return AggregateFunctions.median.agg(this);
    }

    @Override
    public double quartile1() {
        return AggregateFunctions.quartile1.agg(this);
    }

    @Override
    public double quartile3() {
        return AggregateFunctions.quartile3.agg(this);
    }

    @Override
    public double percentile(double percentile) {
        return AggregateFunctions.percentile(this.toDoubleArray(), percentile);
    }

    @Override
    public double range() {
        return AggregateFunctions.range.agg(this);
    }

    @Override
    public double max() {
        return Math.round(AggregateFunctions.max.agg(this));
    }

    @Override
    public double min() {
        return Math.round(AggregateFunctions.min.agg(this));
    }

    @Override
    public double variance() {
        return AggregateFunctions.variance.agg(this);
    }

    @Override
    public double populationVariance() {
        return AggregateFunctions.populationVariance.agg(this);
    }

    @Override
    public double standardDeviation() {
        return AggregateFunctions.stdDev.agg(this);
    }

    @Override
    public double sumOfLogs() {
        return AggregateFunctions.sumOfLogs.agg(this);
    }

    @Override
    public double sumOfSquares() {
        return AggregateFunctions.sumOfSquares.agg(this);
    }

    @Override
    public double geometricMean() {
        return AggregateFunctions.geometricMean.agg(this);
    }

    @Override
    public double quadraticMean() {
        return AggregateFunctions.quadraticMean.agg(this);
    }

    @Override
    public double kurtosis() {
        return AggregateFunctions.kurtosis.agg(this);
    }

    @Override
    public double skewness() {
        return AggregateFunctions.skewness.agg(this);
    }

    public long firstElement() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return MISSING_VALUE;
    }

    public Selection isPositive() {
        return this.select(isPositive);
    }

    public Selection isNegative() {
        return this.select(isNegative);
    }

    public Selection isNonNegative() {
        return this.select(isNonNegative);
    }

    public Selection isZero() {
        return this.select(isZero);
    }

    public Selection isEven() {
        return this.select(isEven);
    }

    public Selection isOdd() {
        return this.select(isOdd);
    }

    public FloatArrayList toFloatArray() {
        FloatArrayList output = new FloatArrayList(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            output.add((float)aData);
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "LongInt column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        LongColumn longColumn = (LongColumn)column;
        for (int i = 0; i < longColumn.size(); ++i) {
            this.append(longColumn.get(i));
        }
    }

    public LongColumn select(Selection selection) {
        LongColumn column = this.emptyCopy();
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            int next = (Integer)intIterator.next();
            column.append(this.data.getLong(next));
        }
        return column;
    }

    public LongColumn selectIf(LongPredicate predicate) {
        LongColumn column = this.emptyCopy();
        LongIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            long next = intIterator.nextLong();
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    public LongArrayList top(int n) {
        LongArrayList top = new LongArrayList();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values, (LongComparator)ReverseLongComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    public LongArrayList bottom(int n) {
        LongArrayList bottom = new LongArrayList();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    public LongIterator iterator() {
        return this.data.iterator();
    }

    public Selection select(LongPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            long next = this.data.getLong(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(LongBiPredicate predicate, long valueToCompareAgainst) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            long next = this.data.getLong(idx);
            if (!predicate.test(next, valueToCompareAgainst)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public double[] toDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            long val = this.data.getLong(i);
            output[i] = val == MISSING_VALUE ? Double.NaN : (double)val;
        }
        return output;
    }

    public LongSet asSet() {
        return new LongOpenHashSet((LongCollection)this.data);
    }

    public boolean contains(long value) {
        return this.data.contains(value);
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.get(rowNumber)).array();
    }

    @Override
    public LongColumn difference() {
        LongColumn returnValue = new LongColumn(this.name(), this.data.size());
        if (this.data.isEmpty()) {
            return returnValue;
        }
        returnValue.append(MISSING_VALUE);
        for (int current = 1; current < this.data.size(); ++current) {
            returnValue.append(this.subtract(this.get(current), this.get(current - 1)));
        }
        return returnValue;
    }

    private long add(long val1, long val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 + val2;
    }

    private long subtract(long val1, long val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 - val2;
    }

    public LongColumn cumSum() {
        long total = 0L;
        LongColumn newColumn = new LongColumn(this.name() + "[cumSum]", this.size());
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            long value = (Long)longIterator.next();
            if (LongColumn.isMissing(value)) {
                newColumn.append(MISSING_VALUE);
                continue;
            }
            newColumn.append(total += value);
        }
        return newColumn;
    }

    public LongColumn cumProd() {
        long total = 1L;
        LongColumn newColumn = new LongColumn(this.name() + "[cumProd]", this.size());
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            long value = (Long)longIterator.next();
            if (LongColumn.isMissing(value)) {
                newColumn.append(MISSING_VALUE);
                continue;
            }
            newColumn.append(total *= value);
        }
        return newColumn;
    }

    public DoubleColumn pctChange() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[pctChange]", this.size());
        newColumn.append(DoubleColumn.MISSING_VALUE);
        for (int i = 1; i < this.size(); ++i) {
            newColumn.append((double)this.get(i) / (double)this.get(i - 1) - 1.0);
        }
        return newColumn;
    }
}

