/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.aggregate.NumericSummaryTable;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.util.BitmapBackedSelection;

public class ViewGroup
implements Iterable<TemporaryView> {
    private static final String SPLIT_STRING = "~~~";
    private static final Splitter SPLITTER = Splitter.on((String)"~~~");
    private final Table sortedOriginal;
    private final List<TemporaryView> subTables = new ArrayList<TemporaryView>();
    private final String[] splitColumnNames;

    public ViewGroup(Table original, Column ... columns) {
        this.splitColumnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.splitColumnNames[i] = columns[i].name();
        }
        this.sortedOriginal = original.sortOn(this.splitColumnNames);
        this.splitOn(this.splitColumnNames);
    }

    public static ViewGroup create(Table original, String ... columnsNames) {
        List<Column> columns = original.columns(columnsNames);
        return new ViewGroup(original, columns.toArray(new Column[columns.size()]));
    }

    private void splitOn(String ... columnNames) {
        TemporaryView view;
        List<Column> columns = this.sortedOriginal.columns(columnNames);
        int byteSize = this.getByteSize(columns);
        byte[] currentKey = null;
        String currentStringKey = null;
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int row = 0; row < this.sortedOriginal.rowCount(); ++row) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byteSize);
            String newStringKey = "";
            for (int col = 0; col < columnNames.length; ++col) {
                if (col > 0) {
                    newStringKey = newStringKey + SPLIT_STRING;
                }
                Column c = this.sortedOriginal.column(columnNames[col]);
                String groupKey = this.sortedOriginal.get(row, this.sortedOriginal.columnIndex(c));
                newStringKey = newStringKey + groupKey;
                byteBuffer.put(c.asBytes(row));
            }
            byte[] newKey = byteBuffer.array();
            if (row == 0) {
                currentKey = newKey;
                currentStringKey = newStringKey;
            }
            if (!Arrays.equals(newKey, currentKey)) {
                currentKey = newKey;
                view = new TemporaryView(this.sortedOriginal, selection);
                view.setName(currentStringKey);
                currentStringKey = newStringKey;
                this.addViewToSubTables(view);
                selection = new BitmapBackedSelection();
                selection.add(row);
                continue;
            }
            selection.add(row);
        }
        if (!selection.isEmpty()) {
            view = new TemporaryView(this.sortedOriginal, selection);
            view.setName(currentStringKey);
            this.addViewToSubTables(view);
        }
    }

    private int getByteSize(List<Column> columns) {
        int byteSize = 0;
        for (Column c : columns) {
            byteSize += c.byteSize();
        }
        return byteSize;
    }

    private void addViewToSubTables(TemporaryView view) {
        this.subTables.add(view);
    }

    public List<TemporaryView> getSubTables() {
        return this.subTables;
    }

    public TemporaryView get(int i) {
        return this.subTables.get(i);
    }

    @VisibleForTesting
    public Table getSortedOriginal() {
        return this.sortedOriginal;
    }

    public int size() {
        return this.subTables.size();
    }

    private NumericSummaryTable splitGroupingColumn(NumericSummaryTable groupTable) {
        ArrayList<Column> newColumns = new ArrayList<Column>();
        List<Column> columns = this.sortedOriginal.columns(this.splitColumnNames);
        for (Column column : columns) {
            Column newColumn = column.emptyCopy();
            newColumns.add(newColumn);
        }
        for (int row = 0; row < groupTable.rowCount(); ++row) {
            List strings = SPLITTER.splitToList((CharSequence)groupTable.categoryColumn("Group").get(row));
            for (int col = 0; col < newColumns.size(); ++col) {
                ((Column)newColumns.get(col)).appendCell((String)strings.get(col));
            }
        }
        for (int col = 0; col < newColumns.size(); ++col) {
            Column c = (Column)newColumns.get(col);
            groupTable.addColumn(col, c);
        }
        groupTable.removeColumns("Group");
        return groupTable;
    }

    public NumericSummaryTable first(String columnName) {
        return this.agg(columnName, AggregateFunctions.first);
    }

    public NumericSummaryTable last(String columnName) {
        return this.agg(columnName, AggregateFunctions.last);
    }

    public NumericSummaryTable count(String columnName) {
        return this.agg(columnName, AggregateFunctions.count);
    }

    public NumericSummaryTable mean(String columnName) {
        return this.agg(columnName, AggregateFunctions.mean);
    }

    public NumericSummaryTable sum(String columnName) {
        return this.agg(columnName, AggregateFunctions.sum);
    }

    public NumericSummaryTable median(String columnName) {
        return this.agg(columnName, AggregateFunctions.median);
    }

    public NumericSummaryTable quartile1(String columnName) {
        return this.agg(columnName, AggregateFunctions.quartile1);
    }

    public NumericSummaryTable quartile3(String columnName) {
        return this.agg(columnName, AggregateFunctions.quartile3);
    }

    public NumericSummaryTable percentile90(String columnName) {
        return this.agg(columnName, AggregateFunctions.percentile90);
    }

    public NumericSummaryTable percentile95(String columnName) {
        return this.agg(columnName, AggregateFunctions.percentile95);
    }

    public NumericSummaryTable percentile99(String columnName) {
        return this.agg(columnName, AggregateFunctions.percentile99);
    }

    public NumericSummaryTable range(String columnName) {
        return this.agg(columnName, AggregateFunctions.range);
    }

    public NumericSummaryTable min(String columnName) {
        return this.agg(columnName, AggregateFunctions.min);
    }

    public NumericSummaryTable max(String columnName) {
        return this.agg(columnName, AggregateFunctions.max);
    }

    public NumericSummaryTable product(String columnName) {
        return this.agg(columnName, AggregateFunctions.product);
    }

    public NumericSummaryTable geometricMean(String columnName) {
        return this.agg(columnName, AggregateFunctions.geometricMean);
    }

    public NumericSummaryTable populationVariance(String columnName) {
        return this.agg(columnName, AggregateFunctions.populationVariance);
    }

    public NumericSummaryTable quadraticMean(String columnName) {
        return this.agg(columnName, AggregateFunctions.quadraticMean);
    }

    public NumericSummaryTable kurtosis(String columnName) {
        return this.agg(columnName, AggregateFunctions.kurtosis);
    }

    public NumericSummaryTable skewness(String columnName) {
        return this.agg(columnName, AggregateFunctions.skewness);
    }

    public NumericSummaryTable sumOfSquares(String columnName) {
        return this.agg(columnName, AggregateFunctions.sumOfSquares);
    }

    public NumericSummaryTable sumOfLogs(String columnName) {
        return this.agg(columnName, AggregateFunctions.sumOfLogs);
    }

    public NumericSummaryTable variance(String columnName) {
        return this.agg(columnName, AggregateFunctions.variance);
    }

    public NumericSummaryTable stdDev(String columnName) {
        return this.agg(columnName, AggregateFunctions.stdDev);
    }

    public NumericSummaryTable agg(String colName1, AggregateFunction func1) {
        return this.agg((Map<String, AggregateFunction>)ImmutableMap.of((Object)colName1, (Object)func1));
    }

    public NumericSummaryTable agg(String colName1, AggregateFunction func1, String colName2, AggregateFunction func2) {
        return this.agg((Map<String, AggregateFunction>)ImmutableMap.of((Object)colName1, (Object)func1, (Object)colName2, (Object)func2));
    }

    public NumericSummaryTable agg(String colName1, AggregateFunction func1, String colName2, AggregateFunction func2, String colName3, AggregateFunction func3) {
        return this.agg((Map<String, AggregateFunction>)ImmutableMap.of((Object)colName1, (Object)func1, (Object)colName2, (Object)func2, (Object)colName3, (Object)func3));
    }

    public NumericSummaryTable agg(String colName1, AggregateFunction func1, String colName2, AggregateFunction func2, String colName3, AggregateFunction func3, String colName4, AggregateFunction func4) {
        return this.agg((Map<String, AggregateFunction>)ImmutableMap.of((Object)colName1, (Object)func1, (Object)colName2, (Object)func2, (Object)colName3, (Object)func3, (Object)colName4, (Object)func4));
    }

    public NumericSummaryTable agg(Map<String, AggregateFunction> functions) {
        Preconditions.checkArgument((!this.subTables.isEmpty() ? 1 : 0) != 0);
        NumericSummaryTable groupTable = NumericSummaryTable.create(this.sortedOriginal.name() + " summary");
        CategoryColumn groupColumn = new CategoryColumn("Group", this.subTables.size());
        groupTable.addColumn(groupColumn);
        for (Map.Entry<String, AggregateFunction> entry : functions.entrySet()) {
            String columnName = entry.getKey();
            AggregateFunction function = entry.getValue();
            String colName = this.aggregateColumnName(columnName, function.functionName());
            DoubleColumn resultColumn = new DoubleColumn(colName, this.subTables.size());
            for (TemporaryView subTable : this.subTables) {
                double result = subTable.reduce(columnName, function);
                groupColumn.append(subTable.name());
                resultColumn.append(result);
            }
            groupTable.addColumn(resultColumn);
        }
        return this.splitGroupingColumn(groupTable);
    }

    @Override
    public Iterator<TemporaryView> iterator() {
        return this.subTables.iterator();
    }

    private String aggregateColumnName(String columnName, String functionName) {
        return String.format("%s [%s]", functionName, columnName);
    }
}

