/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import tech.tablesaw.api.Table;
import tech.tablesaw.filtering.CompositeFilter;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.util.Selection;

public class AnyOf
extends CompositeFilter {
    private final List<Filter> filterList = new ArrayList<Filter>();

    AnyOf(Collection<Filter> filters) {
        this.filterList.addAll(filters);
    }

    public static AnyOf anyOf(Filter ... filters) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Collections.addAll(filterList, filters);
        return new AnyOf(filterList);
    }

    public static AnyOf anyOf(Collection<Filter> filters) {
        return new AnyOf(filters);
    }

    @Override
    public Selection apply(Table relation) {
        Selection selection = null;
        for (Filter filter : this.filterList) {
            if (selection == null) {
                selection = filter.apply(relation);
                continue;
            }
            selection.or(filter.apply(relation));
        }
        return selection;
    }
}

