/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.IntConvertibleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.CategoryColumnUtils;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.StringBiPredicate;
import tech.tablesaw.filtering.StringPredicate;
import tech.tablesaw.filtering.text.CategoryFilters;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.DictionaryMap;
import tech.tablesaw.util.Selection;

public class CategoryColumn
extends AbstractColumn
implements CategoryFilters,
CategoryColumnUtils,
IntConvertibleColumn,
Iterable<String> {
    public static final String MISSING_VALUE = (String)((Object)ColumnType.CATEGORY.getMissingValue());
    private static final int BYTE_SIZE = 4;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private int id = 0;
    private IntArrayList values;
    private DictionaryMap lookupTable = new DictionaryMap();
    public final IntComparator rowComparator = new IntComparator(){

        public int compare(int i, int i1) {
            String f1 = CategoryColumn.this.get(i);
            String f2 = CategoryColumn.this.get(i1);
            return f1.compareTo(f2);
        }

        public int compare(Integer i, Integer i1) {
            return this.compare((int)i, (int)i1);
        }
    };
    private IntComparator dictionarySortComparator = new IntComparator(){

        public int compare(int i, int i1) {
            return CategoryColumn.this.lookupTable.get(i).compareTo(CategoryColumn.this.lookupTable.get(i1));
        }

        public int compare(Integer o1, Integer o2) {
            return this.compare((int)o1, (int)o2);
        }
    };
    private final IntComparator reverseDictionarySortComparator = new IntComparator(){

        public int compare(int i, int i1) {
            return -CategoryColumn.this.lookupTable.get(i).compareTo(CategoryColumn.this.lookupTable.get(i1));
        }

        public int compare(Integer o1, Integer o2) {
            return this.compare((int)o1, (int)o2);
        }
    };

    public CategoryColumn(String name) {
        super(name);
        this.values = new IntArrayList(DEFAULT_ARRAY_SIZE);
    }

    public CategoryColumn(String name, String[] categories) {
        this(name, Arrays.asList(categories));
    }

    public CategoryColumn(String name, List<String> categories) {
        super(name);
        this.values = new IntArrayList(categories.size());
        for (String string : categories) {
            this.append(string);
        }
    }

    public CategoryColumn(ColumnMetadata metadata) {
        super(metadata);
        this.values = new IntArrayList(DEFAULT_ARRAY_SIZE);
    }

    public CategoryColumn(String name, int size) {
        super(name);
        this.values = new IntArrayList(size);
    }

    public static String convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        return stringValue;
    }

    @Override
    public ColumnType type() {
        return ColumnType.CATEGORY;
    }

    @Override
    public String getString(int row) {
        return this.get(row);
    }

    @Override
    public CategoryColumn emptyCopy() {
        CategoryColumn copy = new CategoryColumn(this.name());
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public CategoryColumn emptyCopy(int rowSize) {
        CategoryColumn copy = new CategoryColumn(this.name(), rowSize);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public void sortAscending() {
        IntArrays.parallelQuickSort((int[])this.values.elements(), (IntComparator)this.dictionarySortComparator);
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.values.elements(), (IntComparator)this.reverseDictionarySortComparator);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String get(int rowIndex) {
        int k = this.values.getInt(rowIndex);
        return this.lookupTable.get(k);
    }

    public List<String> toList() {
        ArrayList<String> strings = new ArrayList<String>();
        for (String category : this) {
            strings.add(category);
        }
        return strings;
    }

    @Override
    public int[] toIntArray() {
        return this.data().toIntArray();
    }

    @Override
    public Table summary() {
        return this.countByCategory();
    }

    public Table countByCategory() {
        Table t = new Table("Column: " + this.name(), new Column[0]);
        CategoryColumn categories = new CategoryColumn("Category");
        IntColumn counts = new IntColumn("Count");
        Int2IntOpenHashMap valueToCount = new Int2IntOpenHashMap();
        IntListIterator intListIterator = this.values.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (valueToCount.containsKey(next)) {
                valueToCount.put(next, valueToCount.get(next) + 1);
                continue;
            }
            valueToCount.put(next, 1);
        }
        for (Map.Entry entry : valueToCount.int2IntEntrySet()) {
            categories.add(this.lookupTable.get((Integer)entry.getKey()));
            counts.append((Integer)entry.getValue());
        }
        t.addColumn(categories);
        t.addColumn(counts);
        return t;
    }

    @Override
    public void clear() {
        this.values.clear();
        this.lookupTable.clear();
    }

    public Selection isEqualTo(CategoryColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        Iterator<String> iterator = other.iterator();
        for (String next : this) {
            if (next.equals(iterator.next())) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public void set(String newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    public void set(int rowIndex, String stringValue) {
        int valueId;
        boolean b;
        if (stringValue == null) {
            stringValue = MISSING_VALUE;
        }
        if (!(b = this.lookupTable.contains(stringValue))) {
            valueId = this.id++;
            this.lookupTable.put(valueId, stringValue);
        } else {
            valueId = this.lookupTable.get(stringValue);
        }
        this.values.set(rowIndex, valueId);
    }

    @Override
    public int countUnique() {
        return this.lookupTable.size();
    }

    public List<String> top(int n) {
        ArrayList<String> top = new ArrayList<String>();
        CategoryColumn copy = this.copy();
        copy.sortDescending();
        for (int i = 0; i < n; ++i) {
            top.add(copy.get(i));
        }
        return top;
    }

    public List<String> bottom(int n) {
        ArrayList<String> bottom = new ArrayList<String>();
        CategoryColumn copy = this.copy();
        copy.sortAscending();
        for (int i = 0; i < n; ++i) {
            bottom.add(copy.get(i));
        }
        return bottom;
    }

    public void add(String stringValue) {
        this.addValue(CategoryColumn.convert(stringValue));
    }

    private void addValue(String value) {
        int key = this.lookupTable.get(value);
        if (key < 0) {
            key = this.id++;
            this.lookupTable.put(key, value);
        }
        this.values.add(key);
    }

    public void initializeWith(IntArrayList list, DictionaryMap map) {
        IntListIterator intListIterator = list.iterator();
        while (intListIterator.hasNext()) {
            int key = (Integer)intListIterator.next();
            this.add(map.get(key));
        }
    }

    public boolean contains(String aString) {
        return this.values.indexOf(this.dictionaryMap().get(aString)) >= 0;
    }

    public IntArrayList getValues(IntArrayList indexes) {
        IntArrayList newList = new IntArrayList(indexes.size());
        IntListIterator intListIterator = indexes.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            newList.add(this.values.getInt(i));
        }
        return newList;
    }

    public void addAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.add(stringValue);
        }
    }

    @Override
    public void appendCell(String object) {
        this.addValue(CategoryColumn.convert(object));
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Selection isEqualTo(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int key = this.lookupTable.get(string);
        if (key >= 0) {
            int i = 0;
            IntListIterator intListIterator = this.values.iterator();
            while (intListIterator.hasNext()) {
                int next = (Integer)intListIterator.next();
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
        return results;
    }

    public Selection isNotEqualTo(String string) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(0, this.size());
        selection.andNot(this.isEqualTo(string));
        return selection;
    }

    public List<BooleanColumn> getDummies() {
        ArrayList<BooleanColumn> results = new ArrayList<BooleanColumn>();
        for (Int2ObjectMap.Entry entry : this.lookupTable.keyToValueMap().int2ObjectEntrySet()) {
            BooleanColumn column = new BooleanColumn((String)entry.getValue());
            results.add(column);
        }
        ObjectIterator objectIterator = this.values.iterator();
        while (objectIterator.hasNext()) {
            int next = (Integer)objectIterator.next();
            String category = this.lookupTable.get(next);
            for (BooleanColumn column : results) {
                if (category.equals(column.name())) {
                    column.append(true);
                    continue;
                }
                column.append(false);
            }
        }
        return results;
    }

    public int getInt(int rowNumber) {
        return this.values.getInt(rowNumber);
    }

    @Override
    public CategoryColumn unique() {
        ArrayList<String> strings = new ArrayList<String>(this.lookupTable.categories());
        return new CategoryColumn(this.name() + " Unique values", strings);
    }

    public IntArrayList data() {
        return this.values;
    }

    public IntColumn toIntColumn() {
        IntColumn intColumn = new IntColumn(this.name() + ": codes", this.size());
        IntArrayList data = this.data();
        for (int i = 0; i < this.size(); ++i) {
            intColumn.append(data.getInt(i));
        }
        return intColumn;
    }

    @Override
    public DictionaryMap dictionaryMap() {
        return this.lookupTable;
    }

    public String toString() {
        return "Category column: " + this.name();
    }

    public int[] indexes() {
        int[] rowIndexes = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            rowIndexes[i] = i;
        }
        return rowIndexes;
    }

    public CategoryColumn appendString(CategoryColumn append) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[column appended]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            newColumn.add(this.get(r) + append.get(r));
        }
        return newColumn;
    }

    public CategoryColumn appendString(String append) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[append]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            newColumn.add(this.get(r) + append);
        }
        return newColumn;
    }

    public CategoryColumn replaceAll(String[] regexArray, String replacement) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[repl]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.get(r);
            for (String regex : regexArray) {
                value = value.replaceAll(regex, replacement);
            }
            newColumn.add(value);
        }
        return newColumn;
    }

    public CategoryColumn tokenizeAndSort(String separator) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[sorted]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.get(r);
            Splitter splitter = Splitter.on((String)separator);
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            Collections.sort(tokens);
            value = String.join((CharSequence)" ", tokens);
            newColumn.add(value);
        }
        return newColumn;
    }

    public CategoryColumn tokenizeAndSort() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[sorted]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.get(r);
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.whitespace());
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            Collections.sort(tokens);
            value = String.join((CharSequence)" ", tokens);
            newColumn.add(value);
        }
        return newColumn;
    }

    public CategoryColumn tokenizeAndRemoveDuplicates() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[without duplicates]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            String value = this.get(r);
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.whitespace());
            splitter = splitter.trimResults();
            splitter = splitter.omitEmptyStrings();
            ArrayList tokens = new ArrayList(splitter.splitToList((CharSequence)value));
            value = String.join((CharSequence)" ", new HashSet(tokens));
            newColumn.add(value);
        }
        return newColumn;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntListIterator intListIterator = this.values.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            builder.append(this.get(next));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    public Selection select(StringPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data().size(); ++idx) {
            int next = this.data().getInt(idx);
            if (!predicate.test(this.get(next))) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection select(StringBiPredicate predicate, String value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data().size(); ++idx) {
            int next = this.data().getInt(idx);
            if (!predicate.test(this.get(next), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    @Override
    public CategoryColumn copy() {
        CategoryColumn newCol = new CategoryColumn(this.name(), this.size());
        newCol.lookupTable = new DictionaryMap(this.lookupTable);
        newCol.values.addAll((IntList)this.values);
        newCol.setComment(this.comment());
        return newCol;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        CategoryColumn intColumn = (CategoryColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.add(intColumn.get(i));
        }
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!MISSING_VALUE.equals(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final IntListIterator valuesIt;
            {
                this.valuesIt = CategoryColumn.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.valuesIt.hasNext();
            }

            @Override
            public String next() {
                return CategoryColumn.this.lookupTable.get(this.valuesIt.next());
            }
        };
    }

    public CategoryColumn selectIf(StringPredicate predicate) {
        CategoryColumn column = this.emptyCopy();
        for (String next : this) {
            if (!predicate.test(next)) continue;
            column.add(next);
        }
        return column;
    }

    public Set<String> asSet() {
        return this.lookupTable.categories();
    }

    @Override
    public IntArrayList values() {
        return this.values;
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.getInt(rowNumber)).array();
    }

    public Selection isIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (String string : strings) {
            int key = this.lookupTable.get(string);
            if (key < 0) continue;
            int i = 0;
            IntListIterator intListIterator = this.values.iterator();
            while (intListIterator.hasNext()) {
                int next = (Integer)intListIterator.next();
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
        return results;
    }

    public Selection isIn(Collection<String> strings) {
        return this.isIn(strings.toArray(new String[strings.size()]));
    }

    public void append(String value) {
        this.appendCell(value);
    }

    public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (String string : strings) {
            int key = this.lookupTable.get(string);
            if (key < 0) continue;
            int i = 0;
            IntListIterator intListIterator = this.values.iterator();
            while (intListIterator.hasNext()) {
                int next = (Integer)intListIterator.next();
                if (key != next) {
                    results.add(i);
                }
                ++i;
            }
        }
        return results;
    }

    public Selection isNotIn(Collection<String> strings) {
        return this.isNotIn(strings.toArray(new String[strings.size()]));
    }
}

