/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.store;

import com.google.gson.Gson;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public class ColumnMetadata {
    private static final Gson GSON = new Gson();
    private final String id;
    private final String name;
    private final ColumnType type;
    private final int size;

    public ColumnMetadata(Column column) {
        this.id = column.id();
        this.name = column.name();
        this.type = column.type();
        this.size = column.size();
    }

    public static ColumnMetadata fromJson(String jsonString) {
        return (ColumnMetadata)GSON.fromJson(jsonString, ColumnMetadata.class);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public String toString() {
        return "ColumnMetadata{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", size=" + this.size + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata that = (ColumnMetadata)o;
        if (this.size != that.size) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.size;
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public Column createColumn() {
        switch (this.getType()) {
            case FLOAT: {
                return new FloatColumn(this);
            }
            case DOUBLE: {
                return new DoubleColumn(this);
            }
            case INTEGER: {
                return new IntColumn(this);
            }
            case BOOLEAN: {
                return new BooleanColumn(this);
            }
            case LOCAL_DATE: {
                return new DateColumn(this);
            }
            case LOCAL_TIME: {
                return new TimeColumn(this);
            }
            case LOCAL_DATE_TIME: {
                return new DateTimeColumn(this);
            }
            case CATEGORY: {
                return new CategoryColumn(this);
            }
            case SHORT_INT: {
                return new ShortColumn(this);
            }
            case LONG_INT: {
                return new LongColumn(this);
            }
        }
        throw new IllegalStateException("Unhandled column type writing columns");
    }
}

