/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.IntColumnUtils;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;
import tech.tablesaw.filtering.IntBiPredicate;
import tech.tablesaw.filtering.IntPredicate;
import tech.tablesaw.filtering.LocalDatePredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.DateMapUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseIntComparator;
import tech.tablesaw.util.Selection;

public class DateColumn
extends AbstractColumn
implements DateMapUtils {
    public static final int MISSING_VALUE = (Integer)ColumnType.LOCAL_DATE.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 4;
    private IntComparator reverseIntComparator = new IntComparator(){

        public int compare(Integer o2, Integer o1) {
            return o1 < o2 ? -1 : (o1.equals(o2) ? 0 : 1);
        }

        public int compare(int o2, int o1) {
            return o1 < o2 ? -1 : (o1 == o2 ? 0 : 1);
        }
    };
    private IntArrayList data;
    IntComparator comparator = new IntComparator(){

        public int compare(Integer r1, Integer r2) {
            return this.compare((int)r1, (int)r2);
        }

        public int compare(int r1, int r2) {
            int f1 = DateColumn.this.getIntInternal(r1);
            int f2 = DateColumn.this.getIntInternal(r2);
            return Integer.compare(f1, f2);
        }
    };
    private DateTimeFormatter selectedFormatter;
    private final Locale locale;

    public DateColumn(String name) {
        this(name, Locale.getDefault());
    }

    public DateColumn(String name, Locale locale) {
        this(name, new IntArrayList(128), locale);
    }

    public DateColumn(String name, int initialSize) {
        this(name, new IntArrayList(initialSize));
    }

    public DateColumn(String name, List<LocalDate> data) {
        this(name);
        for (LocalDate date : data) {
            this.append(date);
        }
    }

    private DateColumn(String name, IntArrayList data) {
        this(name, data, Locale.getDefault());
    }

    private DateColumn(String name, IntArrayList data, Locale locale) {
        super(name);
        this.data = data;
        this.locale = locale;
    }

    public DateColumn(ColumnMetadata metadata) {
        this(metadata, Locale.getDefault());
    }

    public DateColumn(ColumnMetadata metadata, Locale locale) {
        super(metadata);
        this.data = new IntArrayList(128);
        this.locale = locale;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_DATE;
    }

    public void appendInternal(int f) {
        this.data.add(f);
    }

    @Override
    public IntArrayList data() {
        return this.data;
    }

    public void set(int index, int value) {
        this.data.set(index, value);
    }

    public void append(LocalDate f) {
        this.appendInternal(PackedLocalDate.pack(f));
    }

    @Override
    public String getString(int row) {
        return PackedLocalDate.toDateString(this.getIntInternal(row));
    }

    @Override
    public DateColumn emptyCopy() {
        DateColumn column = new DateColumn(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateColumn emptyCopy(int rowSize) {
        DateColumn column = new DateColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public DateColumn copy() {
        DateColumn column = new DateColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)this.reverseIntComparator);
    }

    @Override
    public int countUnique() {
        IntOpenHashSet ints = new IntOpenHashSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            ints.add(this.data.getInt(i));
        }
        return ints.size();
    }

    @Override
    public DateColumn unique() {
        IntOpenHashSet ints = new IntOpenHashSet(this.data.size());
        for (int i = 0; i < this.size(); ++i) {
            ints.add(this.data.getInt(i));
        }
        return new DateColumn(this.name() + " Unique values", IntArrayList.wrap((int[])ints.toIntArray()));
    }

    public LocalDate firstElement() {
        if (this.isEmpty()) {
            return null;
        }
        return PackedLocalDate.asLocalDate(this.getIntInternal(0));
    }

    public LocalDate max() {
        if (this.isEmpty()) {
            return null;
        }
        Integer max = null;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (MISSING_VALUE == aData) continue;
            if (max == null) {
                max = aData;
                continue;
            }
            max = max > aData ? max : aData;
        }
        if (max == null) {
            return null;
        }
        return PackedLocalDate.asLocalDate(max);
    }

    public LocalDate min() {
        if (this.isEmpty()) {
            return null;
        }
        Integer min = null;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (MISSING_VALUE == aData) continue;
            if (min == null) {
                min = aData;
                continue;
            }
            min = min < aData ? min : aData;
        }
        if (min == null) {
            return null;
        }
        return PackedLocalDate.asLocalDate(min);
    }

    public CategoryColumn dayOfWeek() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + " day of week");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.add(CategoryColumn.MISSING_VALUE);
                continue;
            }
            newColumn.add(PackedLocalDate.getDayOfWeek(c1).toString());
        }
        return newColumn;
    }

    public ShortColumn dayOfWeekValue() {
        ShortColumn newColumn = new ShortColumn(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.set(r, ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDate.getDayOfWeek(c1).getValue());
        }
        return newColumn;
    }

    public ShortColumn dayOfMonth() {
        ShortColumn newColumn = new ShortColumn(this.name() + " day of month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getDayOfMonth(c1));
        }
        return newColumn;
    }

    public ShortColumn dayOfYear() {
        ShortColumn newColumn = new ShortColumn(this.name() + " day of year");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDate.getDayOfYear(c1));
        }
        return newColumn;
    }

    public ShortColumn monthValue() {
        ShortColumn newColumn = new ShortColumn(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getMonthValue(c1));
        }
        return newColumn;
    }

    public CategoryColumn month() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.add(CategoryColumn.MISSING_VALUE);
                continue;
            }
            newColumn.add(PackedLocalDate.getMonth(c1).name());
        }
        return newColumn;
    }

    public ShortColumn year() {
        ShortColumn newColumn = new ShortColumn(this.name() + " year");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == MISSING_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDate.getYear(c1));
        }
        return newColumn;
    }

    @Override
    public LocalDate get(int index) {
        return PackedLocalDate.asLocalDate(this.getIntInternal(index));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public int convert(String value) {
        LocalDate date;
        if (Strings.isNullOrEmpty((String)value) || TypeUtils.MISSING_INDICATORS.contains((Object)value) || value.equals("-1")) {
            return (Integer)ColumnType.LOCAL_DATE.getMissingValue();
        }
        String paddedValue = Strings.padStart((String)value, (int)4, (char)'0');
        if (this.selectedFormatter == null) {
            this.selectedFormatter = TypeUtils.getDateFormatter(paddedValue).withLocale(this.locale);
        }
        try {
            date = LocalDate.parse(paddedValue, this.selectedFormatter);
        }
        catch (DateTimeParseException e) {
            this.selectedFormatter = TypeUtils.DATE_FORMATTER.withLocale(this.locale);
            date = LocalDate.parse(paddedValue, this.selectedFormatter);
        }
        return PackedLocalDate.pack(date);
    }

    @Override
    public void appendCell(String string) {
        this.appendInternal(this.convert(string));
    }

    @Override
    public int getIntInternal(int index) {
        return this.data.getInt(index);
    }

    public Selection isEqualTo(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.select(IntColumnUtils.isEqualTo, packed);
    }

    public Selection isEqualTo(DateColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator intIterator = column.intIterator();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (next == intIterator.nextInt()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        CategoryColumn measure = new CategoryColumn("Measure");
        CategoryColumn value = new CategoryColumn("Value");
        table.addColumn(measure);
        table.addColumn(value);
        measure.add("Count");
        value.add(String.valueOf(this.size()));
        measure.add("Missing");
        value.add(String.valueOf(this.countMissing()));
        measure.add("Earliest");
        value.add(String.valueOf(this.min()));
        measure.add("Latest");
        value.add(String.valueOf(this.max()));
        return table;
    }

    public Selection isAfter(int value) {
        return this.select(PackedLocalDate::isAfter, value);
    }

    public Selection isAfter(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.select(PackedLocalDate::isAfter, packed);
    }

    public Selection isBefore(int value) {
        return this.select(PackedLocalDate::isBefore, value);
    }

    public Selection isBefore(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.select(PackedLocalDate::isBefore, packed);
    }

    public Selection isOnOrBefore(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.select(PackedLocalDate::isOnOrBefore, packed);
    }

    public Selection isOnOrBefore(int value) {
        return this.select(PackedLocalDate::isOnOrBefore, value);
    }

    public Selection isOnOrAfter(LocalDate value) {
        int packed = PackedLocalDate.pack(value);
        return this.select(PackedLocalDate::isOnOrAfter, packed);
    }

    public Selection isOnOrAfter(int value) {
        return this.select(PackedLocalDate::isOnOrAfter, value);
    }

    public Selection isMonday() {
        return this.select(PackedLocalDate::isMonday);
    }

    public Selection isTuesday() {
        return this.select(PackedLocalDate::isTuesday);
    }

    public Selection isWednesday() {
        return this.select(PackedLocalDate::isWednesday);
    }

    public Selection isThursday() {
        return this.select(PackedLocalDate::isThursday);
    }

    public Selection isFriday() {
        return this.select(PackedLocalDate::isFriday);
    }

    public Selection isSaturday() {
        return this.select(PackedLocalDate::isSaturday);
    }

    public Selection isSunday() {
        return this.select(PackedLocalDate::isSunday);
    }

    public Selection isInJanuary() {
        return this.select(PackedLocalDate::isInJanuary);
    }

    public Selection isInFebruary() {
        return this.select(PackedLocalDate::isInFebruary);
    }

    public Selection isInMarch() {
        return this.select(PackedLocalDate::isInMarch);
    }

    public Selection isInApril() {
        return this.select(PackedLocalDate::isInApril);
    }

    public Selection isInMay() {
        return this.select(PackedLocalDate::isInMay);
    }

    public Selection isInJune() {
        return this.select(PackedLocalDate::isInJune);
    }

    public Selection isInJuly() {
        return this.select(PackedLocalDate::isInJuly);
    }

    public Selection isInAugust() {
        return this.select(PackedLocalDate::isInAugust);
    }

    public Selection isInSeptember() {
        return this.select(PackedLocalDate::isInSeptember);
    }

    public Selection isInOctober() {
        return this.select(PackedLocalDate::isInOctober);
    }

    public Selection isInNovember() {
        return this.select(PackedLocalDate::isInNovember);
    }

    public Selection isInDecember() {
        return this.select(PackedLocalDate::isInDecember);
    }

    public Selection isFirstDayOfMonth() {
        return this.select(PackedLocalDate::isFirstDayOfMonth);
    }

    public Selection isLastDayOfMonth() {
        return this.select(PackedLocalDate::isLastDayOfMonth);
    }

    public Selection isInQ1() {
        return this.select(PackedLocalDate::isInQ1);
    }

    public Selection isInQ2() {
        return this.select(PackedLocalDate::isInQ2);
    }

    public Selection isInQ3() {
        return this.select(PackedLocalDate::isInQ3);
    }

    public Selection isInQ4() {
        return this.select(PackedLocalDate::isInQ4);
    }

    public Selection isInYear(int year) {
        return this.select(PackedLocalDate::isInYear, year);
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            builder.append(String.valueOf(PackedLocalDate.asLocalDate(next)));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    public String toString() {
        return "LocalDate column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DateColumn intColumn = (DateColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.appendInternal(intColumn.getIntInternal(i));
        }
    }

    public DateColumn selectIf(LocalDatePredicate predicate) {
        DateColumn column = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (!predicate.test(PackedLocalDate.asLocalDate(next))) continue;
            column.appendInternal(next);
        }
        return column;
    }

    public DateColumn selectIf(IntPredicate predicate) {
        DateColumn column = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (!predicate.test(next)) continue;
            column.appendInternal(next);
        }
        return column;
    }

    public List<LocalDate> top(int n) {
        ArrayList<LocalDate> top = new ArrayList<LocalDate>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)ReverseIntComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalDate.asLocalDate(values[i]));
        }
        return top;
    }

    public List<LocalDate> bottom(int n) {
        ArrayList<LocalDate> bottom = new ArrayList<LocalDate>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedLocalDate.asLocalDate(values[i]));
        }
        return bottom;
    }

    public IntIterator intIterator() {
        return this.data.iterator();
    }

    public Selection select(IntPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection select(IntBiPredicate predicate, int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next, value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    public List<LocalDate> asList() {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(this.size());
        Iterator<LocalDate> iter = this.iterator();
        while (iter.hasNext()) {
            dates.add(iter.next());
        }
        return dates;
    }

    public Set<LocalDate> asSet() {
        HashSet<LocalDate> dates = new HashSet<LocalDate>();
        DateColumn unique = this.unique();
        for (LocalDate d : unique) {
            dates.add(d);
        }
        return dates;
    }

    public DateTimeColumn with(TimeColumn timeColumn) {
        String dateTimeColumnName = this.name() + " : " + timeColumn.name();
        DateTimeColumn dateTimeColumn = new DateTimeColumn(dateTimeColumnName, this.size());
        for (int row = 0; row < this.size(); ++row) {
            int date = this.getIntInternal(row);
            int time = timeColumn.getIntInternal(row);
            long packedLocalDateTime = PackedLocalDateTime.create(date, time);
            dateTimeColumn.appendInternal(packedLocalDateTime);
        }
        return dateTimeColumn;
    }

    public boolean contains(LocalDate localDate) {
        int date = PackedLocalDate.pack(localDate);
        return this.data().contains(date);
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.getIntInternal(rowNumber)).array();
    }

    @Override
    public Iterator<LocalDate> iterator() {
        return new Iterator<LocalDate>(){
            IntIterator intIterator;
            {
                this.intIterator = DateColumn.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.intIterator.hasNext();
            }

            @Override
            public LocalDate next() {
                return PackedLocalDate.asLocalDate(this.intIterator.nextInt());
            }
        };
    }

    @Override
    public DateColumn difference() {
        throw new UnsupportedOperationException("DateTimeColumn.difference() currently not supported");
    }
}

