/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.IntConvertibleColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ShortColumnUtils;
import tech.tablesaw.filtering.ShortBiPredicate;
import tech.tablesaw.filtering.ShortPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.ShortMapUtils;
import tech.tablesaw.sorting.IntComparisonUtil;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseShortComparator;
import tech.tablesaw.util.Selection;
import tech.tablesaw.util.Stats;

public class ShortColumn
extends AbstractColumn
implements ShortMapUtils,
NumericColumn,
IntConvertibleColumn {
    public static final short MISSING_VALUE = (Short)ColumnType.SHORT_INT.getMissingValue();
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 2;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private ShortArrayList data;
    final IntComparator comparator = new IntComparator(){

        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        public int compare(int i1, int i2) {
            short prim1 = ShortColumn.this.get(i1);
            short prim2 = ShortColumn.this.get(i2);
            return IntComparisonUtil.getInstance().compare(prim1, prim2);
        }
    };

    public ShortColumn(String name) {
        this(name, new ShortArrayList(128));
    }

    public ShortColumn(String name, int initialSize) {
        this(name, new ShortArrayList(initialSize));
    }

    public ShortColumn(String name, short[] arr) {
        this(name, new ShortArrayList(arr));
    }

    private ShortColumn(String name, ShortArrayList data) {
        super(name);
        this.data = data;
    }

    public ShortColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new ShortArrayList(metadata.getSize());
    }

    public static short convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return (Short)ColumnType.SHORT_INT.getMissingValue();
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Short.parseShort(matcher.replaceAll(""));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public ColumnType type() {
        return ColumnType.SHORT_INT;
    }

    public void append(short i) {
        this.data.add(i);
    }

    public void set(int index, short value) {
        this.data.set(index, value);
    }

    public Selection isLessThan(int i) {
        return this.select(ShortColumnUtils.isLessThan, i);
    }

    public Selection isGreaterThan(int i) {
        return this.select(ShortColumnUtils.isGreaterThan, i);
    }

    public Selection isGreaterThanOrEqualTo(int i) {
        return this.select(ShortColumnUtils.isGreaterThanOrEqualTo, i);
    }

    public Selection isLessThanOrEqualTo(int i) {
        return this.select(ShortColumnUtils.isLessThanOrEqualTo, i);
    }

    public Selection isNotEqualTo(int i) {
        return this.select(ShortColumnUtils.isNotEqualTo, i);
    }

    public Selection isEqualTo(int i) {
        return this.select(ShortColumnUtils.isEqualTo, i);
    }

    public Selection isEqualTo(ShortColumn f) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ShortIterator shortIterator = f.iterator();
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short next = (Short)shortListIterator.next();
            if (next == shortIterator.nextShort()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public ShortColumn select(Selection selection) {
        ShortColumn column = this.emptyCopy();
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            int next = (Integer)intIterator.next();
            column.append(this.data.getShort(next));
        }
        return column;
    }

    @Override
    public Table summary() {
        return this.stats().asTable();
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short i = (Short)shortListIterator.next();
            selection.add(i);
        }
        return selection.size();
    }

    @Override
    public ShortColumn unique() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short i = (Short)shortListIterator.next();
            selection.add(i);
        }
        int[] ints = selection.toArray();
        short[] shorts = new short[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            shorts[i] = (short)ints[i];
        }
        return new ShortColumn(this.name() + " Unique values", ShortArrayList.wrap((short[])shorts));
    }

    @Override
    public String getString(int row) {
        short value = this.data.getShort(row);
        if (value == MISSING_VALUE) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public ShortColumn emptyCopy() {
        ShortColumn column = new ShortColumn(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public ShortColumn emptyCopy(int rowSize) {
        ShortColumn column = new ShortColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        ShortArrays.parallelQuickSort((short[])this.data.elements(), (ShortComparator)ReverseShortComparator.instance());
    }

    @Override
    public ShortColumn copy() {
        ShortColumn copy = this.emptyCopy(this.size());
        copy.data.addAll((ShortList)this.data);
        copy.setComment(this.comment());
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void appendCell(String object) {
        try {
            this.append(ShortColumn.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    public short get(int index) {
        return this.data.getShort(index);
    }

    @Override
    public float getFloat(int index) {
        return this.data.getShort(index);
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public long sum() {
        return Math.round(AggregateFunctions.sum.agg(this.toDoubleArray()));
    }

    @Override
    public double product() {
        return AggregateFunctions.product.agg(this);
    }

    @Override
    public double mean() {
        return AggregateFunctions.mean.agg(this);
    }

    @Override
    public double median() {
        return AggregateFunctions.median.agg(this);
    }

    @Override
    public double quartile1() {
        return AggregateFunctions.quartile1.agg(this);
    }

    @Override
    public double quartile3() {
        return AggregateFunctions.quartile3.agg(this);
    }

    @Override
    public double percentile(double percentile) {
        return AggregateFunctions.percentile(this.toDoubleArray(), percentile);
    }

    @Override
    public double range() {
        return AggregateFunctions.range.agg(this);
    }

    @Override
    public double max() {
        return (short)Math.round(AggregateFunctions.max.agg(this));
    }

    @Override
    public double min() {
        return (short)Math.round(AggregateFunctions.min.agg(this));
    }

    @Override
    public double variance() {
        return AggregateFunctions.variance.agg(this);
    }

    @Override
    public double populationVariance() {
        return AggregateFunctions.populationVariance.agg(this);
    }

    @Override
    public double standardDeviation() {
        return AggregateFunctions.stdDev.agg(this);
    }

    @Override
    public double sumOfLogs() {
        return AggregateFunctions.sumOfLogs.agg(this);
    }

    @Override
    public double sumOfSquares() {
        return AggregateFunctions.sumOfSquares.agg(this);
    }

    @Override
    public double geometricMean() {
        return AggregateFunctions.geometricMean.agg(this);
    }

    @Override
    public double quadraticMean() {
        return AggregateFunctions.quadraticMean.agg(this);
    }

    @Override
    public double kurtosis() {
        return AggregateFunctions.kurtosis.agg(this);
    }

    @Override
    public double skewness() {
        return AggregateFunctions.skewness.agg(this);
    }

    public short firstElement() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return MISSING_VALUE;
    }

    public Selection isPositive() {
        return this.select(ShortColumnUtils.isPositive);
    }

    public Selection isNegative() {
        return this.select(ShortColumnUtils.isNegative);
    }

    public Selection isNonNegative() {
        return this.select(ShortColumnUtils.isNonNegative);
    }

    public Selection isZero() {
        return this.select(ShortColumnUtils.isZero);
    }

    public Selection isEven() {
        return this.select(ShortColumnUtils.isEven);
    }

    public Selection isOdd() {
        return this.select(ShortColumnUtils.isOdd);
    }

    public FloatArrayList toFloatArray() {
        FloatArrayList output = new FloatArrayList(this.data.size());
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short aData = (Short)shortListIterator.next();
            output.add((float)aData);
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        ShortListIterator shortListIterator = this.data.iterator();
        while (shortListIterator.hasNext()) {
            short i = (Short)shortListIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "ShortInt column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        ShortColumn shortColumn = (ShortColumn)column;
        for (int i = 0; i < shortColumn.size(); ++i) {
            this.append(shortColumn.get(i));
        }
    }

    ShortColumn selectIf(ShortPredicate predicate) {
        ShortColumn column = this.emptyCopy();
        ShortIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            short next = intIterator.nextShort();
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    public IntColumn remainder(ShortColumn column2) {
        IntColumn result = new IntColumn(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) % column2.get(r));
        }
        return result;
    }

    public IntColumn append(ShortColumn column2) {
        IntColumn result = new IntColumn(this.name() + " + " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + column2.get(r));
        }
        return result;
    }

    public IntColumn subtract(ShortColumn column2) {
        IntColumn result = new IntColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) - column2.get(r));
        }
        return result;
    }

    public IntColumn multiply(ShortColumn column2) {
        IntColumn result = new IntColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * column2.get(r));
        }
        return result;
    }

    public FloatColumn multiply(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append((float)this.get(r) * column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append((float)this.get(r) / column2.get(r));
        }
        return result;
    }

    public IntColumn divide(ShortColumn column2) {
        IntColumn result = new IntColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / column2.get(r));
        }
        return result;
    }

    public ShortArrayList top(int n) {
        ShortArrayList top = new ShortArrayList();
        short[] values = this.data.toShortArray();
        ShortArrays.parallelQuickSort((short[])values, (ShortComparator)ReverseShortComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    public ShortArrayList bottom(int n) {
        ShortArrayList bottom = new ShortArrayList();
        short[] values = this.data.toShortArray();
        ShortArrays.parallelQuickSort((short[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    public ShortIterator iterator() {
        return this.data.iterator();
    }

    public Selection select(ShortPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            short next = this.data.getShort(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(ShortBiPredicate predicate, int valueToCompareAgainst) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            short next = this.data.getShort(idx);
            if (!predicate.test(next, valueToCompareAgainst)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    @Override
    public double[] toDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getShort(i);
        }
        return output;
    }

    public ShortSet asSet() {
        return new ShortOpenHashSet((ShortCollection)this.data);
    }

    public boolean contains(short value) {
        return this.data.contains(value);
    }

    public Stats stats() {
        FloatColumn values = new FloatColumn(this.name(), this.toFloatArray());
        return Stats.create(values);
    }

    public ShortArrayList data() {
        return this.data;
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    @Override
    public int byteSize() {
        return 2;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(2).putShort(this.get(rowNumber)).array();
    }

    @Override
    public ShortColumn difference() {
        ShortColumn returnValue = new ShortColumn(this.name(), this.size());
        returnValue.append(MISSING_VALUE);
        for (int current = 0; current < this.size(); ++current) {
            if (current + 1 >= this.size()) continue;
            short currentValue = this.get(current);
            short nextValue = this.get(current + 1);
            if (current == MISSING_VALUE || nextValue == MISSING_VALUE) {
                returnValue.append(MISSING_VALUE);
                continue;
            }
            returnValue.append((short)(nextValue - currentValue));
        }
        return returnValue;
    }

    @Override
    public int[] toIntArray() {
        int[] output = new int[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getShort(i);
        }
        return output;
    }
}

