/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Set;

public class DictionaryMap {
    private final Int2ObjectMap<String> keyToValue = new Int2ObjectOpenHashMap();
    private final Object2IntMap<String> valueToKey = new Object2IntOpenHashMap();

    public DictionaryMap() {
        this.valueToKey.defaultReturnValue(-1);
    }

    public DictionaryMap(DictionaryMap original) {
        for (Int2ObjectMap.Entry entry : original.keyToValue.int2ObjectEntrySet()) {
            this.keyToValue.put(entry.getIntKey(), entry.getValue());
            this.valueToKey.put(entry.getValue(), entry.getIntKey());
        }
        this.valueToKey.defaultReturnValue(-1);
    }

    public void put(int key, String value) {
        this.keyToValue.put(key, (Object)value);
        this.valueToKey.put((Object)value, key);
    }

    public String get(int key) {
        return (String)this.keyToValue.get(key);
    }

    public int get(String value) {
        return this.valueToKey.getInt((Object)value);
    }

    public void remove(short key) {
        String value = (String)this.keyToValue.remove((int)key);
        this.valueToKey.removeInt((Object)value);
    }

    public void remove(String value) {
        int key = this.valueToKey.removeInt((Object)value);
        this.keyToValue.remove(key);
    }

    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    public boolean contains(String stringValue) {
        return this.valueToKey.containsKey((Object)stringValue);
    }

    public int size() {
        return this.categories().size();
    }

    public Set<String> categories() {
        return this.valueToKey.keySet();
    }

    public String[] categoryArray() {
        return (String[])this.keyToValue.values().toArray((Object[])new String[this.size()]);
    }

    public IntCollection values() {
        return this.valueToKey.values();
    }

    public Int2ObjectMap<String> keyToValueMap() {
        return this.keyToValue;
    }

    public Object2IntMap<String> valueToKeyMap() {
        return this.valueToKey;
    }
}

