/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import java.time.LocalDate;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.util.Selection;

public class LocalDateBetweenInclusive
extends ColumnFilter {
    private final LocalDate low;
    private final LocalDate high;

    public LocalDateBetweenInclusive(ColumnReference reference, LocalDate lowValue, LocalDate highValue) {
        super(reference);
        this.low = lowValue;
        this.high = highValue;
    }

    @Override
    public Selection apply(Table relation) {
        DateColumn column = (DateColumn)relation.column(this.columnReference.getColumnName());
        Selection matches = column.isOnOrAfter(this.low);
        matches.and(column.isOnOrBefore(this.high));
        return matches;
    }
}

