/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatIterable;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.FloatColumnUtils;
import tech.tablesaw.filtering.FloatBiPredicate;
import tech.tablesaw.filtering.FloatPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.Selection;
import tech.tablesaw.util.Stats;

public class FloatColumn
extends AbstractColumn
implements FloatIterable,
NumericColumn {
    public static final float MISSING_VALUE = ((Float)ColumnType.FLOAT.getMissingValue()).floatValue();
    private static final int BYTE_SIZE = 4;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int DEFAULT_ARRAY_SIZE = 128;
    private FloatComparator reverseFloatComparator = new FloatComparator(){

        public int compare(Float o2, Float o1) {
            return o1.floatValue() < o2.floatValue() ? -1 : (o1.equals(o2) ? 0 : 1);
        }

        public int compare(float o2, float o1) {
            return o1 < o2 ? -1 : (o1 == o2 ? 0 : 1);
        }
    };
    private FloatArrayList data;
    private final IntComparator comparator = new IntComparator(){

        public int compare(Integer r1, Integer r2) {
            float f1 = FloatColumn.this.data.getFloat(r1.intValue());
            float f2 = FloatColumn.this.data.getFloat(r2.intValue());
            return Float.compare(f1, f2);
        }

        public int compare(int r1, int r2) {
            float f1 = FloatColumn.this.data.getFloat(r1);
            float f2 = FloatColumn.this.data.getFloat(r2);
            return Float.compare(f1, f2);
        }
    };

    public FloatColumn(String name) {
        this(name, new FloatArrayList(128));
    }

    public FloatColumn(String name, int initialSize) {
        this(name, new FloatArrayList(initialSize));
    }

    public FloatColumn(String name, float[] arr) {
        this(name, new FloatArrayList(arr));
    }

    public FloatColumn(String name, FloatArrayList data) {
        super(name);
        this.data = data;
    }

    public FloatColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new FloatArrayList(metadata.getSize());
    }

    public static float convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Float.parseFloat(matcher.replaceAll(""));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Table summary() {
        return this.stats().asTable();
    }

    public Stats stats() {
        return Stats.create(this);
    }

    @Override
    public int countUnique() {
        FloatOpenHashSet floats = new FloatOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            floats.add(this.data.getFloat(i));
        }
        return floats.size();
    }

    public FloatArrayList top(int n) {
        FloatArrayList top = new FloatArrayList();
        float[] values = this.data.toFloatArray();
        FloatArrays.parallelQuickSort((float[])values, (FloatComparator)this.reverseFloatComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    public FloatArrayList bottom(int n) {
        FloatArrayList bottom = new FloatArrayList();
        float[] values = this.data.toFloatArray();
        FloatArrays.parallelQuickSort((float[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    @Override
    public FloatColumn unique() {
        FloatOpenHashSet floats = new FloatOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            floats.add(this.data.getFloat(i));
        }
        FloatColumn column = new FloatColumn(this.name() + " Unique values", floats.size());
        floats.forEach(column::append);
        return column;
    }

    public FloatArrayList data() {
        return this.data;
    }

    @Override
    public ColumnType type() {
        return ColumnType.FLOAT;
    }

    public float firstElement() {
        if (this.size() > 0) {
            return this.data.getFloat(0);
        }
        return MISSING_VALUE;
    }

    public double sum() {
        return AggregateFunctions.sum.agg(this);
    }

    @Override
    public double product() {
        return AggregateFunctions.product.agg(this);
    }

    @Override
    public double mean() {
        return AggregateFunctions.mean.agg(this);
    }

    @Override
    public double median() {
        return AggregateFunctions.median.agg(this);
    }

    @Override
    public double quartile1() {
        return AggregateFunctions.quartile1.agg(this);
    }

    @Override
    public double quartile3() {
        return AggregateFunctions.quartile3.agg(this);
    }

    @Override
    public double percentile(double percentile) {
        return AggregateFunctions.percentile(this.toDoubleArray(), percentile);
    }

    @Override
    public double range() {
        return AggregateFunctions.range.agg(this);
    }

    @Override
    public double max() {
        return AggregateFunctions.max.agg(this);
    }

    @Override
    public double min() {
        return AggregateFunctions.min.agg(this);
    }

    @Override
    public double variance() {
        return AggregateFunctions.variance.agg(this);
    }

    @Override
    public double populationVariance() {
        return AggregateFunctions.populationVariance.agg(this);
    }

    @Override
    public double standardDeviation() {
        return AggregateFunctions.stdDev.agg(this);
    }

    @Override
    public double sumOfLogs() {
        return AggregateFunctions.sumOfLogs.agg(this);
    }

    @Override
    public double sumOfSquares() {
        return AggregateFunctions.sumOfSquares.agg(this);
    }

    @Override
    public double geometricMean() {
        return AggregateFunctions.geometricMean.agg(this);
    }

    @Override
    public double quadraticMean() {
        return AggregateFunctions.quadraticMean.agg(this);
    }

    @Override
    public double kurtosis() {
        return AggregateFunctions.kurtosis.agg(this);
    }

    @Override
    public double skewness() {
        return AggregateFunctions.skewness.agg(this);
    }

    public void append(float f) {
        this.data.add(f);
    }

    public void append(double d) {
        this.data.add((float)d);
    }

    public Selection isLessThan(float f) {
        return this.select(FloatColumnUtils.isLessThan, f);
    }

    public Selection isZero() {
        return this.select(FloatColumnUtils.isZero);
    }

    public Selection isNegative() {
        return this.select(FloatColumnUtils.isNegative);
    }

    public Selection isPositive() {
        return this.select(FloatColumnUtils.isPositive);
    }

    public Selection isNonNegative() {
        return this.select(FloatColumnUtils.isNonNegative);
    }

    @Override
    public Selection isMissing() {
        return this.select(FloatColumnUtils.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(FloatColumnUtils.isNotMissing);
    }

    public Selection isGreaterThan(float f) {
        return this.select(FloatColumnUtils.isGreaterThan, f);
    }

    public Selection isGreaterThanOrEqualTo(float f) {
        return this.select(FloatColumnUtils.isGreaterThanOrEqualTo, f);
    }

    public Selection isLessThanOrEqualTo(float f) {
        return this.select(FloatColumnUtils.isLessThanOrEqualTo, f);
    }

    public Selection isNotEqualTo(float f) {
        return this.select(FloatColumnUtils.isNotEqualTo, f);
    }

    public Selection isEqualTo(float f) {
        return this.select(FloatColumnUtils.isEqualTo, f);
    }

    public Selection isEqualTo(FloatColumn f) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        FloatIterator floatIterator = f.iterator();
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float floats = ((Float)floatListIterator.next()).floatValue();
            if (floats == floatIterator.nextFloat()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public String getString(int row) {
        return String.valueOf(this.data.getFloat(row));
    }

    @Override
    public FloatColumn emptyCopy() {
        FloatColumn column = new FloatColumn(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public FloatColumn emptyCopy(int rowSize) {
        FloatColumn column = new FloatColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data = new FloatArrayList(128);
    }

    @Override
    public FloatColumn copy() {
        FloatColumn column = new FloatColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        FloatArrays.parallelQuickSort((float[])this.data.elements(), (FloatComparator)this.reverseFloatComparator);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            float f = this.get(i);
            if (f == f) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void appendCell(String object) {
        Preconditions.checkNotNull((Object)object);
        try {
            this.append(FloatColumn.convert(object));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(this.name() + ": " + nfe.getMessage());
        }
    }

    public FloatColumn logN() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[logN]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append((float)Math.log(value));
        }
        return newColumn;
    }

    public FloatColumn log10() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[log10]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append((float)Math.log10(value));
        }
        return newColumn;
    }

    public FloatColumn log1p() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[1og1p]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append((float)Math.log1p(value));
        }
        return newColumn;
    }

    public FloatColumn round() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[rounded]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append(Math.round(value));
        }
        return newColumn;
    }

    public FloatColumn abs() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[abs]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append(Math.abs(value));
        }
        return newColumn;
    }

    public FloatColumn square() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[sq]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append(value * value);
        }
        return newColumn;
    }

    public FloatColumn sqrt() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[sqrt]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append((float)Math.sqrt(value));
        }
        return newColumn;
    }

    public FloatColumn cubeRoot() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[cbrt]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append((float)Math.cbrt(value));
        }
        return newColumn;
    }

    public FloatColumn cube() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[cb]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append(value * value * value);
        }
        return newColumn;
    }

    public FloatColumn remainder(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) % column2.get(r));
        }
        return result;
    }

    public FloatColumn append(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " + " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + column2.get(r));
        }
        return result;
    }

    public FloatColumn subtract(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) - column2.get(r));
        }
        return result;
    }

    public FloatColumn multiply(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * column2.get(r));
        }
        return result;
    }

    public FloatColumn multiply(IntColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * (float)column2.get(r));
        }
        return result;
    }

    public FloatColumn multiply(LongColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * (float)column2.get(r));
        }
        return result;
    }

    public FloatColumn multiply(ShortColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * (float)column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(IntColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / (float)column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(LongColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / (float)column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(ShortColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) / (float)column2.get(r));
        }
        return result;
    }

    public FloatColumn neg() {
        FloatColumn newColumn = new FloatColumn(this.name() + "[neg]", this.size());
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            float value = ((Float)floatIterator.next()).floatValue();
            newColumn.append(value * -1.0f);
        }
        return newColumn;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public float get(int index) {
        return this.data.getFloat(index);
    }

    @Override
    public float getFloat(int index) {
        return this.data.getFloat(index);
    }

    public void set(int r, float value) {
        this.data.add(r, value);
    }

    Selection isCloseTo(float target) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float f = ((Float)floatListIterator.next()).floatValue();
            if (Float.compare(f, target) == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    Selection isCloseTo(double target) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        FloatListIterator floatListIterator = this.data.iterator();
        while (floatListIterator.hasNext()) {
            float f = ((Float)floatListIterator.next()).floatValue();
            if (Double.compare(f, 0.0) == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public double[] toDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getFloat(i);
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        for (Float aData : this.data) {
            builder.append(String.valueOf(aData));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Float column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        FloatColumn floatColumn = (FloatColumn)column;
        for (int i = 0; i < floatColumn.size(); ++i) {
            this.append(floatColumn.get(i));
        }
    }

    public FloatIterator iterator() {
        return this.data.iterator();
    }

    public Selection select(FloatPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            float next = this.data.getFloat(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(FloatBiPredicate predicate, float value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            float next = this.data.getFloat(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    FloatSet asSet() {
        return new FloatOpenHashSet((FloatCollection)this.data);
    }

    public boolean contains(float value) {
        return this.data.contains(value);
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putFloat(this.get(rowNumber)).array();
    }

    @Override
    public FloatColumn difference() {
        FloatColumn returnValue = new FloatColumn(this.name(), this.size());
        returnValue.append(MISSING_VALUE);
        for (int current = 0; current < this.size(); ++current) {
            if (current + 1 >= this.size()) continue;
            float currentValue = this.get(current);
            float nextValue = this.get(current + 1);
            if (currentValue != currentValue || nextValue != nextValue) {
                returnValue.append(Float.NaN);
                continue;
            }
            returnValue.append(nextValue - currentValue);
        }
        return returnValue;
    }

    public FloatColumn add(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + column2.get(r));
        }
        return result;
    }

    public FloatColumn addToEach(float value) {
        FloatColumn result = new FloatColumn(this.name() + " + " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + value);
        }
        return result;
    }

    public FloatColumn addToEach(int value) {
        FloatColumn result = new FloatColumn(this.name() + " + " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + (float)value);
        }
        return result;
    }
}

