/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.arrow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.RuntimeIOException;

public class ArrowWriter {
    private Schema tableSchema(Table table) {
        ArrayList<Field> fields = new ArrayList<Field>();
        block26: for (Column column : table.columns()) {
            String typeName;
            switch (typeName = column.type().name()) {
                case "STRING": {
                    fields.add(new Field(column.name(), FieldType.nullable((ArrowType)new ArrowType.Utf8()), null));
                    continue block26;
                }
                case "LONG": {
                    fields.add(new Field(column.name(), FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), null));
                    continue block26;
                }
                case "INTEGER": {
                    fields.add(new Field(column.name(), FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null));
                    continue block26;
                }
                case "SHORT": {
                    fields.add(new Field(column.name(), FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null));
                    continue block26;
                }
                case "LOCAL_DATE": {
                    fields.add(new Field(column.name(), FieldType.notNullable((ArrowType)new ArrowType.Date(DateUnit.DAY)), null));
                    continue block26;
                }
                case "LOCAL_DATE_TIME": {
                    fields.add(new Field(column.name(), FieldType.notNullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)), null));
                    continue block26;
                }
                case "LOCAL_TIME": {
                    fields.add(new Field(column.name(), FieldType.notNullable((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)), null));
                    continue block26;
                }
                case "INSTANT": {
                    fields.add(new Field(column.name(), FieldType.notNullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC")), null));
                    continue block26;
                }
                case "BOOLEAN": {
                    fields.add(new Field(column.name(), FieldType.nullable((ArrowType)Types.MinorType.BIT.getType()), null));
                    continue block26;
                }
                case "FLOAT": {
                    fields.add(new Field(column.name(), FieldType.notNullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), null));
                    continue block26;
                }
                case "DOUBLE": {
                    fields.add(new Field(column.name(), FieldType.notNullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), null));
                    continue block26;
                }
            }
            throw new IllegalArgumentException("Unhandled Column type " + typeName + " in exported data");
        }
        return new Schema(fields);
    }

    private void setBytes(VectorSchemaRoot schemaRoot, Column<?> column) {
        String typeName;
        switch (typeName = column.type().name()) {
            case "STRING": {
                VarCharVector sv = (VarCharVector)schemaRoot.getVector(column.name());
                StringColumn sc = (StringColumn)column;
                for (int i = 0; i < sc.size(); ++i) {
                    sv.setSafe(i, sc.get(i).getBytes(StandardCharsets.UTF_8));
                }
                sv.setValueCount(sc.size());
                break;
            }
            case "LONG": {
                BigIntVector lv = (BigIntVector)schemaRoot.getVector(column.name());
                LongColumn lc = (LongColumn)column;
                for (int i = 0; i < lc.size(); ++i) {
                    lv.setSafe(i, lc.getLong(i));
                }
                lv.setValueCount(lc.size());
                break;
            }
            case "INTEGER": {
                IntVector iv = (IntVector)schemaRoot.getVector(column.name());
                IntColumn ic = (IntColumn)column;
                for (int i = 0; i < ic.size(); ++i) {
                    iv.setSafe(i, ic.getInt(i));
                }
                iv.setValueCount(ic.size());
                break;
            }
            case "SHORT": {
                SmallIntVector shortv = (SmallIntVector)schemaRoot.getVector(column.name());
                ShortColumn shortc = (ShortColumn)column;
                for (int i = 0; i < shortc.size(); ++i) {
                    shortv.setSafe(i, shortc.getInt(i));
                }
                shortv.setValueCount(shortc.size());
                break;
            }
            case "LOCAL_DATE": {
                DateDayVector dv = (DateDayVector)schemaRoot.getVector(column.name());
                DateColumn dc = (DateColumn)column;
                for (int i = 0; i < dc.size(); ++i) {
                    dv.setSafe(i, (int)dc.get(i).toEpochDay());
                }
                dv.setValueCount(dc.size());
                break;
            }
            case "LOCAL_DATE_TIME": {
                TimeStampMilliVector dtv = (TimeStampMilliVector)schemaRoot.getVector(column.name());
                DateTimeColumn dtc = (DateTimeColumn)column;
                for (int i = 0; i < dtc.size(); ++i) {
                    dtv.setSafe(i, dtc.get(i).toInstant(ZoneOffset.UTC).toEpochMilli());
                }
                dtv.setValueCount(dtc.size());
                break;
            }
            case "LOCAL_TIME": {
                TimeMilliVector tv = (TimeMilliVector)schemaRoot.getVector(column.name());
                TimeColumn tc = (TimeColumn)column;
                for (int i = 0; i < tc.size(); ++i) {
                    tv.setSafe(i, (int)(tc.get(i).toNanoOfDay() / 1000000L));
                }
                tv.setValueCount(tc.size());
                break;
            }
            case "INSTANT": {
                TimeStampMilliTZVector instv = (TimeStampMilliTZVector)schemaRoot.getVector(column.name());
                InstantColumn instc = (InstantColumn)column;
                for (int i = 0; i < instc.size(); ++i) {
                    instv.setSafe(i, instc.get(i).toEpochMilli());
                }
                instv.setValueCount(instc.size());
                break;
            }
            case "BOOLEAN": {
                BitVector bv = (BitVector)schemaRoot.getVector(column.name());
                BooleanColumn bc = (BooleanColumn)column;
                for (int i = 0; i < bc.size(); ++i) {
                    bv.setSafe(i, (int)bc.getByte(i));
                }
                bv.setValueCount(bc.size());
                break;
            }
            case "FLOAT": {
                Float4Vector fv = (Float4Vector)schemaRoot.getVector(column.name());
                FloatColumn fc = (FloatColumn)column;
                for (int i = 0; i < fc.size(); ++i) {
                    fv.setSafe(i, fc.getFloat(i));
                }
                fv.setValueCount(fc.size());
                break;
            }
            case "DOUBLE": {
                Float8Vector f8v = (Float8Vector)schemaRoot.getVector(column.name());
                DoubleColumn f8c = (DoubleColumn)column;
                for (int i = 0; i < f8c.size(); ++i) {
                    f8v.setSafe(i, f8c.getDouble(i));
                }
                f8v.setValueCount(f8c.size());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled Column type " + typeName + " in exported data");
            }
        }
    }

    public void write(Table table, File file) {
        RootAllocator allocator = new RootAllocator();
        Schema schema = this.tableSchema(table);
        List<FieldVector> fieldVectors = this.createFieldVectors(schema, (BufferAllocator)allocator);
        VectorSchemaRoot schemaRoot = new VectorSchemaRoot(fieldVectors);
        try (FileOutputStream out = new FileOutputStream(file);
             ArrowStreamWriter writer = new ArrowStreamWriter(schemaRoot, null, Channels.newChannel(out));){
            writer.start();
            for (FieldVector v : schemaRoot.getFieldVectors()) {
                v.reset();
            }
            for (Column column : table.columns()) {
                this.setBytes(schemaRoot, column);
            }
            schemaRoot.setRowCount(table.rowCount());
            writer.writeBatch();
            writer.end();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private List<FieldVector> createFieldVectors(Schema schema, BufferAllocator allocator) {
        return schema.getFields().stream().map(field -> field.createVector(allocator)).collect(Collectors.toList());
    }
}

