/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.arrow;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.Types;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.RuntimeIOException;

public class ArrowReader {
    private final File file;

    public ArrowReader(Path path) {
        this.file = path.toFile();
    }

    public ArrowReader(File file) {
        this.file = file;
    }

    public Table read() {
        Table table = Table.create((String)this.file.getName());
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        boolean eos = false;
        try (FileInputStream in = new FileInputStream(this.file);
             ArrowStreamReader reader = new ArrowStreamReader(Channels.newChannel(in), (BufferAllocator)allocator);){
            VectorSchemaRoot vsr = reader.getVectorSchemaRoot();
            while (!eos) {
                VectorSchemaRoot next = reader.getVectorSchemaRoot();
                eos = reader.loadNextBatch();
                next.setRowCount(vsr.getRowCount());
                for (FieldVector v : vsr.getFieldVectors()) {
                    this.getBytes(v, table);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return table;
    }

    private void getBytes(FieldVector v, Table table) {
        Types.MinorType type = v.getMinorType();
        String name = v.getName();
        switch (type) {
            case VARCHAR: {
                StringColumn strCol = StringColumn.create((String)name);
                VarCharVector vcv = (VarCharVector)v;
                for (int i = 0; i < vcv.getValueCount(); ++i) {
                    strCol.append(new String(vcv.get(i)));
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{strCol});
                    break;
                }
                table.stringColumn(strCol.name()).append((Column)strCol);
                break;
            }
            case BIGINT: {
                LongColumn longCol = LongColumn.create((String)name);
                BigIntVector bigIntVector = (BigIntVector)v;
                for (int i = 0; i < bigIntVector.getValueCount(); ++i) {
                    if (!bigIntVector.isNull(i)) {
                        longCol.append(bigIntVector.get(i));
                        continue;
                    }
                    longCol.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{longCol});
                    break;
                }
                table.longColumn(longCol.name()).append((Column)longCol);
                break;
            }
            case INT: {
                IntColumn intCol = IntColumn.create((String)name);
                IntVector intVector = (IntVector)v;
                for (int i = 0; i < intVector.getValueCount(); ++i) {
                    if (!intVector.isNull(i)) {
                        intCol.append(intVector.get(i));
                        continue;
                    }
                    intCol.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{intCol});
                    break;
                }
                table.intColumn(intCol.name()).append((Column)intCol);
                break;
            }
            case SMALLINT: {
                ShortColumn shortColumn = ShortColumn.create((String)name);
                SmallIntVector smallIntVector = (SmallIntVector)v;
                for (int i = 0; i < smallIntVector.getValueCount(); ++i) {
                    if (!smallIntVector.isNull(i)) {
                        shortColumn.append(smallIntVector.get(i));
                        continue;
                    }
                    shortColumn.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{shortColumn});
                    break;
                }
                table.shortColumn(shortColumn.name()).append((Column)shortColumn);
                break;
            }
            case DATEDAY: {
                DateColumn dateCol = DateColumn.create((String)name);
                DateDayVector dateDayVector = (DateDayVector)v;
                for (int i = 0; i < dateDayVector.getValueCount(); ++i) {
                    if (!dateDayVector.isNull(i)) {
                        dateCol.append(LocalDate.ofEpochDay(dateDayVector.get(i)));
                        continue;
                    }
                    dateCol.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{dateCol});
                    break;
                }
                table.dateColumn(dateCol.name()).append((Column)dateCol);
                break;
            }
            case TIMESTAMPMILLI: {
                DateTimeColumn dtCol = DateTimeColumn.create((String)name);
                TimeStampMilliVector dtVector = (TimeStampMilliVector)v;
                for (int i = 0; i < dtVector.getValueCount(); ++i) {
                    if (!dtVector.isNull(i)) {
                        dtCol.append(LocalDateTime.ofInstant(Instant.ofEpochMilli(dtVector.get(i)), ZoneOffset.UTC));
                        continue;
                    }
                    dtCol.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{dtCol});
                    break;
                }
                table.dateTimeColumn(dtCol.name()).append((Column)dtCol);
                break;
            }
            case TIMEMILLI: {
                TimeColumn timeColumn = TimeColumn.create((String)name);
                TimeMilliVector timeVector = (TimeMilliVector)v;
                for (int i = 0; i < timeVector.getValueCount(); ++i) {
                    if (!timeVector.isNull(i)) {
                        timeColumn.append(LocalTime.ofNanoOfDay((long)timeVector.get(i) * 1000000L));
                        continue;
                    }
                    timeColumn.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{timeColumn});
                    break;
                }
                table.timeColumn(timeColumn.name()).append((Column)timeColumn);
                break;
            }
            case TIMESTAMPMILLITZ: {
                InstantColumn instantColumn = InstantColumn.create((String)name);
                TimeStampMilliTZVector instantVector = (TimeStampMilliTZVector)v;
                for (int i = 0; i < instantVector.getValueCount(); ++i) {
                    if (!instantVector.isNull(i)) {
                        instantColumn.append(Instant.ofEpochMilli(instantVector.get(i)));
                        continue;
                    }
                    instantColumn.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{instantColumn});
                    break;
                }
                table.instantColumn(instantColumn.name()).append((Column)instantColumn);
                break;
            }
            case BIT: {
                BooleanColumn booleanColumn = BooleanColumn.create((String)name);
                BitVector booleanVector = (BitVector)v;
                for (int i = 0; i < booleanVector.getValueCount(); ++i) {
                    if (!booleanVector.isNull(i)) {
                        booleanColumn.append((byte)booleanVector.get(i));
                        continue;
                    }
                    booleanColumn.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{booleanColumn});
                    break;
                }
                table.booleanColumn(booleanColumn.name()).append((Column)booleanColumn);
                break;
            }
            case FLOAT4: {
                FloatColumn floatCol = FloatColumn.create((String)name);
                Float4Vector float4Vector = (Float4Vector)v;
                for (int i = 0; i < float4Vector.getValueCount(); ++i) {
                    if (!float4Vector.isNull(i)) {
                        floatCol.append(float4Vector.get(i));
                        continue;
                    }
                    floatCol.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{floatCol});
                    break;
                }
                table.floatColumn(floatCol.name()).append((Column)floatCol);
                break;
            }
            case FLOAT8: {
                DoubleColumn doubleCol = DoubleColumn.create((String)name);
                Float8Vector float8Vector = (Float8Vector)v;
                for (int i = 0; i < float8Vector.getValueCount(); ++i) {
                    if (!float8Vector.isNull(i)) {
                        doubleCol.append(float8Vector.get(i));
                        continue;
                    }
                    doubleCol.appendMissing();
                }
                if (!table.containsColumn(name)) {
                    table.addColumns(new Column[]{doubleCol});
                    break;
                }
                table.doubleColumn(doubleCol.name()).append((Column)doubleCol);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled Column type " + type.name() + " in arrow data");
            }
        }
    }
}

