/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core.components.inputs;

import android.graphics.Typeface;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.widget.EditText;
import androidx.fragment.app.Fragment;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentView;
import tech.skot.core.components.SKComponentViewProxy;
import tech.skot.core.components.inputs.SKInputRAI;
import tech.skot.core.components.inputs.SKInputVC;
import tech.skot.core.components.inputs.SKInputViewProxyCommon;
import tech.skot.view.extensions.EditTextExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B-\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ \u0010\u001c\u001a\u00020\u00182\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001eH\u0016J\u001e\u0010 \u001a\u00020\u00182\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001eH\u0016J\u001e\u0010\"\u001a\u00020\u00182\u0014\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020\u00180\u001eH\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\u0017\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010*\u001a\u00020\u00182\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0006\u0010-\u001a\u00020\u0018R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ltech/skot/core/components/inputs/SKInputViewCommon;", "V", "Landroid/view/View;", "Ltech/skot/core/components/SKComponentView;", "Ltech/skot/core/components/inputs/SKInputRAI;", "proxy", "Ltech/skot/core/components/inputs/SKInputViewProxyCommon;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "view", "(Ltech/skot/core/components/inputs/SKInputViewProxyCommon;Ltech/skot/core/components/SKActivity;Landroidx/fragment/app/Fragment;Landroid/view/View;)V", "editText", "Landroid/widget/EditText;", "getEditText", "()Landroid/widget/EditText;", "firstChangeDoneFor", "", "getProxy", "()Ltech/skot/core/components/inputs/SKInputViewProxyCommon;", "watching", "Landroid/text/TextWatcher;", "onMaxSize", "", "maxSize", "", "(Ljava/lang/Integer;)V", "onOnDone", "onDone", "Lkotlin/Function1;", "", "onOnFocusChange", "onFocusChange", "onOnInputText", "onInputText", "onRecycle", "onShowPassword", "showPassword", "(Ljava/lang/Boolean;)V", "onText", "text", "onType", "type", "Ltech/skot/core/components/inputs/SKInputVC$Type;", "requestFocus", "viewlegacy_release"})
@SourceDebugExtension(value={"SMAP\nSKInputView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SKInputView.kt\ntech/skot/core/components/inputs/SKInputViewCommon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public abstract class SKInputViewCommon<V extends View>
extends SKComponentView<V>
implements SKInputRAI {
    @NotNull
    private final SKInputViewProxyCommon<V> proxy;
    private boolean firstChangeDoneFor;
    @Nullable
    private TextWatcher watching;

    public SKInputViewCommon(@NotNull SKInputViewProxyCommon<V> proxy, @NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull V view) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        super((SKComponentViewProxy)proxy, activity, fragment, view);
        this.proxy = proxy;
    }

    @Override
    @NotNull
    public SKInputViewProxyCommon<V> getProxy() {
        return this.proxy;
    }

    @NotNull
    public abstract EditText getEditText();

    @Override
    public void onMaxSize(@Nullable Integer maxSize) {
        block0: {
            Integer n = maxSize;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            EditText editText = this.getEditText();
            InputFilter[] inputFilterArray = editText.getFilters();
            Intrinsics.checkNotNullExpressionValue((Object)inputFilterArray, (String)"editText.filters");
            editText.setFilters((InputFilter[])ArraysKt.plus((Object[])inputFilterArray, (Object)new InputFilter.LengthFilter(maxSize.intValue())));
        }
    }

    @Override
    public void onOnDone(@Nullable Function1<? super String, Unit> onDone) {
        EditTextExtensionsKt.setOnDone(this.getEditText(), onDone);
    }

    @Override
    public void onOnFocusChange(@Nullable Function1<? super Boolean, Unit> onFocusChange) {
        if (onFocusChange != null) {
            this.getEditText().setOnFocusChangeListener((arg_0, arg_1) -> SKInputViewCommon.onOnFocusChange$lambda$1(onFocusChange, arg_0, arg_1));
        }
    }

    @Override
    public void onOnInputText(@NotNull Function1<? super String, Unit> onInputText) {
        Intrinsics.checkNotNullParameter(onInputText, (String)"onInputText");
        TextWatcher watcher2 = new TextWatcher(this, onInputText){
            final /* synthetic */ SKInputViewCommon<V> this$0;
            final /* synthetic */ Function1<String, Unit> $onInputText;
            {
                this.this$0 = $receiver;
                this.$onInputText = $onInputText;
            }

            public void afterTextChanged(@Nullable Editable p0) {
                CharSequence charSequence;
                String newText;
                Editable editable = p0;
                String string = newText = editable != null ? editable.toString() : null;
                if (SKInputViewCommon.access$getFirstChangeDoneFor$p(this.this$0) || !((charSequence = (CharSequence)newText) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    Editable editable2 = p0;
                    this.$onInputText.invoke((Object)(editable2 != null ? editable2.toString() : null));
                }
                SKInputViewCommon.access$setFirstChangeDoneFor$p(this.this$0, true);
            }

            public void beforeTextChanged(@Nullable CharSequence p0, int p1, int p2, int p3) {
            }

            public void onTextChanged(@Nullable CharSequence p0, int p1, int p2, int p3) {
            }
        };
        TextWatcher textWatcher = this.watching;
        if (textWatcher != null) {
            TextWatcher it = textWatcher;
            boolean bl = false;
            this.getEditText().removeTextChangedListener(it);
        }
        this.getEditText().addTextChangedListener(watcher2);
        this.watching = watcher2;
    }

    @Override
    public void onRecycle() {
        block0: {
            super.onRecycle();
            TextWatcher textWatcher = this.watching;
            if (textWatcher == null) break block0;
            TextWatcher it = textWatcher;
            boolean bl = false;
            this.getEditText().removeTextChangedListener(it);
        }
    }

    @Override
    public void onType(@Nullable SKInputVC.Type type) {
        if (type != null) {
            int n;
            EditText editText = this.getEditText();
            SKInputVC.Type type2 = type;
            if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.EMail.INSTANCE)) {
                n = 209;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.Phone.INSTANCE)) {
                n = 3;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.Password.INSTANCE)) {
                n = 129;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.PasswordWithDefaultHintFont.INSTANCE)) {
                n = 129;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.Number.INSTANCE)) {
                n = 2;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.NumberPassword.INSTANCE)) {
                n = 18;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.LongText.INSTANCE)) {
                n = 131073;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.TextCapSentences.INSTANCE)) {
                n = 16385;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.AllCaps.INSTANCE)) {
                n = 4097;
            } else if (Intrinsics.areEqual((Object)type2, (Object)SKInputVC.Type.Normal.INSTANCE)) {
                n = 1;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            editText.setInputType(n);
            if (Intrinsics.areEqual((Object)type, (Object)SKInputVC.Type.PasswordWithDefaultHintFont.INSTANCE)) {
                this.getEditText().setTypeface(Typeface.DEFAULT);
            }
        }
    }

    @Override
    public void onShowPassword(@Nullable Boolean showPassword) {
        block0: {
            Boolean bl = showPassword;
            if (bl == null) break block0;
            boolean it = bl;
            boolean bl2 = false;
            int selection = this.getEditText().getSelectionStart();
            this.getEditText().setTransformationMethod(it ? null : (TransformationMethod)PasswordTransformationMethod.getInstance());
            this.getEditText().setSelection(selection);
        }
    }

    @Override
    public void onText(@Nullable String text) {
        String oldValue = this.getEditText().getText().toString();
        CharSequence charSequence = text;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if (!StringsKt.isBlank((CharSequence)oldValue)) {
                this.getEditText().setText((CharSequence)text);
            }
        } else if (!Intrinsics.areEqual((Object)text, (Object)oldValue)) {
            this.getEditText().getText().replace(0, oldValue.length(), (CharSequence)text);
        }
    }

    public final void requestFocus() {
        this.getEditText().post(() -> SKInputViewCommon.requestFocus$lambda$5(this));
    }

    private static final void onOnFocusChange$lambda$1(Function1 $onFocusChange, View v, boolean hasFocus) {
        $onFocusChange.invoke((Object)hasFocus);
    }

    private static final void requestFocus$lambda$5(SKInputViewCommon this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getEditText().requestFocus();
    }

    public static final /* synthetic */ boolean access$getFirstChangeDoneFor$p(SKInputViewCommon $this) {
        return $this.firstChangeDoneFor;
    }

    public static final /* synthetic */ void access$setFirstChangeDoneFor$p(SKInputViewCommon $this, boolean bl) {
        $this.firstChangeDoneFor = bl;
    }
}

