/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import tech.skot.core.SKDateFormatKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltech/skot/core/SKDateFormat;", "", "pattern", "", "(Ljava/lang/String;)V", "sdf", "Ljava/text/SimpleDateFormat;", "format", "instant", "Lkotlinx/datetime/Instant;", "localDate", "Lkotlinx/datetime/LocalDate;", "localDateTime", "Lkotlinx/datetime/LocalDateTime;", "parse", "str", "core_release"})
public final class SKDateFormat {
    @NotNull
    private final SimpleDateFormat sdf;

    public SKDateFormat(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.sdf = new SimpleDateFormat(pattern);
    }

    @NotNull
    public final String format(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        String string = this.sdf.format(new Date(instant.toEpochMilliseconds()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdf.format(Date(instant.toEpochMilliseconds()))");
        return string;
    }

    @NotNull
    public final String format(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"localDateTime");
        return this.format(TimeZoneKt.toInstant((LocalDateTime)localDateTime, (TimeZone)TimeZone.Companion.currentSystemDefault()));
    }

    @NotNull
    public final String format(@NotNull LocalDate localDate) {
        Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
        return this.format(SKDateFormatKt.toLocalDateTime(localDate));
    }

    @NotNull
    public final Instant parse(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return Instant.Companion.fromEpochMilliseconds(this.sdf.parse(str).getTime());
    }
}

