/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import com.arellomobile.mvp.MoxyReflector;
import com.arellomobile.mvp.MvpView;
import com.arellomobile.mvp.viewstate.MvpViewState;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class MvpPresenter<View extends MvpView> {
    private boolean mFirstLaunch = true;
    private String mTag;
    private Set<View> mViews;
    private View mViewStateAsView;
    private MvpViewState<View> mViewState;
    private Class<? extends MvpPresenter> mPresenterClass;

    public MvpPresenter() {
        Binder.bind(this);
        this.mViews = Collections.newSetFromMap(new WeakHashMap());
    }

    public void attachView(View view) {
        if (this.mViewState != null) {
            this.mViewState.attachView(view);
        } else {
            this.mViews.add(view);
        }
        if (this.mFirstLaunch) {
            this.mFirstLaunch = false;
            this.onFirstViewAttach();
        }
    }

    protected void onFirstViewAttach() {
    }

    public void detachView(View view) {
        if (this.mViewState != null) {
            this.mViewState.detachView(view);
        } else {
            this.mViews.remove(view);
        }
    }

    public void destroyView(View view) {
        if (this.mViewState != null) {
            this.mViewState.destroyView(view);
        }
    }

    public Set<View> getAttachedViews() {
        if (this.mViewState != null) {
            return this.mViewState.getViews();
        }
        return this.mViews;
    }

    public View getViewState() {
        return this.mViewStateAsView;
    }

    public boolean isInRestoreState(View view) {
        if (this.mViewState != null) {
            return this.mViewState.isInRestoreState(view);
        }
        return false;
    }

    public void setViewState(MvpViewState<View> viewState) {
        this.mViewStateAsView = (MvpView)((Object)viewState);
        this.mViewState = viewState;
    }

    String getTag() {
        return this.mTag;
    }

    void setTag(String tag) {
        this.mTag = tag;
    }

    void setPresenterClass(Class<? extends MvpPresenter> presenterClass) {
        this.mPresenterClass = presenterClass;
    }

    Class<? extends MvpPresenter> getPresenterClass() {
        return this.mPresenterClass;
    }

    public void onDestroy() {
    }

    private static class Binder {
        private Binder() {
        }

        static void bind(MvpPresenter presenter) {
            MvpView viewState = (MvpView)MoxyReflector.getViewState(presenter.getClass());
            presenter.mViewStateAsView = viewState;
            presenter.mViewState = (MvpViewState)((Object)viewState);
        }
    }
}

