/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.viewstate;

import com.arellomobile.mvp.compiler.viewstate.ViewMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

class ViewInterfaceInfo {
    private final TypeElement element;
    private final ClassName name;
    private final List<TypeVariableName> typeVariables;
    private final List<ViewMethod> methods;

    ViewInterfaceInfo(TypeElement element, List<ViewMethod> methods) {
        this.element = element;
        this.name = ClassName.get((TypeElement)element);
        this.methods = methods;
        this.typeVariables = element.getTypeParameters().stream().map(TypeVariableName::get).collect(Collectors.toList());
    }

    public TypeElement getElement() {
        return this.element;
    }

    ClassName getName() {
        return this.name;
    }

    TypeName getNameWithTypeVariables() {
        if (this.typeVariables.isEmpty()) {
            return this.name;
        }
        TypeVariableName[] names = new TypeVariableName[this.typeVariables.size()];
        this.typeVariables.toArray(names);
        return ParameterizedTypeName.get((ClassName)this.name, (TypeName[])names);
    }

    List<TypeVariableName> getTypeVariables() {
        return this.typeVariables;
    }

    List<ViewMethod> getMethods() {
        return this.methods;
    }
}

