/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.x509;

import kotlin.Metadata;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/BasicConstraintsExtension;", "Lorg/bouncycastle/asn1/ASN1Encodable;", "cA", "", "pathLenConstraint", "", "<init>", "(ZI)V", "toASN1Primitive", "Lorg/bouncycastle/asn1/ASN1Primitive;", "awala"})
public final class BasicConstraintsExtension
implements ASN1Encodable {
    private final boolean cA;
    private final int pathLenConstraint;

    public BasicConstraintsExtension(boolean cA, int pathLenConstraint) {
        this.cA = cA;
        this.pathLenConstraint = pathLenConstraint;
        if (this.pathLenConstraint < 0 || 2 < this.pathLenConstraint) {
            throw new CertificateException("pathLenConstraint should be between 0 and 2 (got " + this.pathLenConstraint + ")", null, 2, null);
        }
        if (this.pathLenConstraint != 0 && !this.cA) {
            throw new CertificateException("Subject should be a CA if pathLenConstraint=" + this.pathLenConstraint, null, 2, null);
        }
    }

    @NotNull
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector sequence = new ASN1EncodableVector(2);
        sequence.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)this.cA));
        sequence.add((ASN1Encodable)new ASN1Integer((long)this.pathLenConstraint));
        return (ASN1Primitive)new DERSequence(sequence);
    }
}

