/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.InvalidNodeConnectionParams;
import tech.relaycorp.relaynet.SessionKey;
import tech.relaycorp.relaynet.wrappers.DNS;
import tech.relaycorp.relaynet.wrappers.KeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Ltech/relaycorp/relaynet/NodeConnectionParams;", "", "internetAddress", "", "identityKey", "Ljava/security/PublicKey;", "sessionKey", "Ltech/relaycorp/relaynet/SessionKey;", "<init>", "(Ljava/lang/String;Ljava/security/PublicKey;Ltech/relaycorp/relaynet/SessionKey;)V", "getInternetAddress", "()Ljava/lang/String;", "getIdentityKey", "()Ljava/security/PublicKey;", "getSessionKey", "()Ltech/relaycorp/relaynet/SessionKey;", "serialize", "", "Companion", "awala"})
public final class NodeConnectionParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String internetAddress;
    @NotNull
    private final PublicKey identityKey;
    @NotNull
    private final SessionKey sessionKey;

    public NodeConnectionParams(@NotNull String internetAddress, @NotNull PublicKey identityKey, @NotNull SessionKey sessionKey) {
        Intrinsics.checkNotNullParameter((Object)internetAddress, (String)"internetAddress");
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        this.internetAddress = internetAddress;
        this.identityKey = identityKey;
        this.sessionKey = sessionKey;
    }

    @NotNull
    public final String getInternetAddress() {
        return this.internetAddress;
    }

    @NotNull
    public final PublicKey getIdentityKey() {
        return this.identityKey;
    }

    @NotNull
    public final SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @NotNull
    public final byte[] serialize() {
        Object[] objectArray = new DEROctetString[]{new DEROctetString(this.sessionKey.getKeyId()), new DEROctetString(this.sessionKey.getPublicKey().getEncoded())};
        DERSequence sessionKeyASN1 = ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        objectArray = new ASN1Primitive[]{new DERVisibleString(this.internetAddress), new DEROctetString(this.identityKey.getEncoded()), sessionKeyASN1};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ltech/relaycorp/relaynet/NodeConnectionParams$Companion;", "", "<init>", "()V", "deserialize", "Ltech/relaycorp/relaynet/NodeConnectionParams;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeConnectionParams deserialize(@NotNull byte[] serialization) throws InvalidNodeConnectionParams {
            PublicKey publicKey;
            PublicKey publicKey2;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new InvalidNodeConnectionParams("Serialization is not a DER sequence", exc);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 3) {
                throw new InvalidNodeConnectionParams("Connection params sequence should have at least 3 items (got " + sequence.length + ")", null, 2, null);
            }
            String internetAddress = ASN1Utils.INSTANCE.getVisibleString(sequence[0]).getString();
            Intrinsics.checkNotNull((Object)internetAddress);
            if (!DNS.INSTANCE.isValidDomainName(internetAddress)) {
                throw new InvalidNodeConnectionParams("Internet address is syntactically invalid (" + internetAddress + ")", null, 2, null);
            }
            ASN1OctetString identityKeyASN1 = ASN1Utils.INSTANCE.getOctetString(sequence[1]);
            try {
                byte[] byArray = identityKeyASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
                publicKey2 = Keys.deserializeRSAPublicKey(byArray);
            }
            catch (KeyException exc) {
                throw new InvalidNodeConnectionParams("Identity key is not a valid RSA public key", exc);
            }
            PublicKey identityKey = publicKey2;
            ASN1Sequence sessionKeySequence = DERSequence.getInstance((ASN1TaggedObject)sequence[2], (boolean)false);
            if (sessionKeySequence.size() < 2) {
                throw new InvalidNodeConnectionParams("Session key sequence should have at least 2 items (got " + sessionKeySequence.size() + ")", null, 2, null);
            }
            ASN1Encodable aSN1Encodable = sessionKeySequence.getObjectAt(0);
            Intrinsics.checkNotNull((Object)aSN1Encodable, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            byte[] sessionKeyId = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable).getOctets();
            ASN1Encodable aSN1Encodable2 = sessionKeySequence.getObjectAt(1);
            Intrinsics.checkNotNull((Object)aSN1Encodable2, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            ASN1OctetString sessionPublicKeyASN1 = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable2);
            try {
                byte[] byArray = sessionPublicKeyASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
                publicKey = Keys.deserializeECPublicKey(byArray);
            }
            catch (KeyException exc) {
                throw new InvalidNodeConnectionParams("Session key is not a valid EC public key", exc);
            }
            PublicKey sessionPublicKey = publicKey;
            Intrinsics.checkNotNull((Object)sessionKeyId);
            return new NodeConnectionParams(internetAddress, identityKey, new SessionKey(sessionKeyId, sessionPublicKey));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

