/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.payloads;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.payloads.GatewayEncryptedPayload;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ltech/relaycorp/relaynet/messages/payloads/CargoCollectionRequest;", "Ltech/relaycorp/relaynet/messages/payloads/GatewayEncryptedPayload;", "cargoDeliveryAuthorization", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "<init>", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;)V", "getCargoDeliveryAuthorization", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serializePlaintext", "", "Companion", "awala"})
public final class CargoCollectionRequest
extends GatewayEncryptedPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate cargoDeliveryAuthorization;

    public CargoCollectionRequest(@NotNull Certificate cargoDeliveryAuthorization) {
        Intrinsics.checkNotNullParameter((Object)cargoDeliveryAuthorization, (String)"cargoDeliveryAuthorization");
        this.cargoDeliveryAuthorization = cargoDeliveryAuthorization;
    }

    @NotNull
    public final Certificate getCargoDeliveryAuthorization() {
        return this.cargoDeliveryAuthorization;
    }

    @Override
    @NotNull
    public byte[] serializePlaintext() {
        DEROctetString cdaASN1 = new DEROctetString(this.cargoDeliveryAuthorization.serialize());
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object)cdaASN1), false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ltech/relaycorp/relaynet/messages/payloads/CargoCollectionRequest$Companion;", "", "<init>", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/payloads/CargoCollectionRequest;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CargoCollectionRequest deserialize(@NotNull byte[] serialization) throws RAMFException {
            Certificate certificate;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                objectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new RAMFException("CCR is not a valid DER sequence", exc);
            }
            Object[] sequence = objectArray;
            if (sequence.length == 0) {
                throw new RAMFException("CCR should have at least one item", null, 2, null);
            }
            ASN1OctetString cdaASN1 = DEROctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)ArraysKt.first((Object[])sequence)), (boolean)false);
            try {
                byte[] byArray = cdaASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
                certificate = Certificate.Companion.deserialize(byArray);
            }
            catch (CertificateException exc) {
                throw new RAMFException("CDA contained in CCR is invalid", exc);
            }
            Certificate cda = certificate;
            return new CargoCollectionRequest(cda);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

