/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.PublicKey;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.SessionKeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ltech/relaycorp/relaynet/SessionKey;", "", "keyId", "", "publicKey", "Ljava/security/PublicKey;", "<init>", "([BLjava/security/PublicKey;)V", "getKeyId", "()[B", "getPublicKey", "()Ljava/security/PublicKey;", "equals", "", "other", "hashCode", "", "encode", "Lorg/bouncycastle/asn1/DERSequence;", "encode$awala", "component1", "component2", "copy", "toString", "", "Companion", "awala"})
public final class SessionKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] keyId;
    @NotNull
    private final PublicKey publicKey;

    public SessionKey(@NotNull byte[] keyId, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.keyId = keyId;
        this.publicKey = publicKey;
    }

    @NotNull
    public final byte[] getKeyId() {
        return this.keyId;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof SessionKey)) {
            return false;
        }
        if (!Arrays.equals(this.keyId, ((SessionKey)other).keyId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.publicKey, (Object)((SessionKey)other).publicKey);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keyId);
        result = 31 * result + this.publicKey.hashCode();
        return result;
    }

    @NotNull
    public final DERSequence encode$awala() {
        Object[] objectArray = new ASN1Object[]{new DEROctetString(this.keyId), SubjectPublicKeyInfo.getInstance((Object)this.publicKey.getEncoded())};
        return ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @NotNull
    public final byte[] component1() {
        return this.keyId;
    }

    @NotNull
    public final PublicKey component2() {
        return this.publicKey;
    }

    @NotNull
    public final SessionKey copy(@NotNull byte[] keyId, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return new SessionKey(keyId, publicKey);
    }

    public static /* synthetic */ SessionKey copy$default(SessionKey sessionKey, byte[] byArray, PublicKey publicKey, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = sessionKey.keyId;
        }
        if ((n & 2) != 0) {
            publicKey = sessionKey.publicKey;
        }
        return sessionKey.copy(byArray, publicKey);
    }

    @NotNull
    public String toString() {
        return "SessionKey(keyId=" + Arrays.toString(this.keyId) + ", publicKey=" + this.publicKey + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/SessionKey$Companion;", "", "<init>", "()V", "decode", "Ltech/relaycorp/relaynet/SessionKey;", "encoding", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "decodePublicKey", "Ljava/security/PublicKey;", "sequence", "Lorg/bouncycastle/asn1/ASN1Sequence;", "decodeKeyId", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionKey decode(@NotNull ASN1TaggedObject encoding) throws SessionKeyException {
            ASN1Sequence aSN1Sequence;
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            try {
                aSN1Sequence = DERSequence.getInstance((ASN1TaggedObject)encoding, (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new SessionKeyException("Session key should be an implicitly-tagged SEQUENCE", exc);
            }
            ASN1Sequence sequence = aSN1Sequence;
            if (sequence.size() != 2) {
                throw new SessionKeyException("Session key should have at least two items", null, 2, null);
            }
            Intrinsics.checkNotNull((Object)sequence);
            byte[] keyId = this.decodeKeyId(sequence);
            PublicKey publicKey = this.decodePublicKey(sequence);
            return new SessionKey(keyId, publicKey);
        }

        private final PublicKey decodePublicKey(ASN1Sequence sequence) {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            ASN1Encodable publicKeyAsn1 = sequence.getObjectAt(1);
            if (!(publicKeyAsn1 instanceof ASN1TaggedObject)) {
                throw new SessionKeyException("Public key should be implicitly tagged", null, 2, null);
            }
            try {
                subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((ASN1TaggedObject)((ASN1TaggedObject)publicKeyAsn1), (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new SessionKeyException("Public key should be a SubjectPublicKeyInfo", exc);
            }
            SubjectPublicKeyInfo publicKeySki = subjectPublicKeyInfo;
            byte[] byArray = publicKeySki.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            return Keys.deserializeECPublicKey(byArray);
        }

        private final byte[] decodeKeyId(ASN1Sequence sequence) {
            byte[] byArray;
            ASN1Encodable keyIdAsn1 = sequence.getObjectAt(0);
            if (!(keyIdAsn1 instanceof ASN1TaggedObject)) {
                throw new SessionKeyException("Session key id should be implicitly tagged", null, 2, null);
            }
            try {
                byArray = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)keyIdAsn1).getOctets();
            }
            catch (IllegalStateException exc) {
                throw new SessionKeyException("Session key id should be an OCTET STRING", exc);
            }
            byte[] keyId = byArray;
            Intrinsics.checkNotNull((Object)keyId);
            return keyId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

