/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.wrappers.DNS;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ltech/relaycorp/relaynet/messages/Recipient;", "", "id", "", "internetAddress", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getInternetAddress", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "serialize", "Lorg/bouncycastle/asn1/ASN1Sequence;", "serialize$awala", "toString", "Companion", "awala"})
public final class Recipient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @Nullable
    private final String internetAddress;
    private static final int ADDRESS_MAX_LENGTH = 1024;
    @NotNull
    private static final Regex idRegex = new Regex("^0[a-f0-9]+$");

    public Recipient(@NotNull String id, @Nullable String internetAddress) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.internetAddress = internetAddress;
    }

    public /* synthetic */ Recipient(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getInternetAddress() {
        return this.internetAddress;
    }

    @NotNull
    public final ASN1Sequence serialize$awala() {
        DERVisibleString idEncoded = new DERVisibleString(this.id);
        List additionalFields = this.internetAddress != null ? CollectionsKt.listOf((Object)new DERVisibleString(this.internetAddress)) : CollectionsKt.emptyList();
        return (ASN1Sequence)ASN1Utils.INSTANCE.makeSequence(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)idEncoded), (Iterable)additionalFields), false);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.internetAddress;
    }

    @NotNull
    public final Recipient copy(@NotNull String id, @Nullable String internetAddress) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new Recipient(id, internetAddress);
    }

    public static /* synthetic */ Recipient copy$default(Recipient recipient, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = recipient.id;
        }
        if ((n & 2) != 0) {
            string2 = recipient.internetAddress;
        }
        return recipient.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Recipient(id=" + this.id + ", internetAddress=" + this.internetAddress + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + (this.internetAddress == null ? 0 : this.internetAddress.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Recipient)) {
            return false;
        }
        Recipient recipient = (Recipient)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)recipient.id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.internetAddress, (Object)recipient.internetAddress);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/relaycorp/relaynet/messages/Recipient$Companion;", "", "()V", "ADDRESS_MAX_LENGTH", "", "idRegex", "Lkotlin/text/Regex;", "deserialize", "Ltech/relaycorp/relaynet/messages/Recipient;", "sequence", "Lorg/bouncycastle/asn1/ASN1Sequence;", "deserialize$awala", "serialization", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "deserializeId", "", "idRaw", "Lorg/bouncycastle/asn1/ASN1Encodable;", "deserializeInternetAddress", "internetAddressRaw", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Recipient deserialize$awala(@NotNull ASN1Sequence sequence) throws RAMFException {
            String string;
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            if (sequence.size() == 0) {
                throw new RAMFException("Recipient SEQUENCE is empty", null, 2, null);
            }
            Object object = CollectionsKt.first((Iterable)((Iterable)sequence));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            String id = this.deserializeId((ASN1Encodable)object);
            if (1 < sequence.size()) {
                ASN1Encodable aSN1Encodable = sequence.getObjectAt(1);
                Intrinsics.checkNotNullExpressionValue((Object)aSN1Encodable, (String)"getObjectAt(...)");
                string = this.deserializeInternetAddress(aSN1Encodable);
            } else {
                string = null;
            }
            String internetAddress = string;
            return new Recipient(id, internetAddress);
        }

        @NotNull
        public final Recipient deserialize$awala(@NotNull ASN1TaggedObject serialization) throws RAMFException {
            ASN1Sequence aSN1Sequence;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1Sequence = DERSequence.getInstance((ASN1TaggedObject)serialization, (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new RAMFException("Recipient is not an implicitly-tagged SEQUENCE", exc);
            }
            ASN1Sequence sequence = aSN1Sequence;
            Intrinsics.checkNotNull((Object)sequence);
            return this.deserialize$awala(sequence);
        }

        private final String deserializeId(ASN1Encodable idRaw) throws RAMFException {
            ASN1TaggedObject idEncoded = ASN1TaggedObject.getInstance((Object)idRaw);
            Intrinsics.checkNotNull((Object)idEncoded);
            ASN1VisibleString idString = ASN1Utils.INSTANCE.getVisibleString(idEncoded);
            String id = idString.getString();
            int length = id.length();
            if (1024 < length) {
                throw new RAMFException("Recipient id should not span more than 1024 characters (got " + length + ")", null, 2, null);
            }
            Regex regex = idRegex;
            Intrinsics.checkNotNull((Object)id);
            if (!regex.matches((CharSequence)id)) {
                throw new RAMFException("Recipient id is malformed (" + id + ")", null, 2, null);
            }
            return id;
        }

        private final String deserializeInternetAddress(ASN1Encodable internetAddressRaw) throws RAMFException {
            ASN1TaggedObject addressEncoded = ASN1TaggedObject.getInstance((Object)internetAddressRaw);
            Intrinsics.checkNotNull((Object)addressEncoded);
            ASN1VisibleString addressString = ASN1Utils.INSTANCE.getVisibleString(addressEncoded);
            String address = addressString.getString();
            int length = address.length();
            if (1024 < length) {
                throw new RAMFException("Internet address should not span more than 1024 characters (got " + length + ")", null, 2, null);
            }
            Intrinsics.checkNotNull((Object)address);
            if (!DNS.INSTANCE.isValidDomainName(address)) {
                throw new RAMFException("Internet address is malformed (" + address + ")", null, 2, null);
            }
            return address;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

