/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.crypto;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Ltech/relaycorp/relaynet/crypto/RSASigning;", "", "()V", "makeSignature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "sign", "", "plaintext", "privateKey", "Ljava/security/PrivateKey;", "verify", "", "ciphertext", "publicKey", "Ljava/security/PublicKey;", "expectedPlaintext", "awala"})
public final class RSASigning {
    @NotNull
    public static final RSASigning INSTANCE = new RSASigning();

    private RSASigning() {
    }

    @NotNull
    public final byte[] sign(@NotNull byte[] plaintext2, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Signature signature = this.makeSignature();
        signature.initSign(privateKey);
        signature.update(plaintext2);
        byte[] byArray = signature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public final boolean verify(@NotNull byte[] ciphertext, @NotNull PublicKey publicKey, @NotNull byte[] expectedPlaintext) {
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)expectedPlaintext, (String)"expectedPlaintext");
        Signature signature = this.makeSignature();
        signature.initVerify(publicKey);
        signature.update(expectedPlaintext);
        return signature.verify(ciphertext);
    }

    private final Signature makeSignature() {
        return Signature.getInstance("SHA256withRSAandMGF1", (Provider)CryptoUtils.getBC_PROVIDER());
    }
}

