/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.InvalidNodeConnectionParams;
import tech.relaycorp.relaynet.SessionKey;
import tech.relaycorp.relaynet.SessionKeyException;
import tech.relaycorp.relaynet.pki.CertificationPath;
import tech.relaycorp.relaynet.pki.CertificationPathException;
import tech.relaycorp.relaynet.wrappers.DNS;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Ltech/relaycorp/relaynet/PrivateEndpointConnParams;", "", "identityKey", "Ljava/security/PublicKey;", "internetGatewayAddress", "", "deliveryAuth", "Ltech/relaycorp/relaynet/pki/CertificationPath;", "sessionKey", "Ltech/relaycorp/relaynet/SessionKey;", "(Ljava/security/PublicKey;Ljava/lang/String;Ltech/relaycorp/relaynet/pki/CertificationPath;Ltech/relaycorp/relaynet/SessionKey;)V", "getDeliveryAuth", "()Ltech/relaycorp/relaynet/pki/CertificationPath;", "getIdentityKey", "()Ljava/security/PublicKey;", "getInternetGatewayAddress", "()Ljava/lang/String;", "getSessionKey", "()Ltech/relaycorp/relaynet/SessionKey;", "serialize", "", "Companion", "awala"})
public final class PrivateEndpointConnParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicKey identityKey;
    @NotNull
    private final String internetGatewayAddress;
    @NotNull
    private final CertificationPath deliveryAuth;
    @NotNull
    private final SessionKey sessionKey;

    public PrivateEndpointConnParams(@NotNull PublicKey identityKey, @NotNull String internetGatewayAddress, @NotNull CertificationPath deliveryAuth, @NotNull SessionKey sessionKey) {
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        Intrinsics.checkNotNullParameter((Object)internetGatewayAddress, (String)"internetGatewayAddress");
        Intrinsics.checkNotNullParameter((Object)deliveryAuth, (String)"deliveryAuth");
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        this.identityKey = identityKey;
        this.internetGatewayAddress = internetGatewayAddress;
        this.deliveryAuth = deliveryAuth;
        this.sessionKey = sessionKey;
    }

    @NotNull
    public final PublicKey getIdentityKey() {
        return this.identityKey;
    }

    @NotNull
    public final String getInternetGatewayAddress() {
        return this.internetGatewayAddress;
    }

    @NotNull
    public final CertificationPath getDeliveryAuth() {
        return this.deliveryAuth;
    }

    @NotNull
    public final SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @NotNull
    public final byte[] serialize() {
        Object[] objectArray = new ASN1Object[]{SubjectPublicKeyInfo.getInstance((Object)this.identityKey.getEncoded()), new DERVisibleString(this.internetGatewayAddress), this.deliveryAuth.encode$awala(), this.sessionKey.encode$awala()};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/PrivateEndpointConnParams$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/PrivateEndpointConnParams;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateEndpointConnParams deserialize(@NotNull byte[] serialization) throws InvalidNodeConnectionParams {
            SessionKey sessionKey;
            CertificationPath certificationPath;
            SubjectPublicKeyInfo exc2;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc2) {
                throw new InvalidNodeConnectionParams("Serialization is not a DER sequence", exc2);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 4) {
                throw new InvalidNodeConnectionParams("Connection params should have at least 4 items", null, 2, null);
            }
            try {
                exc2 = SubjectPublicKeyInfo.getInstance((ASN1TaggedObject)sequence[0], (boolean)false);
            }
            catch (IllegalStateException exc3) {
                throw new InvalidNodeConnectionParams("Invalid identity key", exc3);
            }
            SubjectPublicKeyInfo identityKeyInfo = exc2;
            byte[] byArray = identityKeyInfo.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            PublicKey identityKey = Keys.deserializeRSAPublicKey(byArray);
            String internetGatewayAddress = ASN1Utils.INSTANCE.getVisibleString(sequence[1]).getString();
            Intrinsics.checkNotNull((Object)internetGatewayAddress);
            if (!DNS.INSTANCE.isValidDomainName(internetGatewayAddress)) {
                throw new InvalidNodeConnectionParams("Internet address is syntactically invalid (" + internetGatewayAddress + ')', null, 2, null);
            }
            try {
                certificationPath = CertificationPath.Companion.decode$awala(sequence[2]);
            }
            catch (CertificationPathException exc4) {
                throw new InvalidNodeConnectionParams("Invalid delivery auth", exc4);
            }
            CertificationPath deliveryAuth = certificationPath;
            try {
                sessionKey = SessionKey.Companion.decode(sequence[3]);
            }
            catch (SessionKeyException exc5) {
                throw new InvalidNodeConnectionParams("Invalid session key", exc5);
            }
            SessionKey sessionKey2 = sessionKey;
            return new PrivateEndpointConnParams(identityKey, internetGatewayAddress, deliveryAuth, sessionKey2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

