/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.SessionKey;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.KeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0010"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration;", "", "privateNodeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "gatewayCertificate", "gatewaySessionKey", "Ltech/relaycorp/relaynet/SessionKey;", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ltech/relaycorp/relaynet/SessionKey;)V", "getGatewayCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getGatewaySessionKey", "()Ltech/relaycorp/relaynet/SessionKey;", "getPrivateNodeCertificate", "serialize", "", "Companion", "awala"})
public final class PrivateNodeRegistration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Certificate privateNodeCertificate;
    @NotNull
    private final Certificate gatewayCertificate;
    @Nullable
    private final SessionKey gatewaySessionKey;

    public PrivateNodeRegistration(@NotNull Certificate privateNodeCertificate, @NotNull Certificate gatewayCertificate, @Nullable SessionKey gatewaySessionKey) {
        Intrinsics.checkNotNullParameter((Object)privateNodeCertificate, (String)"privateNodeCertificate");
        Intrinsics.checkNotNullParameter((Object)gatewayCertificate, (String)"gatewayCertificate");
        this.privateNodeCertificate = privateNodeCertificate;
        this.gatewayCertificate = gatewayCertificate;
        this.gatewaySessionKey = gatewaySessionKey;
    }

    public /* synthetic */ PrivateNodeRegistration(Certificate certificate, Certificate certificate2, SessionKey sessionKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            sessionKey = null;
        }
        this(certificate, certificate2, sessionKey);
    }

    @NotNull
    public final Certificate getPrivateNodeCertificate() {
        return this.privateNodeCertificate;
    }

    @NotNull
    public final Certificate getGatewayCertificate() {
        return this.gatewayCertificate;
    }

    @Nullable
    public final SessionKey getGatewaySessionKey() {
        return this.gatewaySessionKey;
    }

    @NotNull
    public final byte[] serialize() {
        DERSequence dERSequence;
        DEROctetString nodeCertificateASN1 = new DEROctetString(this.privateNodeCertificate.serialize());
        DEROctetString gatewayCertificateASN1 = new DEROctetString(this.gatewayCertificate.serialize());
        if (this.gatewaySessionKey != null) {
            Object[] objectArray = new DEROctetString[]{new DEROctetString(this.gatewaySessionKey.getKeyId()), new DEROctetString(this.gatewaySessionKey.getPublicKey().getEncoded())};
            dERSequence = ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
        } else {
            dERSequence = null;
        }
        DERSequence gatewaySessionKeyASN1 = dERSequence;
        Object[] objectArray = new DEROctetString[]{nodeCertificateASN1, gatewayCertificateASN1};
        List rootSequence = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)CollectionsKt.listOfNotNull((Object)gatewaySessionKeyASN1));
        return ASN1Utils.INSTANCE.serializeSequence(rootSequence, false);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/PrivateNodeRegistration;", "serialization", "", "deserializeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "asn1Object", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "getSessionKeyFromSequence", "Ltech/relaycorp/relaynet/SessionKey;", "sessionKeyASN1", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrivateNodeRegistration deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            Certificate exc3;
            Certificate exc22;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc22) {
                throw new InvalidMessageException("Node registration is not a DER sequence", exc22);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 2) {
                throw new InvalidMessageException("Node registration sequence should have at least two items (got " + sequence.length + ')', null, 2, null);
            }
            try {
                exc22 = this.deserializeCertificate(sequence[0]);
            }
            catch (CertificateException exc3) {
                throw new InvalidMessageException("Node registration contains invalid node certificate", exc3);
            }
            Certificate nodeCertificate = exc22;
            try {
                exc3 = this.deserializeCertificate(sequence[1]);
            }
            catch (CertificateException exc4) {
                throw new InvalidMessageException("Node registration contains invalid gateway certificate", exc4);
            }
            Certificate gatewayCertificate = exc3;
            SessionKey gatewaySessionKey = 3 <= sequence.length ? this.getSessionKeyFromSequence(sequence[2]) : null;
            return new PrivateNodeRegistration(nodeCertificate, gatewayCertificate, gatewaySessionKey);
        }

        private final SessionKey getSessionKeyFromSequence(ASN1TaggedObject sessionKeyASN1) {
            PublicKey publicKey;
            ASN1Sequence sessionKeySequence = DERSequence.getInstance((ASN1TaggedObject)sessionKeyASN1, (boolean)false);
            if (sessionKeySequence.size() < 2) {
                throw new InvalidMessageException("Session key SEQUENCE should have at least 2 items (got " + sessionKeySequence.size() + ')', null, 2, null);
            }
            ASN1Encodable aSN1Encodable = sessionKeySequence.getObjectAt(0);
            if (aSN1Encodable == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            }
            byte[] sessionKeyId = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable).getOctets();
            ASN1Encodable aSN1Encodable2 = sessionKeySequence.getObjectAt(1);
            if (aSN1Encodable2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            }
            ASN1OctetString sessionPublicKeyASN1 = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)aSN1Encodable2);
            try {
                byte[] byArray = sessionPublicKeyASN1.getOctets();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sessionPublicKeyASN1.octets");
                publicKey = Keys.deserializeECPublicKey(byArray);
            }
            catch (KeyException exc) {
                throw new InvalidMessageException("Session key is not a valid ECDH public key", exc);
            }
            PublicKey sessionPublicKey = publicKey;
            Intrinsics.checkNotNullExpressionValue((Object)sessionKeyId, (String)"sessionKeyId");
            return new SessionKey(sessionKeyId, sessionPublicKey);
        }

        private final Certificate deserializeCertificate(ASN1TaggedObject asn1Object) throws CertificateException {
            ASN1OctetString certificateASN1 = ASN1Utils.INSTANCE.getOctetString(asn1Object);
            byte[] byArray = certificateASN1.getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"certificateASN1.octets");
            return Certificate.Companion.deserialize(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

