/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.payloads;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.payloads.EncryptedPayload;
import tech.relaycorp.relaynet.ramf.InvalidPayloadException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/messages/payloads/ServiceMessage;", "Ltech/relaycorp/relaynet/messages/payloads/EncryptedPayload;", "type", "", "content", "", "(Ljava/lang/String;[B)V", "getContent", "()[B", "getType", "()Ljava/lang/String;", "serializePlaintext", "Companion", "awala"})
public final class ServiceMessage
extends EncryptedPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final byte[] content;

    public ServiceMessage(@NotNull String type, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.type = type;
        this.content = content;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final byte[] getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public byte[] serializePlaintext() {
        DERVisibleString typeASN1 = new DERVisibleString(this.type);
        DEROctetString contentASN1 = new DEROctetString(this.content);
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{(ASN1Encodable)typeASN1, (ASN1Encodable)contentASN1};
        return ASN1Utils.INSTANCE.serializeSequence(aSN1EncodableArray, false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/payloads/ServiceMessage$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/payloads/ServiceMessage;", "serialization", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServiceMessage deserialize(@NotNull byte[] serialization) throws InvalidPayloadException {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                objectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new InvalidPayloadException("Service message is not a DER sequence", exc);
            }
            Object[] sequence = objectArray;
            if (sequence.length < 2) {
                throw new InvalidPayloadException("Service message sequence should have at least two items (got " + sequence.length + ')', null, 2, null);
            }
            DERVisibleString type = ASN1Utils.INSTANCE.getVisibleString((ASN1TaggedObject)ArraysKt.first((Object[])sequence));
            ASN1OctetString content = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)sequence[1]);
            Object object = type.getString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"type.string");
            String string = object;
            object = content.getOctets();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"content.octets");
            return new ServiceMessage(string, (byte[])object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

