/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.KeyAgreeRecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.SymmetricEncryption;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataKt;
import tech.relaycorp.relaynet.wrappers.cms.RecipientIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.RecipientKeyIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.RecipientSerialNumber;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData;", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientIdentifier;", "validate", "", "Companion", "awala"})
public final class SessionEnvelopedData
extends EnvelopedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<HashingAlgorithm, ASN1ObjectIdentifier> ecdhAlgorithmByHashingAlgorithm;

    public SessionEnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkNotNullParameter((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        super(bcEnvelopedData);
    }

    @Override
    @NotNull
    public RecipientIdentifier getRecipientKeyId() {
        RecipientIdentifier recipientIdentifier;
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Object object = ((RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore))).getRID();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bouncycastle.cms.KeyAgreeRecipientId");
        }
        KeyAgreeRecipientId rid = (KeyAgreeRecipientId)object;
        if (rid.getSerialNumber() == null) {
            object = rid.getSubjectKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rid.subjectKeyIdentifier");
            recipientIdentifier = new RecipientKeyIdentifier((byte[])object);
        } else {
            object = rid.getSerialNumber();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rid.serialNumber");
            recipientIdentifier = new RecipientSerialNumber((BigInteger)object);
        }
        return recipientIdentifier;
    }

    @Override
    public void validate() {
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)HashingAlgorithm.SHA256), (Object)CMSAlgorithm.ECDH_SHA256KDF), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA384), (Object)CMSAlgorithm.ECDH_SHA384KDF), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA512), (Object)CMSAlgorithm.ECDH_SHA512KDF)};
        ecdhAlgorithmByHashingAlgorithm = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017H\u0002J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0005J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0005J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData$Companion;", "", "()V", "ecdhAlgorithmByHashingAlgorithm", "", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "kotlin.jvm.PlatformType", "getEcdhAlgorithmByHashingAlgorithm", "()Ljava/util/Map;", "encrypt", "Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData;", "plaintext", "", "originatorKeyPair", "Ljava/security/KeyPair;", "symmetricEncryptionAlgorithm", "Ltech/relaycorp/relaynet/SymmetricEncryption;", "hashingAlgorithm", "recipientInfoAppender", "Lkotlin/Function1;", "Lorg/bouncycastle/cms/jcajce/JceKeyAgreeRecipientInfoGenerator;", "", "Lkotlin/ExtensionFunctionType;", "recipientKeyId", "recipientKey", "Ljava/security/PublicKey;", "recipientCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "makeRecipientInfoGenerator", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<HashingAlgorithm, ASN1ObjectIdentifier> getEcdhAlgorithmByHashingAlgorithm() {
            return ecdhAlgorithmByHashingAlgorithm;
        }

        @NotNull
        public final SessionEnvelopedData encrypt(@NotNull byte[] plaintext2, @NotNull Certificate recipientCertificate, @NotNull KeyPair originatorKeyPair, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm, @NotNull HashingAlgorithm hashingAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)recipientCertificate, (String)"recipientCertificate");
            Intrinsics.checkNotNullParameter((Object)originatorKeyPair, (String)"originatorKeyPair");
            Intrinsics.checkNotNullParameter((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
            Intrinsics.checkNotNullParameter((Object)((Object)hashingAlgorithm), (String)"hashingAlgorithm");
            X509Certificate recipientX509Certificate = new JcaX509CertificateConverter().getCertificate(recipientCertificate.getCertificateHolder$awala());
            return this.encrypt(plaintext2, originatorKeyPair, symmetricEncryptionAlgorithm, hashingAlgorithm, (Function1<? super JceKeyAgreeRecipientInfoGenerator, Unit>)((Function1)new Function1<JceKeyAgreeRecipientInfoGenerator, Unit>(recipientX509Certificate){
                final /* synthetic */ X509Certificate $recipientX509Certificate;
                {
                    this.$recipientX509Certificate = $recipientX509Certificate;
                    super(1);
                }

                public final void invoke(@NotNull JceKeyAgreeRecipientInfoGenerator $this$encrypt) {
                    Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"$this$encrypt");
                    $this$encrypt.addRecipient(this.$recipientX509Certificate);
                }
            }));
        }

        public static /* synthetic */ SessionEnvelopedData encrypt$default(Companion companion, byte[] byArray, Certificate certificate, KeyPair keyPair, SymmetricEncryption symmetricEncryption, HashingAlgorithm hashingAlgorithm, int n, Object object) {
            if ((n & 8) != 0) {
                symmetricEncryption = SymmetricEncryption.AES_128;
            }
            if ((n & 0x10) != 0) {
                hashingAlgorithm = HashingAlgorithm.SHA256;
            }
            return companion.encrypt(byArray, certificate, keyPair, symmetricEncryption, hashingAlgorithm);
        }

        @NotNull
        public final SessionEnvelopedData encrypt(@NotNull byte[] plaintext2, @NotNull byte[] recipientKeyId, @NotNull PublicKey recipientKey, @NotNull KeyPair originatorKeyPair, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm, @NotNull HashingAlgorithm hashingAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)recipientKeyId, (String)"recipientKeyId");
            Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
            Intrinsics.checkNotNullParameter((Object)originatorKeyPair, (String)"originatorKeyPair");
            Intrinsics.checkNotNullParameter((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
            Intrinsics.checkNotNullParameter((Object)((Object)hashingAlgorithm), (String)"hashingAlgorithm");
            return this.encrypt(plaintext2, originatorKeyPair, symmetricEncryptionAlgorithm, hashingAlgorithm, (Function1<? super JceKeyAgreeRecipientInfoGenerator, Unit>)((Function1)new Function1<JceKeyAgreeRecipientInfoGenerator, Unit>(recipientKeyId, recipientKey){
                final /* synthetic */ byte[] $recipientKeyId;
                final /* synthetic */ PublicKey $recipientKey;
                {
                    this.$recipientKeyId = $recipientKeyId;
                    this.$recipientKey = $recipientKey;
                    super(1);
                }

                public final void invoke(@NotNull JceKeyAgreeRecipientInfoGenerator $this$encrypt) {
                    Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"$this$encrypt");
                    $this$encrypt.addRecipient(this.$recipientKeyId, this.$recipientKey);
                }
            }));
        }

        public static /* synthetic */ SessionEnvelopedData encrypt$default(Companion companion, byte[] byArray, byte[] byArray2, PublicKey publicKey, KeyPair keyPair, SymmetricEncryption symmetricEncryption, HashingAlgorithm hashingAlgorithm, int n, Object object) {
            if ((n & 0x10) != 0) {
                symmetricEncryption = SymmetricEncryption.AES_128;
            }
            if ((n & 0x20) != 0) {
                hashingAlgorithm = HashingAlgorithm.SHA256;
            }
            return companion.encrypt(byArray, byArray2, publicKey, keyPair, symmetricEncryption, hashingAlgorithm);
        }

        private final SessionEnvelopedData encrypt(byte[] plaintext2, KeyPair originatorKeyPair, SymmetricEncryption symmetricEncryptionAlgorithm, HashingAlgorithm hashingAlgorithm, Function1<? super JceKeyAgreeRecipientInfoGenerator, Unit> recipientInfoAppender) {
            JceKeyAgreeRecipientInfoGenerator recipientInfoGenerator = this.makeRecipientInfoGenerator(originatorKeyPair, symmetricEncryptionAlgorithm, hashingAlgorithm);
            recipientInfoAppender.invoke((Object)recipientInfoGenerator);
            CMSEnvelopedData bcEnvelopedData = EnvelopedDataKt.bcEncrypt(plaintext2, symmetricEncryptionAlgorithm, (RecipientInfoGenerator)recipientInfoGenerator);
            return new SessionEnvelopedData(bcEnvelopedData);
        }

        private final JceKeyAgreeRecipientInfoGenerator makeRecipientInfoGenerator(KeyPair originatorKeyPair, SymmetricEncryption symmetricEncryptionAlgorithm, HashingAlgorithm hashingAlgorithm) {
            ASN1ObjectIdentifier ecdhAlgorithm = this.getEcdhAlgorithmByHashingAlgorithm().get((Object)hashingAlgorithm);
            ASN1ObjectIdentifier keyWrapCipher = EnvelopedDataKt.getKEY_WRAP_ALGORITHMS().get((Object)symmetricEncryptionAlgorithm);
            JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(ecdhAlgorithm, originatorKeyPair.getPrivate(), originatorKeyPair.getPublic(), keyWrapCipher).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            Intrinsics.checkNotNullExpressionValue((Object)jceKeyAgreeRecipientInfoGenerator, (String)"JceKeyAgreeRecipientInfoGenerator(\n                ecdhAlgorithm,\n                originatorKeyPair.private,\n                originatorKeyPair.public,\n                keyWrapCipher\n            ).setProvider(BC_PROVIDER)");
            return jceKeyAgreeRecipientInfoGenerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

