/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.testing.keystores;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.keystores.KeyStoreBackendException;
import tech.relaycorp.relaynet.keystores.PrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nH\u0094@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nJ\u0018\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0094@\u00a2\u0006\u0002\u0010\u001cJ0\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\tH\u0094@\u00a2\u0006\u0002\u0010!J(\u0010\"\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000eJ(\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010&\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010'R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR5\u0010\r\u001a&\u0012\u0004\u0012\u00020\t\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\b0\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006("}, d2={"Ltech/relaycorp/relaynet/testing/keystores/MockPrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "savingException", "", "retrievalException", "<init>", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)V", "identityKeys", "", "", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "getIdentityKeys", "()Ljava/util/Map;", "sessionKeys", "", "getSessionKeys", "clear", "", "saveIdentityKeyData", "nodeId", "keyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/PrivateKeyData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setIdentityKey", "privateAddress", "retrieveIdentityKeyData", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveAllIdentityKeyData", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveSessionKeySerialized", "keyId", "keySerialized", "peerId", "(Ljava/lang/String;[BLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setSessionKey", "retrieveSessionKeySerialized", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteKeys", "deleteBoundSessionKeys", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awala-testing"})
public final class MockPrivateKeyStore
extends PrivateKeyStore {
    @Nullable
    private final Throwable savingException;
    @Nullable
    private final Throwable retrievalException;
    @NotNull
    private final Map<String, PrivateKeyData> identityKeys;
    @NotNull
    private final Map<String, Map<String, Map<String, byte[]>>> sessionKeys;

    public MockPrivateKeyStore(@Nullable Throwable savingException, @Nullable Throwable retrievalException) {
        this.savingException = savingException;
        this.retrievalException = retrievalException;
        this.identityKeys = new LinkedHashMap();
        this.sessionKeys = new LinkedHashMap();
    }

    public /* synthetic */ MockPrivateKeyStore(Throwable throwable, Throwable throwable2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        if ((n & 2) != 0) {
            throwable2 = null;
        }
        this(throwable, throwable2);
    }

    @NotNull
    public final Map<String, PrivateKeyData> getIdentityKeys() {
        return this.identityKeys;
    }

    @NotNull
    public final Map<String, Map<String, Map<String, byte[]>>> getSessionKeys() {
        return this.sessionKeys;
    }

    public final void clear() {
        this.identityKeys.clear();
        this.sessionKeys.clear();
    }

    @Nullable
    protected Object saveIdentityKeyData(@NotNull String nodeId, @NotNull PrivateKeyData keyData, @NotNull Continuation<? super Unit> $completion) {
        if (this.savingException != null) {
            throw new KeyStoreBackendException("Saving identity keys isn't supported", this.savingException);
        }
        this.setIdentityKey(nodeId, keyData);
        return Unit.INSTANCE;
    }

    public final void setIdentityKey(@NotNull String privateAddress, @NotNull PrivateKeyData keyData) {
        Intrinsics.checkNotNullParameter((Object)privateAddress, (String)"privateAddress");
        Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
        this.identityKeys.put(privateAddress, keyData);
    }

    @Nullable
    protected Object retrieveIdentityKeyData(@NotNull String nodeId, @NotNull Continuation<? super PrivateKeyData> $completion) {
        if (this.retrievalException != null) {
            throw new KeyStoreBackendException("Retrieving identity keys isn't supported", this.retrievalException);
        }
        return this.identityKeys.get(nodeId);
    }

    @Nullable
    protected Object retrieveAllIdentityKeyData(@NotNull Continuation<? super List<? extends PrivateKeyData>> $completion) {
        return CollectionsKt.toList((Iterable)this.identityKeys.values());
    }

    @Nullable
    protected Object saveSessionKeySerialized(@NotNull String keyId, @NotNull byte[] keySerialized, @NotNull String nodeId, @Nullable String peerId, @NotNull Continuation<? super Unit> $completion) {
        if (this.savingException != null) {
            throw new KeyStoreBackendException("Saving session keys isn't supported", this.savingException);
        }
        this.setSessionKey(nodeId, peerId, keyId, keySerialized);
        return Unit.INSTANCE;
    }

    public final void setSessionKey(@NotNull String privateAddress, @Nullable String peerId, @NotNull String keyId, @NotNull byte[] keySerialized) {
        Intrinsics.checkNotNullParameter((Object)privateAddress, (String)"privateAddress");
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)keySerialized, (String)"keySerialized");
        this.sessionKeys.putIfAbsent(privateAddress, new LinkedHashMap());
        String string = peerId;
        if (string == null) {
            string = "unbound";
        }
        String peerKey = string;
        Map<String, Map<String, byte[]>> map = this.sessionKeys.get(privateAddress);
        Intrinsics.checkNotNull(map);
        map.putIfAbsent(peerKey, new LinkedHashMap());
        Map<String, Map<String, byte[]>> map2 = this.sessionKeys.get(privateAddress);
        Intrinsics.checkNotNull(map2);
        Map<String, byte[]> map3 = map2.get(peerKey);
        Intrinsics.checkNotNull(map3);
        map3.put(keyId, keySerialized);
    }

    @Nullable
    protected Object retrieveSessionKeySerialized(@NotNull String keyId, @NotNull String nodeId, @NotNull String peerId, @NotNull Continuation<? super byte[]> $completion) {
        Map<String, Map<String, byte[]>> map;
        block5: {
            Map<String, Map<String, byte[]>> map2;
            block4: {
                if (this.retrievalException != null) {
                    throw new KeyStoreBackendException("Retrieving session keys isn't supported", this.savingException);
                }
                map = this.sessionKeys.get(nodeId);
                if (map == null || (map = map.get(peerId)) == null) break block4;
                byte[] byArray = (byte[])map.get(keyId);
                map = (Map<String, Map<String, byte[]>>)byArray;
                if (byArray != null) break block5;
            }
            map = (map2 = this.sessionKeys.get(nodeId)) != null && (map2 = map2.get("unbound")) != null ? (Map<String, Map<String, byte[]>>)((byte[])map2.get(keyId)) : null;
        }
        return map;
    }

    @Nullable
    public Object deleteKeys(@NotNull String nodeId, @NotNull Continuation<? super Unit> $completion) {
        this.identityKeys.remove(nodeId);
        this.sessionKeys.remove(nodeId);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object deleteBoundSessionKeys(@NotNull String nodeId, @NotNull String peerId, @NotNull Continuation<? super Unit> $completion) {
        block0: {
            Map<String, Map<String, byte[]>> map = this.sessionKeys.get(nodeId);
            if (map == null) break block0;
            map.remove(peerId);
        }
        return Unit.INSTANCE;
    }

    public MockPrivateKeyStore() {
        this(null, null, 3, null);
    }
}

