/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.PrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0012\u001a\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H$J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0006H$J\"\u0010\u001b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0006H\u0002J+\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\"H\u0002J3\u0010+\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u0017\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getRootDirectory$annotations", "()V", "getRootDirectory", "()Ljava/io/File;", "deleteKeys", "", "nodeId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteSessionKeysForPeer", "peerId", "getNodeDirectories", "", "kotlin.jvm.PlatformType", "getNodeSubdirectory", "makeEncryptedInputStream", "Ljava/io/InputStream;", "file", "makeEncryptedOutputStream", "Ljava/io/OutputStream;", "resolveSessionKeyFile", "keyId", "retrieveAllIdentityKeyData", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveIdentityKeyData", "retrieveKeyData", "", "keyFile", "retrieveSessionKeySerialized", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveIdentityKeyData", "keyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/PrivateKeyData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveKeyFile", "serialization", "saveSessionKeySerialized", "keySerialized", "(Ljava/lang/String;[BLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awala-keystore-file"})
@SourceDebugExtension(value={"SMAP\nFilePrivateKeyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePrivateKeyStore.kt\ntech/relaycorp/awala/keystores/file/FilePrivateKeyStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,130:1\n1#2:131\n1#2:146\n1549#3:132\n1620#3,3:133\n1603#3,9:136\n1855#3:145\n1856#3:147\n1612#3:148\n1549#3:152\n1620#3,3:153\n766#3:156\n857#3,2:157\n1549#3:159\n1620#3,3:160\n1726#3,3:163\n3792#4:149\n4307#4,2:150\n*S KotlinDebug\n*F\n+ 1 FilePrivateKeyStore.kt\ntech/relaycorp/awala/keystores/file/FilePrivateKeyStore\n*L\n31#1:146\n30#1:132\n30#1:133,3\n31#1:136,9\n31#1:145\n31#1:147\n31#1:148\n121#1:152\n121#1:153,3\n122#1:156\n122#1:157,2\n123#1:159\n123#1:160,3\n124#1:163,3\n98#1:149\n98#1:150,2\n*E\n"})
public abstract class FilePrivateKeyStore
extends PrivateKeyStore {
    @NotNull
    private final File rootDirectory;

    public FilePrivateKeyStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"private");
    }

    @NotNull
    public final File getRootDirectory() {
        return this.rootDirectory;
    }

    public static /* synthetic */ void getRootDirectory$annotations() {
    }

    @Nullable
    protected Object saveIdentityKeyData(@NotNull String nodeId, @NotNull PrivateKeyData keyData, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveIdentityKeyData$suspendImpl(this, nodeId, keyData, $completion);
    }

    static /* synthetic */ Object saveIdentityKeyData$suspendImpl(FilePrivateKeyStore $this, String nodeId, PrivateKeyData keyData, Continuation<? super Unit> $completion) {
        File keyFile = FilesKt.resolve((File)$this.getNodeSubdirectory(nodeId), (String)"identity");
        $this.saveKeyFile(keyFile, keyData.getPrivateKeyDer());
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveIdentityKeyData(@NotNull String nodeId, @NotNull Continuation<? super PrivateKeyData> $completion) {
        return FilePrivateKeyStore.retrieveIdentityKeyData$suspendImpl(this, nodeId, $completion);
    }

    static /* synthetic */ Object retrieveIdentityKeyData$suspendImpl(FilePrivateKeyStore $this, String nodeId, Continuation<? super PrivateKeyData> $completion) {
        PrivateKeyData privateKeyData;
        File keyFile = FilesKt.resolve((File)$this.getNodeSubdirectory(nodeId), (String)"identity");
        byte[] byArray = $this.retrieveKeyData(keyFile);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            privateKeyData = new PrivateKeyData(it);
        } else {
            privateKeyData = null;
        }
        return privateKeyData;
    }

    @Nullable
    protected Object retrieveAllIdentityKeyData(@NotNull Continuation<? super List<? extends PrivateKeyData>> $completion) {
        return FilePrivateKeyStore.retrieveAllIdentityKeyData$suspendImpl(this, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object retrieveAllIdentityKeyData$suspendImpl(FilePrivateKeyStore $this, Continuation<? super List<? extends PrivateKeyData>> $completion) {
        List list;
        List<File> list2 = $this.getNodeDirectories();
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(FilesKt.resolve((File)it, (String)"identity"));
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PrivateKeyData privateKeyData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File path = (File)element$iv$iv;
                boolean bl2 = false;
                if ($this.retrieveKeyData(path) != null) {
                    byte[] it;
                    boolean bl3 = false;
                    privateKeyData = new PrivateKeyData(it);
                } else {
                    privateKeyData = null;
                }
                if (privateKeyData == null) continue;
                PrivateKeyData it$iv$iv = privateKeyData;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    protected Object saveSessionKeySerialized(@NotNull String keyId, @NotNull byte[] keySerialized, @NotNull String nodeId, @Nullable String peerId, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveSessionKeySerialized$suspendImpl(this, keyId, keySerialized, nodeId, peerId, $completion);
    }

    static /* synthetic */ Object saveSessionKeySerialized$suspendImpl(FilePrivateKeyStore $this, String keyId, byte[] keySerialized, String nodeId, String peerId, Continuation<? super Unit> $completion) {
        File keyFile = $this.resolveSessionKeyFile(nodeId, keyId, peerId);
        $this.saveKeyFile(keyFile, keySerialized);
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveSessionKeySerialized(@NotNull String keyId, @NotNull String nodeId, @NotNull String peerId, @NotNull Continuation<? super byte[]> $completion) {
        return FilePrivateKeyStore.retrieveSessionKeySerialized$suspendImpl(this, keyId, nodeId, peerId, $completion);
    }

    static /* synthetic */ Object retrieveSessionKeySerialized$suspendImpl(FilePrivateKeyStore $this, String keyId, String nodeId, String peerId, Continuation<? super byte[]> $completion) {
        File boundKeyPath = $this.resolveSessionKeyFile(nodeId, keyId, peerId);
        File unboundKeyPath = $this.resolveSessionKeyFile(nodeId, keyId, null);
        byte[] byArray = $this.retrieveKeyData(boundKeyPath);
        if (byArray == null) {
            byArray = $this.retrieveKeyData(unboundKeyPath);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveKeyFile(File keyFile, byte[] serialization) {
        File parentDirectory = keyFile.getParentFile();
        boolean wereDirectoriesCreated = parentDirectory.mkdirs();
        if (!wereDirectoriesCreated && !parentDirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for private keys", null, 2, null);
        }
        try {
            Closeable closeable = this.makeEncryptedOutputStream(keyFile);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                it.write(serialization);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key file", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] retrieveKeyData(File keyFile) {
        Object object;
        try {
            byte[] byArray;
            object = this.makeEncryptedInputStream(keyFile);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            if (keyFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        return object;
    }

    private final File resolveSessionKeyFile(String nodeId, String keyId, String peerId) {
        File nodeSubdirectory = FilesKt.resolve((File)this.getNodeSubdirectory(nodeId), (String)"session");
        File parentDirectory = peerId != null ? FilesKt.resolve((File)nodeSubdirectory, (String)peerId) : nodeSubdirectory;
        return FilesKt.resolve((File)parentDirectory, (String)keyId);
    }

    private final File getNodeSubdirectory(String nodeId) {
        return FilesKt.resolve((File)this.rootDirectory, (String)nodeId);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getNodeDirectories() {
        List list;
        File[] fileArray = this.rootDirectory.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void p0 = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    protected abstract OutputStream makeEncryptedOutputStream(@NotNull File var1);

    @NotNull
    protected abstract InputStream makeEncryptedInputStream(@NotNull File var1);

    @Nullable
    public Object deleteKeys(@NotNull String nodeId, @NotNull Continuation<? super Unit> $completion) throws FileKeystoreException {
        return FilePrivateKeyStore.deleteKeys$suspendImpl(this, nodeId, $completion);
    }

    static /* synthetic */ Object deleteKeys$suspendImpl(FilePrivateKeyStore $this, String nodeId, Continuation<? super Unit> $completion) throws FileKeystoreException {
        boolean deletionSucceeded = FilesKt.deleteRecursively((File)$this.getNodeSubdirectory(nodeId));
        if (!deletionSucceeded) {
            throw new FileKeystoreException("Failed to delete node directory for " + nodeId, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object deleteSessionKeysForPeer(@NotNull String peerId, @NotNull Continuation<? super Unit> $completion) throws FileKeystoreException {
        return FilePrivateKeyStore.deleteSessionKeysForPeer$suspendImpl(this, peerId, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object deleteSessionKeysForPeer$suspendImpl(FilePrivateKeyStore $this, String peerId, Continuation<? super Unit> $completion) throws FileKeystoreException {
        Boolean deletionSucceeded;
        Boolean bl;
        List<File> list = $this.getNodeDirectories();
        if (list != null) {
            boolean bl2;
            block9: {
                void $this$all$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable = list;
                boolean $i$f$map22 = false;
                void var7_7 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(FilesKt.resolve((File)FilesKt.resolve((File)it, (String)"session"), (String)peerId));
                }
                Iterable $i$f$map22 = (List)destination$iv$iv;
                boolean $i$f$filter22 = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File p0 = (File)element$iv$iv;
                    boolean bl4 = false;
                    if (!p0.exists()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                destination$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    File bl4 = (File)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl5 = false;
                    collection.add(Boxing.boxBoolean((boolean)FilesKt.deleteRecursively((File)p0)));
                }
                $this$map$iv = (List)destination$iv$iv3;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl6 = false;
                        if (it) continue;
                        bl2 = false;
                        break block9;
                    }
                    bl2 = true;
                }
            }
            bl = Boxing.boxBoolean((boolean)bl2);
        } else {
            bl = deletionSucceeded = null;
        }
        if (Intrinsics.areEqual(deletionSucceeded, (Object)Boxing.boxBoolean((boolean)false))) {
            throw new FileKeystoreException("Failed to delete all keys for peer " + peerId, null, 2, null);
        }
        return Unit.INSTANCE;
    }
}

