/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileCertificateStoreKt;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.CertificateStore;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\f\u0010 \u001a\u00020!*\u00020\u0011H\u0002J\u0019\u0010\"\u001a\n #*\u0004\u0018\u00010\u00110\u0011*\u00020!H\u0002\u00a2\u0006\u0002\u0010$J\f\u0010%\u001a\u00020\u0011*\u00020\u0007H\u0002J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u0017\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Ltech/relaycorp/awala/keystores/file/FileCertificateStore;", "Ltech/relaycorp/relaynet/keystores/CertificateStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "<init>", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getRootDirectory$annotations", "()V", "getRootDirectory", "()Ljava/io/File;", "saveData", "", "subjectId", "", "leafCertificateExpiryDate", "Ljava/time/ZonedDateTime;", "certificationPathData", "", "issuerId", "(Ljava/lang/String;Ljava/time/ZonedDateTime;[BLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveData", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteExpired", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "delete", "saveCertificationFile", "certFile", "serialization", "file", "toTimestamp", "", "toZonedDateTime", "kotlin.jvm.PlatformType", "(J)Ljava/time/ZonedDateTime;", "getExpiryDateFromName", "getNodeSubdirectory", "awala-keystore-file"})
@SourceDebugExtension(value={"SMAP\nFileCertificateStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileCertificateStore.kt\ntech/relaycorp/awala/keystores/file/FileCertificateStore\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n3829#2:128\n4344#2,2:129\n3829#2:135\n4344#2,2:136\n3829#2:151\n4344#2,2:152\n1557#3:131\n1628#3,3:132\n1368#3:138\n1454#3,2:139\n1456#3,3:142\n774#3:145\n865#3,2:146\n1557#3:148\n1628#3,2:149\n1863#3,2:154\n1630#3:156\n18#4:141\n1#5:157\n*S KotlinDebug\n*F\n+ 1 FileCertificateStore.kt\ntech/relaycorp/awala/keystores/file/FileCertificateStore\n*L\n43#1:128\n43#1:129,2\n50#1:135\n50#1:136,2\n56#1:151\n56#1:152,2\n44#1:131\n44#1:132,3\n51#1:138\n51#1:139,2\n51#1:142,3\n52#1:145\n52#1:146,2\n53#1:148\n53#1:149,2\n57#1:154,2\n53#1:156\n51#1:141\n*E\n"})
public final class FileCertificateStore
extends CertificateStore {
    @NotNull
    private final File rootDirectory;

    public FileCertificateStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"certificate");
    }

    @NotNull
    public final File getRootDirectory() {
        return this.rootDirectory;
    }

    public static /* synthetic */ void getRootDirectory$annotations() {
    }

    @Nullable
    protected Object saveData(@NotNull String subjectId, @NotNull ZonedDateTime leafCertificateExpiryDate, @NotNull byte[] certificationPathData, @NotNull String issuerId, @NotNull Continuation<? super Unit> $completion) {
        long expirationTimestamp = this.toTimestamp(leafCertificateExpiryDate);
        String dataDigest = FileCertificateStoreKt.toDigest(certificationPathData);
        File certFile = FilesKt.resolve((File)this.getNodeSubdirectory(subjectId, issuerId), (String)("" + expirationTimestamp + '-' + dataDigest));
        this.saveCertificationFile(certFile, certificationPathData);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object retrieveData(@NotNull String subjectId, @NotNull String issuerId, @NotNull Continuation<? super List<byte[]>> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        File[] certificateFiles;
        File[] fileArray = this.getNodeSubdirectory(subjectId, issuerId).listFiles();
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] fileArray2 = certificateFiles = fileArray;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.getExpiryDateFromName((File)it).isAfter(ZonedDateTime.now())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File element$iv$iv;
            element$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.retrieveData((File)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object deleteExpired(@NotNull Continuation<? super Unit> $completion) {
        block9: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterTo$iv$iv2;
            File[] fileArray = this.rootDirectory.listFiles();
            if (fileArray == null) break block9;
            File[] $this$filter$iv2 = fileArray;
            boolean $i$f$filter22 = false;
            File[] fileArray2 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                void p0 = element$iv$iv;
                boolean $i$f$deleteExpired$stub_for_inlining = false;
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$flatMap22 = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                Object[] $this$orEmpty$iv = it.listFiles();
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    objectArray = new File[]{};
                }
                Iterable list$iv$iv = ArraysKt.toList((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable $i$f$flatMap22 = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File p0 = (File)element$iv$iv;
                boolean $i$f$deleteExpired$stub_for_inlining$3 = false;
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Unit unit;
                void addressFile;
                File p0 = (File)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                File[] fileArray3 = addressFile.listFiles();
                if (fileArray3 != null) {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv3;
                    Iterable $this$filter$iv3;
                    File[] fileArray4 = fileArray3;
                    boolean $i$f$filter3 = false;
                    Iterator iterator = $this$filter$iv3;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    int n = ((void)$this$filterTo$iv$iv3).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv3[i];
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!(!this.getExpiryDateFromName((File)it).isAfter(ZonedDateTime.now()))) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    $this$filter$iv3 = (List)destination$iv$iv4;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File it = (File)element$iv;
                        boolean bl3 = false;
                        it.delete();
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                collection.add(unit);
            }
            List cfr_ignored_0 = (List)destination$iv$iv3;
        }
        return Unit.INSTANCE;
    }

    public void delete(@NotNull String subjectId, @NotNull String issuerId) throws FileKeystoreException {
        Intrinsics.checkNotNullParameter((Object)subjectId, (String)"subjectId");
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        boolean deletionSucceeded = FilesKt.deleteRecursively((File)this.getNodeSubdirectory(subjectId, issuerId));
        if (!deletionSucceeded) {
            throw new FileKeystoreException("Failed to delete node directory for " + subjectId, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCertificationFile(File certFile, byte[] serialization) {
        File parentDirectory = certFile.getParentFile();
        boolean wereDirectoriesCreated = parentDirectory.mkdirs();
        if (!wereDirectoriesCreated && !parentDirectory.exists()) {
            throw new FileKeystoreException("Failed to create address directory for certification files", null, 2, null);
        }
        try {
            Closeable closeable = new FileOutputStream(certFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                it.write(serialization);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save certification file", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] retrieveData(File file) {
        Object object;
        try {
            byte[] byArray;
            object = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to read certification file", exc);
        }
        return object;
    }

    private final long toTimestamp(ZonedDateTime $this$toTimestamp) {
        return $this$toTimestamp.toInstant().toEpochMilli();
    }

    private final ZonedDateTime toZonedDateTime(long $this$toZonedDateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli($this$toZonedDateTime), ZoneId.of("UTC"));
    }

    private final ZonedDateTime getExpiryDateFromName(File $this$getExpiryDateFromName) {
        String string = $this$getExpiryDateFromName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object object = new String[]{"-"};
        Long l = StringsKt.toLongOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null))));
        if (l == null || (object = this.toZonedDateTime(l)) == null) {
            throw new FileKeystoreException("Invalid certificate file name: " + $this$getExpiryDateFromName.getName(), null, 2, null);
        }
        return object;
    }

    private final File getNodeSubdirectory(String subjectId, String issuerId) {
        return FilesKt.resolve((File)FilesKt.resolve((File)this.rootDirectory, (String)issuerId), (String)subjectId);
    }
}

