/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.PrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0094@\u00a2\u0006\u0002\u0010\u0017J0\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0094@\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\u0007H\u0002J\"\u0010$\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010&\u001a\u0012\u0012\f\u0012\n '*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u0016H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007H$J\u0010\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020\u0007H$J\u0016\u0010-\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010/R\u0017\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u00060"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "<init>", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getRootDirectory$annotations", "()V", "getRootDirectory", "()Ljava/io/File;", "saveIdentityKeyData", "", "nodeId", "", "keyData", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/PrivateKeyData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveIdentityKeyData", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveAllIdentityKeyData", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveSessionKeySerialized", "keyId", "keySerialized", "", "peerId", "(Ljava/lang/String;[BLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveSessionKeySerialized", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveKeyFile", "keyFile", "serialization", "retrieveKeyData", "resolveSessionKeyFile", "getNodeSubdirectory", "getNodeDirectories", "kotlin.jvm.PlatformType", "makeEncryptedOutputStream", "Ljava/io/OutputStream;", "file", "makeEncryptedInputStream", "Ljava/io/InputStream;", "deleteKeys", "deleteBoundSessionKeys", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awala-keystore-file"})
@SourceDebugExtension(value={"SMAP\nFilePrivateKeyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePrivateKeyStore.kt\ntech/relaycorp/awala/keystores/file/FilePrivateKeyStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1#2:142\n1#2:157\n1557#3:143\n1628#3,3:144\n1611#3,9:147\n1863#3:156\n1864#3:158\n1620#3:159\n3829#4:160\n4344#4,2:161\n*S KotlinDebug\n*F\n+ 1 FilePrivateKeyStore.kt\ntech/relaycorp/awala/keystores/file/FilePrivateKeyStore\n*L\n33#1:157\n32#1:143\n32#1:144,3\n33#1:147,9\n33#1:156\n33#1:158\n33#1:159\n104#1:160\n104#1:161,2\n*E\n"})
public abstract class FilePrivateKeyStore
extends PrivateKeyStore {
    @NotNull
    private final File rootDirectory;

    public FilePrivateKeyStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"private");
    }

    @NotNull
    public final File getRootDirectory() {
        return this.rootDirectory;
    }

    public static /* synthetic */ void getRootDirectory$annotations() {
    }

    @Nullable
    protected Object saveIdentityKeyData(@NotNull String nodeId, @NotNull PrivateKeyData keyData, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveIdentityKeyData$suspendImpl(this, nodeId, keyData, $completion);
    }

    static /* synthetic */ Object saveIdentityKeyData$suspendImpl(FilePrivateKeyStore $this, String nodeId, PrivateKeyData keyData, Continuation<? super Unit> $completion) {
        File keyFile = FilesKt.resolve((File)$this.getNodeSubdirectory(nodeId), (String)"identity");
        $this.saveKeyFile(keyFile, keyData.getPrivateKeyDer());
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveIdentityKeyData(@NotNull String nodeId, @NotNull Continuation<? super PrivateKeyData> $completion) {
        return FilePrivateKeyStore.retrieveIdentityKeyData$suspendImpl(this, nodeId, $completion);
    }

    static /* synthetic */ Object retrieveIdentityKeyData$suspendImpl(FilePrivateKeyStore $this, String nodeId, Continuation<? super PrivateKeyData> $completion) {
        PrivateKeyData privateKeyData;
        File keyFile = FilesKt.resolve((File)$this.getNodeSubdirectory(nodeId), (String)"identity");
        byte[] byArray = $this.retrieveKeyData(keyFile);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            privateKeyData = new PrivateKeyData(it);
        } else {
            privateKeyData = null;
        }
        return privateKeyData;
    }

    @Nullable
    protected Object retrieveAllIdentityKeyData(@NotNull Continuation<? super List<? extends PrivateKeyData>> $completion) {
        return FilePrivateKeyStore.retrieveAllIdentityKeyData$suspendImpl(this, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object retrieveAllIdentityKeyData$suspendImpl(FilePrivateKeyStore $this, Continuation<? super List<? extends PrivateKeyData>> $completion) {
        List list;
        List<File> list2 = $this.getNodeDirectories();
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(FilesKt.resolve((File)it, (String)"identity"));
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PrivateKeyData privateKeyData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File path = (File)element$iv$iv;
                boolean bl2 = false;
                if ($this.retrieveKeyData(path) != null) {
                    byte[] it;
                    boolean bl3 = false;
                    privateKeyData = new PrivateKeyData(it);
                } else {
                    privateKeyData = null;
                }
                if (privateKeyData == null) continue;
                PrivateKeyData it$iv$iv = privateKeyData;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    protected Object saveSessionKeySerialized(@NotNull String keyId, @NotNull byte[] keySerialized, @NotNull String nodeId, @Nullable String peerId, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveSessionKeySerialized$suspendImpl(this, keyId, keySerialized, nodeId, peerId, $completion);
    }

    static /* synthetic */ Object saveSessionKeySerialized$suspendImpl(FilePrivateKeyStore $this, String keyId, byte[] keySerialized, String nodeId, String peerId, Continuation<? super Unit> $completion) {
        File keyFile = $this.resolveSessionKeyFile(nodeId, keyId, peerId);
        $this.saveKeyFile(keyFile, keySerialized);
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveSessionKeySerialized(@NotNull String keyId, @NotNull String nodeId, @NotNull String peerId, @NotNull Continuation<? super byte[]> $completion) {
        return FilePrivateKeyStore.retrieveSessionKeySerialized$suspendImpl(this, keyId, nodeId, peerId, $completion);
    }

    static /* synthetic */ Object retrieveSessionKeySerialized$suspendImpl(FilePrivateKeyStore $this, String keyId, String nodeId, String peerId, Continuation<? super byte[]> $completion) {
        File boundKeyPath = $this.resolveSessionKeyFile(nodeId, keyId, peerId);
        File unboundKeyPath = $this.resolveSessionKeyFile(nodeId, keyId, null);
        byte[] byArray = $this.retrieveKeyData(boundKeyPath);
        if (byArray == null) {
            byArray = $this.retrieveKeyData(unboundKeyPath);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveKeyFile(File keyFile, byte[] serialization) {
        File parentDirectory = keyFile.getParentFile();
        boolean wereDirectoriesCreated = parentDirectory.mkdirs();
        if (!wereDirectoriesCreated && !parentDirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for private keys", null, 2, null);
        }
        try {
            Closeable closeable = this.makeEncryptedOutputStream(keyFile);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                it.write(serialization);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key file", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] retrieveKeyData(File keyFile) {
        Object object;
        try {
            byte[] byArray;
            object = this.makeEncryptedInputStream(keyFile);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            if (keyFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        return object;
    }

    private final File resolveSessionKeyFile(String nodeId, String keyId, String peerId) {
        File nodeSubdirectory = FilesKt.resolve((File)this.getNodeSubdirectory(nodeId), (String)"session");
        File parentDirectory = peerId != null ? FilesKt.resolve((File)nodeSubdirectory, (String)peerId) : nodeSubdirectory;
        return FilesKt.resolve((File)parentDirectory, (String)keyId);
    }

    private final File getNodeSubdirectory(String nodeId) {
        return FilesKt.resolve((File)this.rootDirectory, (String)nodeId);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getNodeDirectories() {
        List list;
        File[] fileArray = this.rootDirectory.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void p0 = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    protected abstract OutputStream makeEncryptedOutputStream(@NotNull File var1);

    @NotNull
    protected abstract InputStream makeEncryptedInputStream(@NotNull File var1);

    @Nullable
    public Object deleteKeys(@NotNull String nodeId, @NotNull Continuation<? super Unit> $completion) throws FileKeystoreException {
        return FilePrivateKeyStore.deleteKeys$suspendImpl(this, nodeId, $completion);
    }

    static /* synthetic */ Object deleteKeys$suspendImpl(FilePrivateKeyStore $this, String nodeId, Continuation<? super Unit> $completion) throws FileKeystoreException {
        boolean deletionSucceeded = FilesKt.deleteRecursively((File)$this.getNodeSubdirectory(nodeId));
        if (!deletionSucceeded) {
            throw new FileKeystoreException("Failed to delete node directory for " + nodeId, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object deleteBoundSessionKeys(@NotNull String nodeId, @NotNull String peerId, @NotNull Continuation<? super Unit> $completion) throws FileKeystoreException {
        return FilePrivateKeyStore.deleteBoundSessionKeys$suspendImpl(this, nodeId, peerId, $completion);
    }

    static /* synthetic */ Object deleteBoundSessionKeys$suspendImpl(FilePrivateKeyStore $this, String nodeId, String peerId, Continuation<? super Unit> $completion) throws FileKeystoreException {
        boolean deletionSucceeded = FilesKt.deleteRecursively((File)FilesKt.resolve((File)FilesKt.resolve((File)$this.getNodeSubdirectory(nodeId), (String)"session"), (String)peerId));
        if (!deletionSucceeded) {
            throw new FileKeystoreException("Failed to delete session keys for node " + nodeId + " and peer " + peerId, null, 2, null);
        }
        return Unit.INSTANCE;
    }
}

