/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.SessionPublicKeyData;
import tech.relaycorp.relaynet.keystores.SessionPublicKeyStore;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Ltech/relaycorp/awala/keystores/file/FileSessionPublicKeystore;", "Ltech/relaycorp/relaynet/keystores/SessionPublicKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getRootDirectory$annotations", "()V", "getRootDirectory", "()Ljava/io/File;", "delete", "", "peerId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getKeyDataFile", "retrieveKeyData", "Ltech/relaycorp/relaynet/keystores/SessionPublicKeyData;", "saveKeyData", "keyData", "(Ltech/relaycorp/relaynet/keystores/SessionPublicKeyData;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awala-keystore-file"})
public final class FileSessionPublicKeystore
extends SessionPublicKeyStore {
    @NotNull
    private final File rootDirectory;

    public FileSessionPublicKeystore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"public");
    }

    @NotNull
    public final File getRootDirectory() {
        return this.rootDirectory;
    }

    public static /* synthetic */ void getRootDirectory$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object saveKeyData(@NotNull SessionPublicKeyData keyData, @NotNull String peerId, @NotNull Continuation<? super Unit> $completion) {
        byte[] byArray;
        boolean wasDirectoryCreated = this.rootDirectory.mkdirs();
        if (!wasDirectoryCreated && !this.rootDirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for public keys", null, 2, null);
        }
        File keyDataFile = this.getKeyDataFile(peerId);
        Closeable closeable = (Closeable)new BasicOutputBuffer();
        Throwable throwable = null;
        try {
            BasicOutputBuffer buffer = (BasicOutputBuffer)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new BsonBinaryWriter((BsonOutput)buffer);
            Throwable throwable2 = null;
            try {
                BsonBinaryWriter it = (BsonBinaryWriter)closeable2;
                boolean bl2 = false;
                it.writeStartDocument();
                it.writeBinaryData("key_id", new BsonBinary(keyData.getKeyId()));
                it.writeBinaryData("key_der", new BsonBinary(keyData.getKeyDer()));
                it.writeInt32("creation_timestamp", (int)keyData.getCreationTimestamp());
                it.writeEndDocument();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bsonSerialization = byArray;
        try {
            Intrinsics.checkNotNull((Object)bsonSerialization);
            FilesKt.writeBytes((File)keyDataFile, (byte[])bsonSerialization);
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key data to file", exc);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object retrieveKeyData(@NotNull String peerId, @NotNull Continuation<? super SessionPublicKeyData> $completion) {
        Closeable closeable;
        byte[] byArray;
        File keyDataFile = this.getKeyDataFile(peerId);
        try {
            byArray = FilesKt.readBytes((File)keyDataFile);
        }
        catch (IOException exc) {
            if (keyDataFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        byte[] serialization = byArray;
        try {
            SessionPublicKeyData sessionPublicKeyData;
            closeable = (Closeable)new BsonBinaryReader(ByteBuffer.wrap(serialization));
            Throwable throwable = null;
            try {
                BsonBinaryReader it = (BsonBinaryReader)closeable;
                boolean bl = false;
                it.readStartDocument();
                byte[] byArray2 = it.readBinaryData("key_id").getData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getData(...)");
                byte[] byArray3 = it.readBinaryData("key_der").getData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getData(...)");
                sessionPublicKeyData = new SessionPublicKeyData(byArray2, byArray3, (long)it.readInt32("creation_timestamp"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = sessionPublicKeyData;
        }
        catch (BSONException exc) {
            throw new FileKeystoreException("Key file is malformed", exc);
        }
        Closeable data = closeable;
        return data;
    }

    @Nullable
    public Object delete(@NotNull String peerId, @NotNull Continuation<? super Unit> $completion) {
        File keyDataFile = this.getKeyDataFile(peerId);
        keyDataFile.delete();
        return Unit.INSTANCE;
    }

    private final File getKeyDataFile(String peerId) {
        return FilesKt.resolve((File)this.rootDirectory, (String)peerId);
    }
}

