/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileCertificateStoreKt;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.CertificateStore;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0011\u0010\u0010\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J1\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000eH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\u00020\u001d*\u00020\u0006H\u0002J\f\u0010!\u001a\u00020\"*\u00020\u001dH\u0002J\u0014\u0010#\u001a\n $*\u0004\u0018\u00010\u001d0\u001d*\u00020\"H\u0002R\u0017\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Ltech/relaycorp/awala/keystores/file/FileCertificateStore;", "Ltech/relaycorp/relaynet/keystores/CertificateStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getRootDirectory$annotations", "()V", "getRootDirectory", "()Ljava/io/File;", "delete", "", "subjectPrivateAddress", "", "issuerPrivateAddress", "deleteExpired", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNodeSubdirectory", "retrieveData", "", "file", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveCertificationFile", "certFile", "serialization", "saveData", "leafCertificateExpiryDate", "Ljava/time/ZonedDateTime;", "certificationPathData", "(Ljava/lang/String;Ljava/time/ZonedDateTime;[BLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpiryDateFromName", "toTimestamp", "", "toZonedDateTime", "kotlin.jvm.PlatformType", "awala-keystore-file"})
public final class FileCertificateStore
extends CertificateStore {
    @NotNull
    private final File rootDirectory;

    public FileCertificateStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"certificate");
    }

    @NotNull
    public final File getRootDirectory() {
        return this.rootDirectory;
    }

    public static /* synthetic */ void getRootDirectory$annotations() {
    }

    @Nullable
    protected Object saveData(@NotNull String subjectPrivateAddress, @NotNull ZonedDateTime leafCertificateExpiryDate, @NotNull byte[] certificationPathData, @NotNull String issuerPrivateAddress, @NotNull Continuation<? super Unit> $completion) {
        long expirationTimestamp = this.toTimestamp(leafCertificateExpiryDate);
        String dataDigest = FileCertificateStoreKt.toDigest(certificationPathData);
        File certFile = FilesKt.resolve((File)this.getNodeSubdirectory(subjectPrivateAddress, issuerPrivateAddress), (String)("" + expirationTimestamp + '-' + dataDigest));
        this.saveCertificationFile(certFile, certificationPathData);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Object retrieveData(@NotNull String subjectPrivateAddress, @NotNull String issuerPrivateAddress, @NotNull Continuation<? super List<byte[]>> $completion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        File[] certificateFiles;
        File[] fileArray = this.getNodeSubdirectory(subjectPrivateAddress, issuerPrivateAddress).listFiles();
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        fileArray = certificateFiles = fileArray;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[i];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.getExpiryDateFromName((File)it).isAfter(ZonedDateTime.now())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray = this.retrieveData((File)it);
            collection.add(byArray);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object deleteExpired(@NotNull Continuation<? super Unit> $completion) {
        List list;
        File[] fileArray = this.getRootDirectory().listFiles();
        if (fileArray == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Object object = fileArray;
            boolean $i$f$filter22 = false;
            void var6_6 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                void p0 = element$iv$iv;
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            Iterable $i$f$filter22 = list2;
            boolean $i$f$flatMap22 = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                Object[] $this$orEmpty$iv = it.listFiles();
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    objectArray = new File[]{};
                }
                Iterable list$iv$iv = ArraysKt.toList((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv2;
            Iterable $i$f$flatMap22 = (Iterable)object;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File p0 = (File)element$iv$iv;
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv3;
            $this$filter$iv = list3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Unit unit;
                void addressFile;
                File p0 = (File)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                File[] fileArray2 = addressFile.listFiles();
                if (fileArray2 == null) {
                    unit = null;
                } else {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv3;
                    Iterable $this$filter$iv3;
                    File[] fileArray3 = fileArray2;
                    boolean $i$f$filter3 = false;
                    Iterator iterator = $this$filter$iv3;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    void var21_40 = $this$filterTo$iv$iv3;
                    int n = ((void)var21_40).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = var21_40[i];
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!(!this.getExpiryDateFromName((File)it).isAfter(ZonedDateTime.now()))) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    List list4 = (List)destination$iv$iv4;
                    $this$filter$iv3 = list4;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File it = (File)element$iv;
                        boolean bl3 = false;
                        it.delete();
                    }
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
                collection.add(unit2);
            }
            list = (List)destination$iv$iv3;
        }
        if (list == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return list;
        }
        return Unit.INSTANCE;
    }

    public void delete(@NotNull String subjectPrivateAddress, @NotNull String issuerPrivateAddress) throws FileKeystoreException {
        Intrinsics.checkNotNullParameter((Object)subjectPrivateAddress, (String)"subjectPrivateAddress");
        Intrinsics.checkNotNullParameter((Object)issuerPrivateAddress, (String)"issuerPrivateAddress");
        boolean deletionSucceeded = FilesKt.deleteRecursively((File)this.getNodeSubdirectory(subjectPrivateAddress, issuerPrivateAddress));
        if (!deletionSucceeded) {
            throw new FileKeystoreException(Intrinsics.stringPlus((String)"Failed to delete node directory for ", (Object)subjectPrivateAddress), null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCertificationFile(File certFile, byte[] serialization) {
        File parentDirectory = certFile.getParentFile();
        boolean wereDirectoriesCreated = parentDirectory.mkdirs();
        if (!wereDirectoriesCreated && !parentDirectory.exists()) {
            throw new FileKeystoreException("Failed to create address directory for certification files", null, 2, null);
        }
        try {
            Closeable closeable = new FileOutputStream(certFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl3 = false;
                it.write(serialization);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save certification file", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] retrieveData(File file) {
        Object object;
        try {
            byte[] byArray;
            object = new FileInputStream(file);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl3 = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to read certification file", exc);
        }
        return object;
    }

    private final long toTimestamp(ZonedDateTime $this$toTimestamp) {
        return $this$toTimestamp.toInstant().toEpochMilli();
    }

    private final ZonedDateTime toZonedDateTime(long $this$toZonedDateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli($this$toZonedDateTime), ZoneId.of("UTC"));
    }

    private final ZonedDateTime getExpiryDateFromName(File $this$getExpiryDateFromName) {
        ZonedDateTime zonedDateTime;
        String[] stringArray = $this$getExpiryDateFromName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"name");
        CharSequence charSequence = (CharSequence)stringArray;
        stringArray = new String[]{"-"};
        Long l = StringsKt.toLongOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
        ZonedDateTime zonedDateTime2 = zonedDateTime = l == null ? null : this.toZonedDateTime(l);
        if (zonedDateTime == null) {
            throw new FileKeystoreException(Intrinsics.stringPlus((String)"Invalid certificate file name: ", (Object)$this$getExpiryDateFromName.getName()), null, 2, null);
        }
        return zonedDateTime;
    }

    private final File getNodeSubdirectory(String subjectPrivateAddress, String issuerPrivateAddress) {
        return FilesKt.resolve((File)FilesKt.resolve((File)this.rootDirectory, (String)issuerPrivateAddress), (String)subjectPrivateAddress);
    }
}

