/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.awala.keystores.file.FilePrivateKeyStore;
import tech.relaycorp.relaynet.keystores.IdentityPrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H$J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0006H$J\"\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J+\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001aH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u001eH\u0002J)\u0010%\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00062\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\b0(\u00a2\u0006\u0002\b*H\u0002J3\u0010+\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\f\u0010.\u001a\u00020\u001a*\u00020\u001eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "deleteKeys", "", "privateAddress", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteSessionKeysForPeer", "peerPrivateAddress", "getNodeDirectories", "", "kotlin.jvm.PlatformType", "getNodeSubdirectory", "makeEncryptedInputStream", "Ljava/io/InputStream;", "file", "makeEncryptedOutputStream", "Ljava/io/OutputStream;", "resolveSessionKeyFile", "keyId", "retrieveAllIdentityKeyData", "Ltech/relaycorp/relaynet/keystores/IdentityPrivateKeyData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveIdentityKeyData", "retrieveKeyData", "", "keyFile", "retrieveSessionKeySerialized", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveIdentityKeyData", "keyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/IdentityPrivateKeyData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveKeyFile", "serialization", "bsonWriter", "Lkotlin/Function1;", "Lorg/bson/BsonBinaryWriter;", "Lkotlin/ExtensionFunctionType;", "saveSessionKeySerialized", "keySerialized", "(Ljava/lang/String;[BLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toIdentityPrivateKeyData", "Companion", "awala-keystore-file"})
public abstract class FilePrivateKeyStore
extends PrivateKeyStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDirectory;

    public FilePrivateKeyStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"private");
    }

    @Nullable
    protected Object saveIdentityKeyData(@NotNull String privateAddress, @NotNull IdentityPrivateKeyData keyData, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveIdentityKeyData$suspendImpl(this, privateAddress, keyData, $completion);
    }

    static /* synthetic */ Object saveIdentityKeyData$suspendImpl(FilePrivateKeyStore this_, String privateAddress, IdentityPrivateKeyData keyData, Continuation $completion) {
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)"IDENTITY");
        this_.saveKeyFile(keyFile, (Function1<? super BsonBinaryWriter, Unit>)((Function1)new Function1<BsonBinaryWriter, Unit>(keyData){
            final /* synthetic */ IdentityPrivateKeyData $keyData;
            {
                this.$keyData = $keyData;
                super(1);
            }

            public final void invoke(@NotNull BsonBinaryWriter $this$saveKeyFile) {
                Intrinsics.checkNotNullParameter((Object)$this$saveKeyFile, (String)"$this$saveKeyFile");
                $this$saveKeyFile.writeBinaryData("private_key", new BsonBinary(this.$keyData.getPrivateKeyDer()));
                $this$saveKeyFile.writeBinaryData("certificate", new BsonBinary(this.$keyData.getCertificateDer()));
            }
        }));
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveIdentityKeyData(@NotNull String privateAddress, @NotNull Continuation<? super IdentityPrivateKeyData> $completion) {
        return FilePrivateKeyStore.retrieveIdentityKeyData$suspendImpl(this, privateAddress, $completion);
    }

    static /* synthetic */ Object retrieveIdentityKeyData$suspendImpl(FilePrivateKeyStore this_, String privateAddress, Continuation $completion) {
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)"IDENTITY");
        byte[] byArray = this_.retrieveKeyData(keyFile);
        return byArray == null ? null : this_.toIdentityPrivateKeyData(byArray);
    }

    @Nullable
    protected Object retrieveAllIdentityKeyData(@NotNull Continuation<? super List<IdentityPrivateKeyData>> $completion) {
        return FilePrivateKeyStore.retrieveAllIdentityKeyData$suspendImpl(this, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object retrieveAllIdentityKeyData$suspendImpl(FilePrivateKeyStore this_, Continuation $completion) {
        List list;
        List list2;
        List<File> list3 = this_.getNodeDirectories();
        if (list3 == null) {
            list2 = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            File file;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable iterable = list3;
            boolean $i$f$map22 = false;
            void var7_7 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                file = FilesKt.resolve((File)it, (String)"IDENTITY");
                collection.add(file);
            }
            List list4 = (List)destination$iv$iv;
            Iterable $i$f$map22 = list4;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File p0 = (File)element$iv$iv;
                boolean bl = false;
                if (!p0.exists()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = iterable = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File p0 = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                byte[] byArray = this_.retrieveKeyData((File)it);
                Intrinsics.checkNotNull((Object)byArray);
                file = this_.toIdentityPrivateKeyData(byArray);
                collection.add(file);
            }
            list2 = (List)destination$iv$iv2;
        }
        List list5 = list2;
        if (list5 == null) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = list5;
        }
        return list;
    }

    @Nullable
    protected Object saveSessionKeySerialized(@NotNull String keyId, @NotNull byte[] keySerialized, @NotNull String privateAddress, @Nullable String peerPrivateAddress, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveSessionKeySerialized$suspendImpl(this, keyId, keySerialized, privateAddress, peerPrivateAddress, $completion);
    }

    static /* synthetic */ Object saveSessionKeySerialized$suspendImpl(FilePrivateKeyStore this_, String keyId, byte[] keySerialized, String privateAddress, String peerPrivateAddress, Continuation $completion) {
        File keyFile = this_.resolveSessionKeyFile(privateAddress, keyId, peerPrivateAddress);
        this_.saveKeyFile(keyFile, keySerialized);
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveSessionKeySerialized(@NotNull String keyId, @NotNull String privateAddress, @NotNull String peerPrivateAddress, @NotNull Continuation<? super byte[]> $completion) {
        return FilePrivateKeyStore.retrieveSessionKeySerialized$suspendImpl(this, keyId, privateAddress, peerPrivateAddress, $completion);
    }

    static /* synthetic */ Object retrieveSessionKeySerialized$suspendImpl(FilePrivateKeyStore this_, String keyId, String privateAddress, String peerPrivateAddress, Continuation $completion) {
        File boundKeyPath = this_.resolveSessionKeyFile(privateAddress, keyId, peerPrivateAddress);
        File unboundKeyPath = this_.resolveSessionKeyFile(privateAddress, keyId, null);
        byte[] byArray = this_.retrieveKeyData(boundKeyPath);
        return byArray == null ? this_.retrieveKeyData(unboundKeyPath) : byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveKeyFile(File keyFile, byte[] serialization) {
        File parentDirectory = keyFile.getParentFile();
        boolean wereDirectoriesCreated = parentDirectory.mkdirs();
        if (!wereDirectoriesCreated && !parentDirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for private keys", null, 2, null);
        }
        try {
            Closeable closeable = this.makeEncryptedOutputStream(keyFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl3 = false;
                it.write(serialization);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key file", exc);
        }
    }

    private final void saveKeyFile(File keyFile, Function1<? super BsonBinaryWriter, Unit> bsonWriter) {
        this.saveKeyFile(keyFile, Companion.bsonSerializeKeyData(bsonWriter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] retrieveKeyData(File keyFile) {
        Object object;
        try {
            byte[] byArray;
            object = this.makeEncryptedInputStream(keyFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl3 = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            if (keyFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        return object;
    }

    private final File resolveSessionKeyFile(String privateAddress, String keyId, String peerPrivateAddress) {
        File nodeSubdirectory = FilesKt.resolve((File)this.getNodeSubdirectory(privateAddress), (String)"session");
        File parentDirectory = peerPrivateAddress != null ? FilesKt.resolve((File)nodeSubdirectory, (String)peerPrivateAddress) : nodeSubdirectory;
        return FilesKt.resolve((File)parentDirectory, (String)keyId);
    }

    private final File getNodeSubdirectory(String privateAddress) {
        return FilesKt.resolve((File)this.rootDirectory, (String)privateAddress);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getNodeDirectories() {
        List list;
        File[] fileArray = this.rootDirectory.listFiles();
        if (fileArray == null) {
            list = null;
        } else {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var7_7 = $this$filterTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void p0 = element$iv$iv = var7_7[i];
                boolean bl = false;
                if (!p0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    protected abstract OutputStream makeEncryptedOutputStream(@NotNull File var1);

    @NotNull
    protected abstract InputStream makeEncryptedInputStream(@NotNull File var1);

    private final IdentityPrivateKeyData toIdentityPrivateKeyData(byte[] $this$toIdentityPrivateKeyData) {
        return (IdentityPrivateKeyData)Companion.bsonDeserializeKeyData($this$toIdentityPrivateKeyData, toIdentityPrivateKeyData.1.INSTANCE);
    }

    @Nullable
    public Object deleteKeys(@NotNull String privateAddress, @NotNull Continuation<? super Unit> $completion) throws FileKeystoreException {
        return FilePrivateKeyStore.deleteKeys$suspendImpl(this, privateAddress, $completion);
    }

    static /* synthetic */ Object deleteKeys$suspendImpl(FilePrivateKeyStore this_, String privateAddress, Continuation $completion) throws FileKeystoreException {
        boolean deletionSucceeded = FilesKt.deleteRecursively((File)this_.getNodeSubdirectory(privateAddress));
        if (!deletionSucceeded) {
            throw new FileKeystoreException(Intrinsics.stringPlus((String)"Failed to delete node directory for ", (Object)privateAddress), null, 2, null);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object deleteSessionKeysForPeer(@NotNull String peerPrivateAddress, @NotNull Continuation<? super Unit> $completion) throws FileKeystoreException {
        return FilePrivateKeyStore.deleteSessionKeysForPeer$suspendImpl(this, peerPrivateAddress, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object deleteSessionKeysForPeer$suspendImpl(FilePrivateKeyStore this_, String peerPrivateAddress, Continuation $completion) throws FileKeystoreException {
        Boolean deletionSucceeded;
        Boolean bl;
        List<File> list = this_.getNodeDirectories();
        if (list == null) {
            bl = null;
        } else {
            boolean bl2;
            block9: {
                void $this$all$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Comparable<File> comparable;
                Collection collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable = list;
                boolean $i$f$map22 = false;
                void var8_7 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    comparable = FilesKt.resolve((File)FilesKt.resolve((File)it, (String)"session"), (String)peerPrivateAddress);
                    collection.add(comparable);
                }
                List list2 = (List)destination$iv$iv;
                Iterable $i$f$map22 = list2;
                boolean $i$f$filter22 = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File p0 = (File)element$iv$iv;
                    boolean bl4 = false;
                    if (!p0.exists()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = iterable = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                destination$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    File bl4 = (File)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl5 = false;
                    comparable = Boxing.boxBoolean((boolean)FilesKt.deleteRecursively((File)p0));
                    collection.add(comparable);
                }
                List list3 = (List)destination$iv$iv3;
                $this$map$iv = list3;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl6 = false;
                        if (it) continue;
                        bl2 = false;
                        break block9;
                    }
                    bl2 = true;
                }
            }
            bl = deletionSucceeded = Boxing.boxBoolean((boolean)bl2);
        }
        if (Intrinsics.areEqual(deletionSucceeded, (Object)Boxing.boxBoolean((boolean)false))) {
            throw new FileKeystoreException(Intrinsics.stringPlus((String)"Failed to delete all keys for peer ", (Object)peerPrivateAddress), null, 2, null);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00040\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u00020\u00072\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\b\u000b\u00a8\u0006\u0011"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore$Companion;", "", "()V", "bsonDeserializeKeyData", "T", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "serialization", "", "reader", "Lkotlin/Function1;", "Lorg/bson/BsonBinaryReader;", "Lkotlin/ExtensionFunctionType;", "([BLkotlin/jvm/functions/Function1;)Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "bsonSerializeKeyData", "writer", "Lorg/bson/BsonBinaryWriter;", "", "awala-keystore-file"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] bsonSerializeKeyData(@NotNull Function1<? super BsonBinaryWriter, Unit> writer) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            Closeable closeable = (Closeable)new BasicOutputBuffer();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BasicOutputBuffer buffer = (BasicOutputBuffer)closeable;
                boolean bl3 = false;
                Closeable closeable2 = (Closeable)new BsonBinaryWriter((BsonOutput)buffer);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    BsonBinaryWriter it = (BsonBinaryWriter)closeable2;
                    boolean bl6 = false;
                    it.writeStartDocument();
                    writer.invoke((Object)it);
                    it.writeEndDocument();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                byArray = buffer.toByteArray();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray2 = byArray;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"BasicOutputBuffer().use \u2026ByteArray()\n            }");
            return byArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final <T extends PrivateKeyData> T bsonDeserializeKeyData(@NotNull byte[] serialization, @NotNull Function1<? super BsonBinaryReader, ? extends T> reader) {
            Closeable closeable;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            Intrinsics.checkNotNullParameter(reader, (String)"reader");
            try {
                PrivateKeyData privateKeyData;
                closeable = (Closeable)new BsonBinaryReader(ByteBuffer.wrap(serialization));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    BsonBinaryReader it = (BsonBinaryReader)closeable;
                    boolean bl3 = false;
                    it.readStartDocument();
                    privateKeyData = (PrivateKeyData)reader.invoke((Object)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = privateKeyData;
            }
            catch (BSONException exc) {
                throw new FileKeystoreException("Key file is malformed", exc);
            }
            return (T)closeable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

