/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.awala.keystores.file.FilePrivateKeyStore;
import tech.relaycorp.relaynet.keystores.IdentityPrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;
import tech.relaycorp.relaynet.keystores.SessionPrivateKeyData;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H$J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006H$J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J#\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0011H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00062\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001d0\"\u00a2\u0006\u0002\b$H\u0002J)\u0010%\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\f\u0010'\u001a\u00020\u0011*\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getNodeSubdirectory", "privateAddress", "", "makeEncryptedInputStream", "Ljava/io/InputStream;", "file", "makeEncryptedOutputStream", "Ljava/io/OutputStream;", "retrieveAllIdentityKeyData", "", "Ltech/relaycorp/relaynet/keystores/IdentityPrivateKeyData;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveIdentityKeyData", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveKeyData", "", "keyFile", "retrieveSessionKeyData", "Ltech/relaycorp/relaynet/keystores/SessionPrivateKeyData;", "keyId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveIdentityKeyData", "", "keyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/IdentityPrivateKeyData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveKeyFile", "bsonWriter", "Lkotlin/Function1;", "Lorg/bson/BsonBinaryWriter;", "Lkotlin/ExtensionFunctionType;", "saveSessionKeyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/SessionPrivateKeyData;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toIdentityPrivateKeyData", "Companion", "awala-keystore-file"})
public abstract class FilePrivateKeyStore
extends PrivateKeyStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDirectory;

    public FilePrivateKeyStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"private");
    }

    @Nullable
    protected Object saveIdentityKeyData(@NotNull String privateAddress, @NotNull IdentityPrivateKeyData keyData, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveIdentityKeyData$suspendImpl(this, privateAddress, keyData, $completion);
    }

    static /* synthetic */ Object saveIdentityKeyData$suspendImpl(FilePrivateKeyStore this_, String privateAddress, IdentityPrivateKeyData keyData, Continuation $completion) {
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)"IDENTITY");
        this_.saveKeyFile(keyFile, (Function1<? super BsonBinaryWriter, Unit>)((Function1)new Function1<BsonBinaryWriter, Unit>(keyData){
            final /* synthetic */ IdentityPrivateKeyData $keyData;
            {
                this.$keyData = $keyData;
                super(1);
            }

            public final void invoke(@NotNull BsonBinaryWriter $this$saveKeyFile) {
                Intrinsics.checkNotNullParameter((Object)$this$saveKeyFile, (String)"$this$saveKeyFile");
                $this$saveKeyFile.writeBinaryData("private_key", new BsonBinary(this.$keyData.getPrivateKeyDer()));
                $this$saveKeyFile.writeBinaryData("certificate", new BsonBinary(this.$keyData.getCertificateDer()));
            }
        }));
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveIdentityKeyData(@NotNull String privateAddress, @NotNull Continuation<? super IdentityPrivateKeyData> $completion) {
        return FilePrivateKeyStore.retrieveIdentityKeyData$suspendImpl(this, privateAddress, $completion);
    }

    static /* synthetic */ Object retrieveIdentityKeyData$suspendImpl(FilePrivateKeyStore this_, String privateAddress, Continuation $completion) {
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)"IDENTITY");
        byte[] byArray = this_.retrieveKeyData(keyFile);
        return byArray == null ? null : this_.toIdentityPrivateKeyData(byArray);
    }

    @Nullable
    protected Object retrieveAllIdentityKeyData(@NotNull Continuation<? super List<IdentityPrivateKeyData>> $completion) {
        return FilePrivateKeyStore.retrieveAllIdentityKeyData$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ Object retrieveAllIdentityKeyData$suspendImpl(FilePrivateKeyStore this, Continuation $completion) {
        block7: {
            block6: {
                var3_2 = this.rootDirectory.listFiles();
                if (var3_2 != null) break block6;
                v0 = null;
                break block7;
            }
            $this$filter$iv /* !! */  = var3_2;
            $i$f$filter = false;
            var7_6 = $this$filter$iv /* !! */ ;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var10_9 = $this$filterTo$iv$iv;
            var11_10 = ((void)var10_9).length;
            for (var12_12 = 0; var12_12 < var11_10; ++var12_12) {
                it = element$iv$iv = var10_9[var12_12];
                $i$a$-filter-FilePrivateKeyStore$retrieveAllIdentityKeyData$2 = false;
                if (!it.isDirectory()) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (FilesKt.resolve((File)it, (String)"IDENTITY").exists()) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var4_18 = (List)destination$iv$iv;
            $this$filter$iv /* !! */  = var4_18;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var12_13 = (File)item$iv$iv;
                var16_19 = destination$iv$iv;
                $i$a$-map-FilePrivateKeyStore$retrieveAllIdentityKeyData$3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                v2 = this.retrieveKeyData(FilesKt.resolve((File)it, (String)"IDENTITY"));
                Intrinsics.checkNotNull((Object)v2);
                var17_20 = this.toIdentityPrivateKeyData(v2);
                var16_19.add(var17_20);
            }
            v0 = (List)destination$iv$iv;
        }
        var2_21 = v0;
        if (var2_21 == null) {
            var3_3 = false;
            v3 = CollectionsKt.emptyList();
        } else {
            v3 = var2_21;
        }
        return v3;
    }

    @Nullable
    protected Object saveSessionKeyData(@NotNull String keyId, @NotNull SessionPrivateKeyData keyData, @NotNull String privateAddress, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveSessionKeyData$suspendImpl(this, keyId, keyData, privateAddress, $completion);
    }

    static /* synthetic */ Object saveSessionKeyData$suspendImpl(FilePrivateKeyStore this_, String keyId, SessionPrivateKeyData keyData, String privateAddress, Continuation $completion) {
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)Intrinsics.stringPlus((String)"s-", (Object)keyId));
        this_.saveKeyFile(keyFile, (Function1<? super BsonBinaryWriter, Unit>)((Function1)new Function1<BsonBinaryWriter, Unit>(keyData){
            final /* synthetic */ SessionPrivateKeyData $keyData;
            {
                this.$keyData = $keyData;
                super(1);
            }

            public final void invoke(@NotNull BsonBinaryWriter $this$saveKeyFile) {
                Intrinsics.checkNotNullParameter((Object)$this$saveKeyFile, (String)"$this$saveKeyFile");
                $this$saveKeyFile.writeBinaryData("private_key", new BsonBinary(this.$keyData.getPrivateKeyDer()));
                String string = this.$keyData.getPeerPrivateAddress();
                $this$saveKeyFile.writeString("peer_private_address", string == null ? "" : string);
            }
        }));
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveSessionKeyData(@NotNull String keyId, @NotNull String privateAddress, @NotNull Continuation<? super SessionPrivateKeyData> $completion) {
        return FilePrivateKeyStore.retrieveSessionKeyData$suspendImpl(this, keyId, privateAddress, $completion);
    }

    static /* synthetic */ Object retrieveSessionKeyData$suspendImpl(FilePrivateKeyStore this_, String keyId, String privateAddress, Continuation $completion) {
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)Intrinsics.stringPlus((String)"s-", (Object)keyId));
        byte[] byArray = this_.retrieveKeyData(keyFile);
        if (byArray == null) {
            return null;
        }
        byte[] serialization = byArray;
        return Companion.bsonDeserializeKeyData(serialization, retrieveSessionKeyData.2.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveKeyFile(File keyFile, Function1<? super BsonBinaryWriter, Unit> bsonWriter) {
        File parentDirectory = keyFile.getParentFile();
        boolean wereDirectoriesCreated = parentDirectory.mkdirs();
        if (!wereDirectoriesCreated && !parentDirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for private keys", null, 2, null);
        }
        try {
            Closeable closeable = this.makeEncryptedOutputStream(keyFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl3 = false;
                it.write(Companion.bsonSerializeKeyData(bsonWriter));
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key file", exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] retrieveKeyData(File keyFile) {
        Object object;
        try {
            byte[] byArray;
            object = this.makeEncryptedInputStream(keyFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl3 = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            if (keyFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        return object;
    }

    private final File getNodeSubdirectory(String privateAddress) {
        return FilesKt.resolve((File)this.rootDirectory, (String)privateAddress);
    }

    @NotNull
    protected abstract OutputStream makeEncryptedOutputStream(@NotNull File var1);

    @NotNull
    protected abstract InputStream makeEncryptedInputStream(@NotNull File var1);

    private final IdentityPrivateKeyData toIdentityPrivateKeyData(byte[] $this$toIdentityPrivateKeyData) {
        return (IdentityPrivateKeyData)Companion.bsonDeserializeKeyData($this$toIdentityPrivateKeyData, toIdentityPrivateKeyData.1.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00040\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u00020\u00072\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\b\u000b\u00a8\u0006\u0011"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore$Companion;", "", "()V", "bsonDeserializeKeyData", "T", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "serialization", "", "reader", "Lkotlin/Function1;", "Lorg/bson/BsonBinaryReader;", "Lkotlin/ExtensionFunctionType;", "([BLkotlin/jvm/functions/Function1;)Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "bsonSerializeKeyData", "writer", "Lorg/bson/BsonBinaryWriter;", "", "awala-keystore-file"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] bsonSerializeKeyData(@NotNull Function1<? super BsonBinaryWriter, Unit> writer) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            Closeable closeable = (Closeable)new BasicOutputBuffer();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BasicOutputBuffer buffer = (BasicOutputBuffer)closeable;
                boolean bl3 = false;
                Closeable closeable2 = (Closeable)new BsonBinaryWriter((BsonOutput)buffer);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    BsonBinaryWriter it = (BsonBinaryWriter)closeable2;
                    boolean bl6 = false;
                    it.writeStartDocument();
                    writer.invoke((Object)it);
                    it.writeEndDocument();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                byArray = buffer.toByteArray();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray2 = byArray;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"BasicOutputBuffer().use \u2026ByteArray()\n            }");
            return byArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final <T extends PrivateKeyData> T bsonDeserializeKeyData(@NotNull byte[] serialization, @NotNull Function1<? super BsonBinaryReader, ? extends T> reader) {
            Closeable closeable;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            Intrinsics.checkNotNullParameter(reader, (String)"reader");
            try {
                PrivateKeyData privateKeyData;
                closeable = (Closeable)new BsonBinaryReader(ByteBuffer.wrap(serialization));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    BsonBinaryReader it = (BsonBinaryReader)closeable;
                    boolean bl3 = false;
                    it.readStartDocument();
                    privateKeyData = (PrivateKeyData)reader.invoke((Object)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = privateKeyData;
            }
            catch (BSONException exc) {
                throw new FileKeystoreException("Key file is malformed", exc);
            }
            return (T)closeable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

