/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.SessionPublicKeyData;
import tech.relaycorp.relaynet.keystores.SessionPublicKeyStore;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ!\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Ltech/relaycorp/awala/keystores/file/FileSessionPublicKeystore;", "Ltech/relaycorp/relaynet/keystores/SessionPublicKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "delete", "", "peerPrivateAddress", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getKeyDataFile", "retrieveKeyData", "Ltech/relaycorp/relaynet/keystores/SessionPublicKeyData;", "saveKeyData", "keyData", "(Ltech/relaycorp/relaynet/keystores/SessionPublicKeyData;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awala-keystore-file"})
public final class FileSessionPublicKeystore
extends SessionPublicKeyStore {
    @NotNull
    private final File rootDirectory;

    public FileSessionPublicKeystore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object saveKeyData(@NotNull SessionPublicKeyData keyData, @NotNull String peerPrivateAddress, @NotNull Continuation<? super Unit> $completion) {
        byte[] byArray;
        boolean wasDirectoryCreated = this.rootDirectory.mkdir();
        if (!wasDirectoryCreated && !this.rootDirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for public keys", null, 2, null);
        }
        File keyDataFile = this.getKeyDataFile(peerPrivateAddress);
        Closeable closeable = (Closeable)new BasicOutputBuffer();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BasicOutputBuffer buffer = (BasicOutputBuffer)closeable;
            boolean bl3 = false;
            Closeable closeable2 = (Closeable)new BsonBinaryWriter((BsonOutput)buffer);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                BsonBinaryWriter it = (BsonBinaryWriter)closeable2;
                boolean bl6 = false;
                it.writeStartDocument();
                it.writeBinaryData("key_id", new BsonBinary(keyData.getKeyId()));
                it.writeBinaryData("key_der", new BsonBinary(keyData.getKeyDer()));
                it.writeInt32("creation_timestamp", (int)keyData.getCreationTimestamp());
                it.writeEndDocument();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bsonSerialization = byArray;
        try {
            Intrinsics.checkNotNullExpressionValue((Object)bsonSerialization, (String)"bsonSerialization");
            FilesKt.writeBytes((File)keyDataFile, (byte[])bsonSerialization);
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key data to file", exc);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Object retrieveKeyData(@NotNull String peerPrivateAddress, @NotNull Continuation<? super SessionPublicKeyData> $completion) {
        Closeable closeable;
        byte[] byArray;
        File keyDataFile = this.getKeyDataFile(peerPrivateAddress);
        try {
            byArray = FilesKt.readBytes((File)keyDataFile);
        }
        catch (IOException exc) {
            if (keyDataFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        byte[] serialization = byArray;
        try {
            SessionPublicKeyData sessionPublicKeyData;
            closeable = (Closeable)new BsonBinaryReader(ByteBuffer.wrap(serialization));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BsonBinaryReader it = (BsonBinaryReader)closeable;
                boolean bl3 = false;
                it.readStartDocument();
                byte[] byArray2 = it.readBinaryData("key_id").getData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"it.readBinaryData(\"key_id\").data");
                byte[] byArray3 = byArray2;
                byArray2 = it.readBinaryData("key_der").getData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"it.readBinaryData(\"key_der\").data");
                sessionPublicKeyData = new SessionPublicKeyData(byArray3, byArray2, (long)it.readInt32("creation_timestamp"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = sessionPublicKeyData;
        }
        catch (BSONException exc) {
            throw new FileKeystoreException("Key file is malformed", exc);
        }
        Closeable data = closeable;
        return data;
    }

    @Nullable
    public Object delete(@NotNull String peerPrivateAddress, @NotNull Continuation<? super Unit> $completion) {
        File keyDataFile = this.getKeyDataFile(peerPrivateAddress);
        keyDataFile.delete();
        return Unit.INSTANCE;
    }

    private final File getKeyDataFile(String peerPrivateAddress) {
        return FilesKt.resolve((File)this.rootDirectory, (String)peerPrivateAddress);
    }
}

