/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;
import tech.relaycorp.awala.keystores.file.FileKeystoreRoot;
import tech.relaycorp.relaynet.keystores.PrivateKeyData;
import tech.relaycorp.relaynet.keystores.PrivateKeyStore;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H$J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006H$J#\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J)\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore;", "Ltech/relaycorp/relaynet/keystores/PrivateKeyStore;", "keystoreRoot", "Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "(Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;)V", "rootDirectory", "Ljava/io/File;", "getNodeSubdirectory", "privateAddress", "", "makeEncryptedInputStream", "Ljava/io/InputStream;", "file", "makeEncryptedOutputStream", "Ljava/io/OutputStream;", "retrieveKeyData", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "keyId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveKeyData", "", "keyData", "(Ljava/lang/String;Ltech/relaycorp/relaynet/keystores/PrivateKeyData;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "awala-keystore-file"})
public abstract class FilePrivateKeyStore
extends PrivateKeyStore {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDirectory;

    public FilePrivateKeyStore(@NotNull FileKeystoreRoot keystoreRoot) {
        Intrinsics.checkNotNullParameter((Object)keystoreRoot, (String)"keystoreRoot");
        this.rootDirectory = FilesKt.resolve((File)keystoreRoot.getDirectory$awala_keystore_file(), (String)"private");
    }

    @Nullable
    protected Object saveKeyData(@NotNull String keyId, @NotNull PrivateKeyData keyData, @NotNull String privateAddress, @NotNull Continuation<? super Unit> $completion) {
        return FilePrivateKeyStore.saveKeyData$suspendImpl(this, keyId, keyData, privateAddress, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object saveKeyData$suspendImpl(FilePrivateKeyStore this_, String keyId, PrivateKeyData keyData, String privateAddress, Continuation $completion) {
        File nodeSubdirectory = this_.getNodeSubdirectory(privateAddress);
        boolean wereDirectoriesCreated = nodeSubdirectory.mkdirs();
        if (!wereDirectoriesCreated && !nodeSubdirectory.exists()) {
            throw new FileKeystoreException("Failed to create root directory for private keys", null, 2, null);
        }
        File keyFile = FilesKt.resolve((File)nodeSubdirectory, (String)keyId);
        byte[] bsonSerialization = Companion.bsonSerializeKeyData(keyData);
        try {
            Closeable closeable = this_.makeEncryptedOutputStream(keyFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl3 = false;
                it.write(bsonSerialization);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exc) {
            throw new FileKeystoreException("Failed to save key file", exc);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object retrieveKeyData(@NotNull String keyId, @NotNull String privateAddress, @NotNull Continuation<? super PrivateKeyData> $completion) {
        return FilePrivateKeyStore.retrieveKeyData$suspendImpl(this, keyId, privateAddress, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Object retrieveKeyData$suspendImpl(FilePrivateKeyStore this_, String keyId, String privateAddress, Continuation $completion) {
        Object object;
        File keyFile = FilesKt.resolve((File)this_.getNodeSubdirectory(privateAddress), (String)keyId);
        try {
            byte[] byArray;
            object = this_.makeEncryptedInputStream(keyFile);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl3 = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (IOException exc) {
            if (keyFile.exists()) {
                throw new FileKeystoreException("Failed to read key file", exc);
            }
            return null;
        }
        Object serialization = object;
        try {
            object = Companion.bsonDeserializeKeyData((byte[])serialization);
        }
        catch (BSONException exc) {
            throw new FileKeystoreException("Key file is malformed", exc);
        }
        return object;
    }

    private final File getNodeSubdirectory(String privateAddress) {
        return FilesKt.resolve((File)this.rootDirectory, (String)privateAddress);
    }

    @NotNull
    protected abstract OutputStream makeEncryptedOutputStream(@NotNull File var1);

    @NotNull
    protected abstract InputStream makeEncryptedInputStream(@NotNull File var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Ltech/relaycorp/awala/keystores/file/FilePrivateKeyStore$Companion;", "", "()V", "bsonDeserializeKeyData", "Ltech/relaycorp/relaynet/keystores/PrivateKeyData;", "serialization", "", "bsonSerializeKeyData", "keyData", "awala-keystore-file"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] bsonSerializeKeyData(@NotNull PrivateKeyData keyData) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
            Closeable closeable = (Closeable)new BasicOutputBuffer();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BasicOutputBuffer buffer = (BasicOutputBuffer)closeable;
                boolean bl3 = false;
                Closeable closeable2 = (Closeable)new BsonBinaryWriter((BsonOutput)buffer);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    BsonBinaryWriter it = (BsonBinaryWriter)closeable2;
                    boolean bl6 = false;
                    it.writeStartDocument();
                    it.writeBinaryData("private_key", new BsonBinary(keyData.getPrivateKeyDer()));
                    Object object = keyData.getCertificateDer();
                    it.writeBinaryData("certificate", new BsonBinary(object == null ? new byte[]{} : object));
                    object = keyData.getPeerPrivateAddress();
                    it.writeString("peer_private_address", (String)(object == null ? "" : (Object)object));
                    it.writeEndDocument();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                byArray = buffer.toByteArray();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray2 = byArray;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"BasicOutputBuffer().use \u2026ByteArray()\n            }");
            return byArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PrivateKeyData bsonDeserializeKeyData(@NotNull byte[] serialization) {
            PrivateKeyData privateKeyData;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            Closeable closeable = (Closeable)new BsonBinaryReader(ByteBuffer.wrap(serialization));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object object;
                BsonBinaryReader it = (BsonBinaryReader)closeable;
                boolean bl3 = false;
                it.readStartDocument();
                byte[] privateKeyDer = it.readBinaryData("private_key").getData();
                byte[] certificateDer = it.readBinaryData("certificate").getData();
                String peerPrivateAddress = it.readString("peer_private_address");
                Intrinsics.checkNotNullExpressionValue((Object)privateKeyDer, (String)"privateKeyDer");
                byte[] byArray = privateKeyDer;
                Intrinsics.checkNotNullExpressionValue((Object)certificateDer, (String)"certificateDer");
                Object object2 = certificateDer;
                boolean bl4 = false;
                byte[] byArray2 = object2;
                boolean bl5 = false;
                Object object3 = !(byArray2.length == 0) ? certificateDer : null;
                object2 = peerPrivateAddress;
                bl4 = false;
                byArray2 = object2;
                bl5 = false;
                if (byArray2.length() == 0) {
                    byte[] byArray3 = object3;
                    byte[] byArray4 = byArray;
                    boolean bl6 = false;
                    Object var17_20 = null;
                    byArray = byArray4;
                    object3 = byArray3;
                    object = var17_20;
                } else {
                    object = object2;
                }
                String string = (String)object;
                byte[] byArray5 = object3;
                byte[] byArray6 = byArray;
                privateKeyData = new PrivateKeyData(byArray6, byArray5, string);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return privateKeyData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

