/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "", "directory", "Ljava/io/File;", "(Ljava/io/File;)V", "getDirectory$awala_keystore_file", "()Ljava/io/File;", "awala-keystore-file"})
public final class FileKeystoreRoot {
    @NotNull
    private final File directory;

    public FileKeystoreRoot(@NotNull File directory) throws FileKeystoreException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
        if (!this.directory.isAbsolute()) {
            throw new FileKeystoreException("Root directory must use an absolute path (got '" + this.directory.getPath() + "')", null, 2, null);
        }
        if (!this.directory.exists()) {
            throw new FileKeystoreException("Root '" + this.directory.getPath() + "' doesn't exist", null, 2, null);
        }
        if (!this.directory.isDirectory()) {
            throw new FileKeystoreException("Root '" + this.directory.getPath() + "' isn't a directory", null, 2, null);
        }
        if (!this.directory.canRead()) {
            throw new FileKeystoreException("Root '" + this.directory.getPath() + "' isn't readable", null, 2, null);
        }
        if (!this.directory.canWrite()) {
            throw new FileKeystoreException("Root '" + this.directory.getPath() + "' isn't writable", null, 2, null);
        }
    }

    @NotNull
    public final File getDirectory$awala_keystore_file() {
        return this.directory;
    }
}

