/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.awala.keystores.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.awala.keystores.file.FileKeystoreException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/awala/keystores/file/FileKeystoreRoot;", "", "directory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getDirectory$awala_keystore_file", "()Ljava/nio/file/Path;", "awala-keystore-file"})
public final class FileKeystoreRoot {
    @NotNull
    private final Path directory;

    public FileKeystoreRoot(@NotNull Path directory) throws FileKeystoreException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
        if (!this.directory.isAbsolute()) {
            Path path = this.directory;
            boolean bl = false;
            throw new FileKeystoreException("Root directory must use an absolute path (got '" + ((Object)path).toString() + "')", null, 2, null);
        }
        Path path = this.directory;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            path = this.directory;
            boolean bl2 = false;
            throw new FileKeystoreException("Root '" + ((Object)path).toString() + "' doesn't exist", null, 2, null);
        }
        path = this.directory;
        linkOptionArray = new LinkOption[]{};
        bl = false;
        if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            path = this.directory;
            boolean bl3 = false;
            throw new FileKeystoreException("Root '" + ((Object)path).toString() + "' isn't a directory", null, 2, null);
        }
        path = this.directory;
        boolean bl4 = false;
        if (!Files.isReadable(path)) {
            path = this.directory;
            bl4 = false;
            throw new FileKeystoreException("Root '" + ((Object)path).toString() + "' isn't readable", null, 2, null);
        }
        path = this.directory;
        bl4 = false;
        if (!Files.isWritable(path)) {
            path = this.directory;
            bl4 = false;
            throw new FileKeystoreException("Root '" + ((Object)path).toString() + "' isn't writable", null, 2, null);
        }
    }

    @NotNull
    public final Path getDirectory$awala_keystore_file() {
        return this.directory;
    }
}

